/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Paint;
import android.text.TextPaint;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.AndroidPaint_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.text.platform.extensions.TextPaintExtensions_androidKt;
import androidx.compose.ui.text.style.TextDecoration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u0005\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&J\u001b\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010-\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010.\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR4\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0012\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f*\u0004\b\n\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00158\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006/"}, d2={"Landroidx/compose/ui/text/platform/AndroidTextPaint;", "Landroid/text/TextPaint;", "flags", "", "density", "", "(IF)V", "<set-?>", "Landroidx/compose/ui/graphics/BlendMode;", "blendMode", "getBlendMode-0nO6VwU$delegate", "(Landroidx/compose/ui/text/platform/AndroidTextPaint;)Ljava/lang/Object;", "getBlendMode-0nO6VwU", "()I", "setBlendMode-s9anfk8", "(I)V", "composePaint", "Landroidx/compose/ui/graphics/Paint;", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "getShadow$ui_text_release$annotations", "()V", "getShadow$ui_text_release", "()Landroidx/compose/ui/graphics/Shadow;", "setShadow$ui_text_release", "(Landroidx/compose/ui/graphics/Shadow;)V", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "setBrush", "", "brush", "Landroidx/compose/ui/graphics/Brush;", "size", "Landroidx/compose/ui/geometry/Size;", "alpha", "setBrush-12SF9DM", "(Landroidx/compose/ui/graphics/Brush;JF)V", "setColor", "color", "Landroidx/compose/ui/graphics/Color;", "setColor-8_81llA", "(J)V", "setDrawStyle", "setShadow", "setTextDecoration", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nAndroidTextPaint.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTextPaint.android.kt\nandroidx/compose/ui/text/platform/AndroidTextPaint\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,143:1\n646#2:144\n646#2:145\n152#3:146\n*S KotlinDebug\n*F\n+ 1 AndroidTextPaint.android.kt\nandroidx/compose/ui/text/platform/AndroidTextPaint\n*L\n83#1:144\n92#1:145\n93#1:146\n*E\n"})
public final class AndroidTextPaint
extends TextPaint {
    @NotNull
    private final androidx.compose.ui.graphics.Paint composePaint;
    @NotNull
    private TextDecoration textDecoration;
    @NotNull
    private Shadow shadow;
    @Nullable
    private DrawStyle drawStyle;

    public AndroidTextPaint(int flags, float density) {
        super(flags);
        this.density = density;
        this.composePaint = AndroidPaint_androidKt.toComposePaint((Paint)((Paint)this));
        this.textDecoration = TextDecoration.Companion.getNone();
        this.shadow = Shadow.Companion.getNone();
    }

    @NotNull
    public final Shadow getShadow$ui_text_release() {
        return this.shadow;
    }

    public final void setShadow$ui_text_release(@NotNull Shadow shadow) {
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"<set-?>");
        this.shadow = shadow;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getShadow$ui_text_release$annotations() {
    }

    public final void setTextDecoration(@Nullable TextDecoration textDecoration) {
        if (textDecoration == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.textDecoration, (Object)textDecoration)) {
            this.textDecoration = textDecoration;
            this.setUnderlineText(this.textDecoration.contains(TextDecoration.Companion.getUnderline()));
            this.setStrikeThruText(this.textDecoration.contains(TextDecoration.Companion.getLineThrough()));
        }
    }

    public final void setShadow(@Nullable Shadow shadow) {
        if (shadow == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.shadow, (Object)shadow)) {
            this.shadow = shadow;
            if (Intrinsics.areEqual((Object)this.shadow, (Object)Shadow.Companion.getNone())) {
                this.clearShadowLayer();
            } else {
                this.setShadowLayer(TextPaintExtensions_androidKt.correctBlurRadius(this.shadow.getBlurRadius()), Offset.getX-impl((long)this.shadow.getOffset-F1C5BW0()), Offset.getY-impl((long)this.shadow.getOffset-F1C5BW0()), ColorKt.toArgb-8_81llA((long)this.shadow.getColor-0d7_KjU()));
            }
        }
    }

    public final void setColor-8_81llA(long color) {
        long $this$isSpecified$iv = color;
        boolean bl = false;
        if ($this$isSpecified$iv != Color.Companion.getUnspecified-0d7_KjU()) {
            this.composePaint.setColor-8_81llA(color);
            this.composePaint.setShader(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setBrush-12SF9DM(@Nullable Brush brush, long size, float alpha) {
        block4: {
            block3: {
                long $this$isSpecified$iv;
                block2: {
                    if (!(brush instanceof SolidColor)) break block2;
                    $this$isSpecified$iv = ((SolidColor)brush).getValue-0d7_KjU();
                    boolean bl = false;
                    if ($this$isSpecified$iv != Color.Companion.getUnspecified-0d7_KjU()) break block3;
                }
                if (!(brush instanceof ShaderBrush)) break block4;
                $this$isSpecified$iv = size;
                boolean bl = false;
                if (!($this$isSpecified$iv != Size.Companion.getUnspecified-NH-jbRc())) break block4;
            }
            brush.applyTo-Pq9zytI(size, this.composePaint, Float.isNaN(alpha) ? this.composePaint.getAlpha() : RangesKt.coerceIn((float)alpha, (float)0.0f, (float)1.0f));
            return;
        }
        if (brush != null) return;
        this.composePaint.setShader(null);
    }

    public static /* synthetic */ void setBrush-12SF9DM$default(AndroidTextPaint androidTextPaint, Brush brush, long l, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = Float.NaN;
        }
        androidTextPaint.setBrush-12SF9DM(brush, l, f);
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        if (drawStyle == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.drawStyle, (Object)drawStyle)) {
            this.drawStyle = drawStyle;
            DrawStyle drawStyle2 = drawStyle;
            if (Intrinsics.areEqual((Object)drawStyle2, (Object)Fill.INSTANCE)) {
                this.composePaint.setStyle-k9PVt8s(PaintingStyle.Companion.getFill-TiuSbCo());
            } else if (drawStyle2 instanceof Stroke) {
                this.composePaint.setStyle-k9PVt8s(PaintingStyle.Companion.getStroke-TiuSbCo());
                this.composePaint.setStrokeWidth(((Stroke)drawStyle).getWidth());
                this.composePaint.setStrokeMiterLimit(((Stroke)drawStyle).getMiter());
                this.composePaint.setStrokeJoin-Ww9F2mQ(((Stroke)drawStyle).getJoin-LxFBmk8());
                this.composePaint.setStrokeCap-BeK7IIE(((Stroke)drawStyle).getCap-KaPHkGw());
                this.composePaint.setPathEffect(((Stroke)drawStyle).getPathEffect());
            }
        }
    }

    public final int getBlendMode-0nO6VwU() {
        return this.composePaint.getBlendMode-0nO6VwU();
    }

    public final void setBlendMode-s9anfk8(int n) {
        this.composePaint.setBlendMode-s9anfk8(n);
    }

    private static Object getBlendMode-0nO6VwU$delegate(AndroidTextPaint androidTextPaint) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)androidTextPaint.composePaint, androidx.compose.ui.graphics.Paint.class, "blendMode", "getBlendMode-0nO6VwU()I", 0)));
    }
}

