/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditingBufferKt;
import androidx.compose.ui.text.input.PartialGapBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u001a\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\r\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020%H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b,J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\rH\u0080\u0002\u00a2\u0006\u0002\b0J\r\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J%\u00104\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b5J%\u00104\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020\u0003H\u0016R\u001f\u0010\t\u001a\u0004\u0018\u00010\u00058@X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u001d\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0016R$\u0010!\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0016\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006>"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer;", "", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "composition", "getComposition-MzsxiRA$ui_text_release", "()Landroidx/compose/ui/text/TextRange;", "<set-?>", "", "compositionEnd", "getCompositionEnd$ui_text_release", "()I", "compositionStart", "getCompositionStart$ui_text_release", "cursor", "getCursor$ui_text_release", "setCursor$ui_text_release", "(I)V", "gapBuffer", "Landroidx/compose/ui/text/input/PartialGapBuffer;", "length", "getLength$ui_text_release", "getSelection-d9O1mEE$ui_text_release", "()J", "value", "selectionEnd", "getSelectionEnd$ui_text_release", "setSelectionEnd", "selectionStart", "getSelectionStart$ui_text_release", "setSelectionStart", "cancelComposition", "", "cancelComposition$ui_text_release", "commitComposition", "commitComposition$ui_text_release", "delete", "start", "end", "delete$ui_text_release", "get", "", "index", "get$ui_text_release", "hasComposition", "", "hasComposition$ui_text_release", "replace", "replace$ui_text_release", "setComposition", "setComposition$ui_text_release", "setSelection", "setSelection$ui_text_release", "toAnnotatedString", "toAnnotatedString$ui_text_release", "toString", "Companion", "ui-text_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,402:1\n1#2:403\n*E\n"})
public final class EditingBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int $stable = 8;
    public static final int NOWHERE = -1;

    private EditingBuffer(AnnotatedString text, long selection) {
        this.gapBuffer = new PartialGapBuffer(text.getText());
        this.selectionStart = TextRange.getMin-impl(selection);
        this.selectionEnd = TextRange.getMax-impl(selection);
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start2 = TextRange.getMin-impl(selection);
        int end = TextRange.getMax-impl(selection);
        if (start2 < 0 || start2 > text.length()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + text.length());
        }
        if (end < 0 || end > text.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + text.length());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text_release() {
        return this.selectionStart;
    }

    private final void setSelectionStart(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Cannot set selectionStart to a negative value: " + value;
            throw new IllegalArgumentException(string.toString());
        }
        this.selectionStart = value;
    }

    public final int getSelectionEnd$ui_text_release() {
        return this.selectionEnd;
    }

    private final void setSelectionEnd(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Cannot set selectionEnd to a negative value: " + value;
            throw new IllegalArgumentException(string.toString());
        }
        this.selectionEnd = value;
    }

    public final int getCompositionStart$ui_text_release() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text_release() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text_release() {
        return this.compositionStart != -1;
    }

    @Nullable
    public final TextRange getComposition-MzsxiRA$ui_text_release() {
        return this.hasComposition$ui_text_release() ? TextRange.box-impl(TextRangeKt.TextRange(this.compositionStart, this.compositionEnd)) : null;
    }

    public final long getSelection-d9O1mEE$ui_text_release() {
        return TextRangeKt.TextRange(this.selectionStart, this.selectionEnd);
    }

    public final int getCursor$ui_text_release() {
        return this.selectionStart == this.selectionEnd ? this.selectionEnd : -1;
    }

    public final void setCursor$ui_text_release(int cursor) {
        this.setSelection$ui_text_release(cursor, cursor);
    }

    public final char get$ui_text_release(int index) {
        return this.gapBuffer.get(index);
    }

    public final int getLength$ui_text_release() {
        return this.gapBuffer.getLength();
    }

    private EditingBuffer(String text, long selection) {
        this(new AnnotatedString(text, null, null, 6, null), selection, null);
    }

    public final void replace$ui_text_release(int start2, int end, @NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.replace$ui_text_release(start2, end, text.getText());
    }

    public final void replace$ui_text_release(int start2, int end, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.gapBuffer.replace(start2, end, text);
        this.setSelectionStart(start2 + text.length());
        this.setSelectionEnd(start2 + text.length());
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text_release(int start2, int end) {
        long deleteRange = TextRangeKt.TextRange(start2, end);
        this.gapBuffer.replace(start2, end, "");
        long newSelection = EditingBufferKt.updateRangeAfterDelete-pWDy79M(TextRangeKt.TextRange(this.selectionStart, this.selectionEnd), deleteRange);
        this.setSelectionStart(TextRange.getMin-impl(newSelection));
        this.setSelectionEnd(TextRange.getMax-impl(newSelection));
        if (this.hasComposition$ui_text_release()) {
            long compositionRange = TextRangeKt.TextRange(this.compositionStart, this.compositionEnd);
            long newComposition = EditingBufferKt.updateRangeAfterDelete-pWDy79M(compositionRange, deleteRange);
            if (TextRange.getCollapsed-impl(newComposition)) {
                this.commitComposition$ui_text_release();
            } else {
                this.compositionStart = TextRange.getMin-impl(newComposition);
                this.compositionEnd = TextRange.getMax-impl(newComposition);
            }
        }
    }

    public final void setSelection$ui_text_release(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.setSelectionStart(start2);
        this.setSelectionEnd(end);
    }

    public final void setComposition$ui_text_release(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start2 + " > " + end);
        }
        this.compositionStart = start2;
        this.compositionEnd = end;
    }

    public final void cancelComposition$ui_text_release() {
        this.replace$ui_text_release(this.compositionStart, this.compositionEnd, "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition$ui_text_release() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @NotNull
    public final AnnotatedString toAnnotatedString$ui_text_release() {
        return new AnnotatedString(this.toString(), null, null, 6, null);
    }

    public /* synthetic */ EditingBuffer(AnnotatedString text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    public /* synthetic */ EditingBuffer(String text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer$Companion;", "", "()V", "NOWHERE", "", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

