/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.style;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.style.PlaceholderSpanKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 (2\u00020\u0001:\u0001(B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJR\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0016J4\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\fH\u0017R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/compose/ui/text/android/style/PlaceholderSpan;", "Landroid/text/style/ReplacementSpan;", "width", "", "widthUnit", "", "height", "heightUnit", "pxPerSp", "verticalAlign", "(FIFIFI)V", "<set-?>", "Landroid/graphics/Paint$FontMetricsInt;", "fontMetrics", "getFontMetrics", "()Landroid/graphics/Paint$FontMetricsInt;", "heightPx", "getHeightPx", "()I", "isLaidOut", "", "getVerticalAlign", "widthPx", "getWidthPx", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fm", "Companion", "ui-text_release"})
@InternalPlatformTextApi
@SourceDebugExtension(value={"SMAP\nPlaceholderSpan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderSpan.kt\nandroidx/compose/ui/text/android/style/PlaceholderSpan\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class PlaceholderSpan
extends ReplacementSpan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float width;
    private final int widthUnit;
    private final float height;
    private final int heightUnit;
    private final float pxPerSp;
    private final int verticalAlign;
    private Paint.FontMetricsInt fontMetrics;
    private int widthPx;
    private int heightPx;
    private boolean isLaidOut;
    public static final int ALIGN_ABOVE_BASELINE = 0;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    public static final int ALIGN_CENTER = 3;
    public static final int ALIGN_TEXT_TOP = 4;
    public static final int ALIGN_TEXT_BOTTOM = 5;
    public static final int ALIGN_TEXT_CENTER = 6;
    public static final int UNIT_SP = 0;
    public static final int UNIT_EM = 1;
    public static final int UNIT_UNSPECIFIED = 2;

    public PlaceholderSpan(float width, int widthUnit, float height, int heightUnit, float pxPerSp, int verticalAlign) {
        this.width = width;
        this.widthUnit = widthUnit;
        this.height = height;
        this.heightUnit = heightUnit;
        this.pxPerSp = pxPerSp;
        this.verticalAlign = verticalAlign;
    }

    public final int getVerticalAlign() {
        return this.verticalAlign;
    }

    @NotNull
    public final Paint.FontMetricsInt getFontMetrics() {
        Paint.FontMetricsInt fontMetricsInt = this.fontMetrics;
        if (fontMetricsInt != null) {
            return fontMetricsInt;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
        return null;
    }

    public final int getWidthPx() {
        if (!this.isLaidOut) {
            boolean bl = false;
            String string = "PlaceholderSpan is not laid out yet.";
            throw new IllegalStateException(string.toString());
        }
        return this.widthPx;
    }

    public final int getHeightPx() {
        if (!this.isLaidOut) {
            boolean bl = false;
            String string = "PlaceholderSpan is not laid out yet.";
            throw new IllegalStateException(string.toString());
        }
        return this.heightPx;
    }

    @SuppressLint(value={"DocumentExceptions"})
    public int getSize(@NotNull Paint paint, @Nullable CharSequence text, int start2, int end, @Nullable Paint.FontMetricsInt fm) {
        block15: {
            Paint.FontMetricsInt fontMetricsInt;
            int n;
            float f;
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            this.isLaidOut = true;
            float fontSize = paint.getTextSize();
            Paint.FontMetricsInt fontMetricsInt2 = paint.getFontMetricsInt();
            Intrinsics.checkNotNullExpressionValue((Object)fontMetricsInt2, (String)"paint.fontMetricsInt");
            this.fontMetrics = fontMetricsInt2;
            if (!(this.getFontMetrics().descent > this.getFontMetrics().ascent)) {
                boolean $i$a$-require-PlaceholderSpan$getSize$22 = false;
                String $i$a$-require-PlaceholderSpan$getSize$22 = "Invalid fontMetrics: line height can not be negative.";
                throw new IllegalArgumentException($i$a$-require-PlaceholderSpan$getSize$22.toString());
            }
            switch (this.widthUnit) {
                case 0: {
                    f = this.width * this.pxPerSp;
                    break;
                }
                case 1: {
                    f = this.width * fontSize;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported unit.");
                }
            }
            this.widthPx = PlaceholderSpanKt.ceilToInt(f);
            switch (this.heightUnit) {
                case 0: {
                    n = PlaceholderSpanKt.ceilToInt(this.height * this.pxPerSp);
                    break;
                }
                case 1: {
                    n = PlaceholderSpanKt.ceilToInt(this.height * fontSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported unit.");
                }
            }
            this.heightPx = n;
            Paint.FontMetricsInt fontMetricsInt3 = fm;
            if (fontMetricsInt3 == null) break block15;
            Paint.FontMetricsInt $this$getSize_u24lambda_u243 = fontMetricsInt = fontMetricsInt3;
            boolean bl = false;
            $this$getSize_u24lambda_u243.ascent = this.getFontMetrics().ascent;
            $this$getSize_u24lambda_u243.descent = this.getFontMetrics().descent;
            $this$getSize_u24lambda_u243.leading = this.getFontMetrics().leading;
            switch (this.verticalAlign) {
                case 1: 
                case 4: {
                    if ($this$getSize_u24lambda_u243.ascent + this.getHeightPx() <= $this$getSize_u24lambda_u243.descent) break;
                    $this$getSize_u24lambda_u243.descent = $this$getSize_u24lambda_u243.ascent + this.getHeightPx();
                    break;
                }
                case 2: 
                case 5: {
                    if ($this$getSize_u24lambda_u243.ascent <= $this$getSize_u24lambda_u243.descent - this.getHeightPx()) break;
                    $this$getSize_u24lambda_u243.ascent = $this$getSize_u24lambda_u243.descent - this.getHeightPx();
                    break;
                }
                case 3: 
                case 6: {
                    if ($this$getSize_u24lambda_u243.descent - $this$getSize_u24lambda_u243.ascent >= this.getHeightPx()) break;
                    $this$getSize_u24lambda_u243.ascent -= (this.getHeightPx() - ($this$getSize_u24lambda_u243.descent - $this$getSize_u24lambda_u243.ascent)) / 2;
                    $this$getSize_u24lambda_u243.descent = $this$getSize_u24lambda_u243.ascent + this.getHeightPx();
                    break;
                }
                case 0: {
                    if ($this$getSize_u24lambda_u243.ascent <= -this.getHeightPx()) break;
                    $this$getSize_u24lambda_u243.ascent = -this.getHeightPx();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown verticalAlign.");
                }
            }
            $this$getSize_u24lambda_u243.top = Math.min(this.getFontMetrics().top, $this$getSize_u24lambda_u243.ascent);
            $this$getSize_u24lambda_u243.bottom = Math.max(this.getFontMetrics().bottom, $this$getSize_u24lambda_u243.descent);
        }
        return this.getWidthPx();
    }

    public void draw(@NotNull Canvas canvas, @Nullable CharSequence text, int start2, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/text/android/style/PlaceholderSpan$Companion;", "", "()V", "ALIGN_ABOVE_BASELINE", "", "ALIGN_BOTTOM", "ALIGN_CENTER", "ALIGN_TEXT_BOTTOM", "ALIGN_TEXT_CENTER", "ALIGN_TEXT_TOP", "ALIGN_TOP", "UNIT_EM", "UNIT_SP", "UNIT_UNSPECIFIED", "Unit", "VerticalAlign", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/compose/ui/text/android/style/PlaceholderSpan$Companion$Unit;", "", "ui-text_release"})
        public static @interface Unit {
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/compose/ui/text/android/style/PlaceholderSpan$Companion$VerticalAlign;", "", "ui-text_release"})
        public static @interface VerticalAlign {
        }
    }
}

