/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.data;

import androidx.compose.ui.tooling.data.Parameter;
import androidx.compose.ui.tooling.data.SourceLocation;
import androidx.compose.ui.tooling.data.SourceLocationInfo;
import androidx.compose.ui.tooling.data.UiToolingDataApi;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiToolingDataApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006 "}, d2={"Landroidx/compose/ui/tooling/data/SourceInformationContext;", "", "name", "", "sourceFile", "packageHash", "", "locations", "", "Landroidx/compose/ui/tooling/data/SourceLocationInfo;", "repeatOffset", "parameters", "Landroidx/compose/ui/tooling/data/Parameter;", "isCall", "", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/List;ILjava/util/List;Z)V", "()Z", "getLocations", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "nextLocation", "getPackageHash", "()I", "getParameters", "getRepeatOffset", "getSourceFile", "nextSourceLocation", "Landroidx/compose/ui/tooling/data/SourceLocation;", "sourceLocation", "callIndex", "parentContext", "ui-tooling-data_release"})
final class SourceInformationContext {
    @Nullable
    private final String name;
    @Nullable
    private final String sourceFile;
    private final int packageHash;
    @NotNull
    private final List<SourceLocationInfo> locations;
    private final int repeatOffset;
    @Nullable
    private final List<Parameter> parameters;
    private final boolean isCall;
    private int nextLocation;

    public SourceInformationContext(@Nullable String name, @Nullable String sourceFile, int packageHash, @NotNull List<SourceLocationInfo> locations, int repeatOffset, @Nullable List<Parameter> parameters, boolean isCall) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        this.name = name;
        this.sourceFile = sourceFile;
        this.packageHash = packageHash;
        this.locations = locations;
        this.repeatOffset = repeatOffset;
        this.parameters = parameters;
        this.isCall = isCall;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final int getPackageHash() {
        return this.packageHash;
    }

    @NotNull
    public final List<SourceLocationInfo> getLocations() {
        return this.locations;
    }

    public final int getRepeatOffset() {
        return this.repeatOffset;
    }

    @Nullable
    public final List<Parameter> getParameters() {
        return this.parameters;
    }

    public final boolean isCall() {
        return this.isCall;
    }

    @Nullable
    public final SourceLocation nextSourceLocation() {
        if (this.nextLocation >= this.locations.size() && this.repeatOffset >= 0) {
            this.nextLocation = this.repeatOffset;
        }
        if (this.nextLocation < this.locations.size()) {
            int n = this.nextLocation;
            this.nextLocation = n + 1;
            SourceLocationInfo location = this.locations.get(n);
            Integer n2 = location.getLineNumber();
            Integer n3 = location.getOffset();
            Integer n4 = location.getLength();
            return new SourceLocation(n2 != null ? n2 : -1, n3 != null ? n3 : -1, n4 != null ? n4 : -1, this.sourceFile, this.packageHash);
        }
        return null;
    }

    @Nullable
    public final SourceLocation sourceLocation(int callIndex, @Nullable SourceInformationContext parentContext) {
        int locationIndex = callIndex;
        if (locationIndex >= this.locations.size() && this.repeatOffset >= 0 && this.repeatOffset < this.locations.size()) {
            locationIndex = (callIndex - this.repeatOffset) % (this.locations.size() - this.repeatOffset) + this.repeatOffset;
        }
        if (locationIndex < this.locations.size()) {
            Integer n;
            SourceLocationInfo location = this.locations.get(locationIndex);
            Integer n2 = location.getLineNumber();
            int n3 = n2 != null ? n2 : -1;
            Integer n4 = location.getOffset();
            int n5 = n4 != null ? n4 : -1;
            Integer n6 = location.getLength();
            int n7 = n6 != null ? n6 : -1;
            String string = this.sourceFile;
            if (string == null) {
                SourceInformationContext sourceInformationContext = parentContext;
                string = sourceInformationContext != null ? sourceInformationContext.sourceFile : null;
            }
            if (this.sourceFile == null) {
                SourceInformationContext sourceInformationContext = parentContext;
                n = sourceInformationContext != null ? Integer.valueOf(sourceInformationContext.packageHash) : null;
            } else {
                n = this.packageHash;
            }
            return new SourceLocation(n3, n5, n7, string, n != null ? n : -1);
        }
        return null;
    }
}

