/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.data;

import androidx.compose.runtime.tooling.CompositionGroup;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.tooling.data.ParameterInformation;
import androidx.compose.ui.tooling.data.SlotTreeKt;
import androidx.compose.ui.tooling.data.SourceContext;
import androidx.compose.ui.tooling.data.SourceInformationContext;
import androidx.compose.ui.tooling.data.SourceLocation;
import androidx.compose.ui.tooling.data.UiToolingDataApi;
import androidx.compose.ui.unit.IntRect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BC\u0012&\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\tH\u0002J$\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00152\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000J\u0010\u00101\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u00020\u0015H\u0002J\b\u00104\u001a\u00020\u0005H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020\u0005H\u0002R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/compose/ui/tooling/data/CompositionCallStack;", "T", "Landroidx/compose/ui/tooling/data/SourceContext;", "factory", "Lkotlin/Function3;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "contexts", "", "", "", "(Lkotlin/jvm/functions/Function3;Ljava/util/Map;)V", "<set-?>", "Landroidx/compose/ui/unit/IntRect;", "bounds", "getBounds", "()Landroidx/compose/ui/unit/IntRect;", "current", "getCurrent", "()Landroidx/compose/runtime/tooling/CompositionGroup;", "currentCallIndex", "", "depth", "getDepth", "()I", "isInline", "", "()Z", "location", "Landroidx/compose/ui/tooling/data/SourceLocation;", "getLocation", "()Landroidx/compose/ui/tooling/data/SourceLocation;", "name", "getName", "()Ljava/lang/String;", "parameters", "Landroidx/compose/ui/tooling/data/ParameterInformation;", "getParameters", "()Ljava/util/List;", "stack", "Lkotlin/collections/ArrayDeque;", "contextOf", "Landroidx/compose/ui/tooling/data/SourceInformationContext;", "information", "convert", "group", "callIndex", "out", "", "isCall", "parentGroup", "parentDepth", "pop", "push", "", "ui-tooling-data_release"})
@UiToolingDataApi
final class CompositionCallStack<T>
implements SourceContext {
    @NotNull
    private final Function3<CompositionGroup, SourceContext, List<? extends T>, T> factory;
    @NotNull
    private final Map<String, Object> contexts;
    @NotNull
    private final ArrayDeque<CompositionGroup> stack;
    private int currentCallIndex;
    @NotNull
    private IntRect bounds;

    public CompositionCallStack(@NotNull Function3<? super CompositionGroup, ? super SourceContext, ? super List<? extends T>, ? extends T> factory, @NotNull Map<String, Object> contexts) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        this.factory = factory;
        this.contexts = contexts;
        this.stack = new ArrayDeque();
        this.bounds = SlotTreeKt.getEmptyBox();
    }

    @NotNull
    public final IntRect convert(@NotNull CompositionGroup group, int callIndex, @NotNull List<T> out) {
        LayoutInfo layoutInfo;
        IntRect box;
        List children;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter(out, (String)"out");
                children = new ArrayList();
                box = null;
                box = SlotTreeKt.getEmptyBox();
                this.push(group);
                int childCallIndex = 0;
                Iterable $this$forEach$iv = group.getCompositionGroups();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CompositionGroup child = (CompositionGroup)element$iv;
                    boolean bl = false;
                    box = SlotTreeKt.union(box, this.convert(child, childCallIndex, children));
                    if (!this.isCall(child)) continue;
                    ++childCallIndex;
                }
                Object object = group.getNode();
                layoutInfo = object instanceof LayoutInfo ? (LayoutInfo)object : null;
                if (layoutInfo == null) break block5;
                LayoutInfo it = layoutInfo;
                boolean bl = false;
                IntRect intRect = SlotTreeKt.access$boundsOfLayoutNode(it);
                layoutInfo = intRect;
                if (intRect != null) break block6;
            }
            layoutInfo = box;
        }
        box = layoutInfo;
        this.currentCallIndex = callIndex;
        this.bounds = box;
        Object object = this.factory.invoke((Object)group, (Object)this, (Object)children);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            out.add(it);
        }
        this.pop();
        return box;
    }

    @Override
    @Nullable
    public String getName() {
        String string;
        int n;
        String string2 = this.getCurrent().getSourceInfo();
        if (string2 == null) {
            return null;
        }
        String info = string2;
        if (StringsKt.startsWith$default((String)info, (String)"CC(", (boolean)false, (int)2, null)) {
            n = 3;
        } else if (StringsKt.startsWith$default((String)info, (String)"C(", (boolean)false, (int)2, null)) {
            n = 2;
        } else {
            return null;
        }
        int startIndex = n;
        int endIndex = StringsKt.indexOf$default((CharSequence)info, (char)')', (int)0, (boolean)false, (int)6, null);
        if (endIndex > 2) {
            String string3 = info.substring(startIndex, endIndex);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public boolean isInline() {
        String string = this.getCurrent().getSourceInfo();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"CC", (boolean)false, (int)2, null) : false;
    }

    @Override
    @NotNull
    public IntRect getBounds() {
        return this.bounds;
    }

    @Override
    @Nullable
    public SourceLocation getLocation() {
        Object context;
        Object object;
        block7: {
            block6: {
                object = this.parentGroup(1);
                if (object == null || (object = object.getSourceInfo()) == null) break block6;
                Object it = object;
                boolean bl = false;
                SourceInformationContext sourceInformationContext = this.contextOf((String)it);
                object = sourceInformationContext;
                if (sourceInformationContext != null) break block7;
            }
            return null;
        }
        Object parentContext = context = object;
        int index = 2;
        while (index < this.stack.size()) {
            SourceInformationContext sourceInformationContext;
            Object object2;
            Object object3 = parentContext;
            if ((object3 != null ? ((SourceInformationContext)object3).getSourceFile() : null) != null) break;
            if ((object2 = this.parentGroup(index++)) != null && (object2 = object2.getSourceInfo()) != null) {
                Object it = object2;
                boolean bl = false;
                sourceInformationContext = this.contextOf((String)it);
            } else {
                sourceInformationContext = null;
            }
            parentContext = sourceInformationContext;
        }
        return ((SourceInformationContext)context).sourceLocation(this.currentCallIndex, (SourceInformationContext)parentContext);
    }

    @Override
    @NotNull
    public List<ParameterInformation> getParameters() {
        Object object;
        CompositionGroup group;
        block3: {
            block2: {
                group = this.getCurrent();
                object = group.getSourceInfo();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                SourceInformationContext sourceInformationContext = this.contextOf(it);
                object = sourceInformationContext;
                if (sourceInformationContext != null) break block3;
            }
            return CollectionsKt.emptyList();
        }
        Object context = object;
        List data = new ArrayList();
        CollectionsKt.addAll((Collection)data, (Iterable)group.getData());
        return SlotTreeKt.access$extractParameterInfo(data, (SourceInformationContext)context);
    }

    @Override
    public int getDepth() {
        return this.stack.size();
    }

    private final void push(CompositionGroup group) {
        this.stack.addLast((Object)group);
    }

    private final CompositionGroup pop() {
        return (CompositionGroup)this.stack.removeLast();
    }

    private final CompositionGroup getCurrent() {
        return (CompositionGroup)this.stack.last();
    }

    private final CompositionGroup parentGroup(int parentDepth) {
        return this.stack.size() > parentDepth ? (CompositionGroup)this.stack.get(this.stack.size() - parentDepth - 1) : null;
    }

    private final SourceInformationContext contextOf(String information) {
        Object object;
        Object object2;
        Map<String, Object> $this$getOrPut$iv = this.contexts;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(information);
        if (value$iv == null) {
            boolean bl = false;
            SourceInformationContext answer$iv = SlotTreeKt.sourceInformationContextOf$default(information, null, 2, null);
            $this$getOrPut$iv.put(information, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        return (object = object2) instanceof SourceInformationContext ? (SourceInformationContext)object : null;
    }

    private final boolean isCall(CompositionGroup group) {
        String string = group.getSourceInfo();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"C", (boolean)false, (int)2, null) : false;
    }
}

