/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.preview;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.tooling.SourceLocation;
import androidx.compose.ui.unit.IntBounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010!\u001a\u00020\u001fJ\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\b\u0010#\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Landroidx/compose/ui/tooling/preview/ViewInfo;", "", "fileName", "", "lineNumber", "", "bounds", "Landroidx/compose/ui/unit/IntBounds;", "location", "Landroidx/compose/ui/tooling/SourceLocation;", "children", "", "(Ljava/lang/String;ILandroidx/compose/ui/unit/IntBounds;Landroidx/compose/ui/tooling/SourceLocation;Ljava/util/List;)V", "getBounds", "()Landroidx/compose/ui/unit/IntBounds;", "getChildren", "()Ljava/util/List;", "getFileName", "()Ljava/lang/String;", "getLineNumber", "()I", "getLocation", "()Landroidx/compose/ui/tooling/SourceLocation;", "allChildren", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hasBounds", "hashCode", "toString", "ui-tooling_release"})
@StabilityInferred(parameters=0)
public final class ViewInfo {
    @NotNull
    private final String fileName;
    private final int lineNumber;
    @NotNull
    private final IntBounds bounds;
    @Nullable
    private final SourceLocation location;
    @NotNull
    private final List<ViewInfo> children;
    public static final int $stable = 8;

    public ViewInfo(@NotNull String fileName, int lineNumber, @NotNull IntBounds bounds, @Nullable SourceLocation location, @NotNull List<ViewInfo> children) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.bounds = bounds;
        this.location = location;
        this.children = children;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    @NotNull
    public final IntBounds getBounds() {
        return this.bounds;
    }

    @Nullable
    public final SourceLocation getLocation() {
        return this.location;
    }

    @NotNull
    public final List<ViewInfo> getChildren() {
        return this.children;
    }

    public final boolean hasBounds() {
        return this.bounds.getBottom() != 0 && this.bounds.getRight() != 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ViewInfo> allChildren() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.children;
        Collection collection = this.children;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ViewInfo it = (ViewInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.allChildren();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append('(').append(this.fileName).append(':').append(this.lineNumber).append(",\n            |bounds=(top=").append(this.bounds.getTop()).append(", left=").append(this.bounds.getLeft()).append(",\n            |location=");
        SourceLocation sourceLocation = this.location;
        if (sourceLocation == null) {
            string = "<none>";
        } else {
            void it;
            SourceLocation sourceLocation2 = sourceLocation;
            boolean bl = false;
            boolean bl2 = false;
            SourceLocation sourceLocation3 = sourceLocation2;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl3 = false;
            String string2 = "" + '(' + it.getOffset() + 'L' + it.getLength();
            stringBuilder = stringBuilder2;
            String string3 = string2;
            string = string3 == null ? "<none>" : string3;
        }
        return StringsKt.trimMargin$default((String)stringBuilder.append(string).append("\n            |bottom=").append(this.bounds.getBottom()).append(", right=").append(this.bounds.getRight()).append("),\n            |childrenCount=").append(this.children.size()).append(')').toString(), null, (int)1, null);
    }

    @NotNull
    public final String component1() {
        return this.fileName;
    }

    public final int component2() {
        return this.lineNumber;
    }

    @NotNull
    public final IntBounds component3() {
        return this.bounds;
    }

    @Nullable
    public final SourceLocation component4() {
        return this.location;
    }

    @NotNull
    public final List<ViewInfo> component5() {
        return this.children;
    }

    @NotNull
    public final ViewInfo copy(@NotNull String fileName, int lineNumber, @NotNull IntBounds bounds, @Nullable SourceLocation location, @NotNull List<ViewInfo> children) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new ViewInfo(fileName, lineNumber, bounds, location, children);
    }

    public static /* synthetic */ ViewInfo copy$default(ViewInfo viewInfo, String string, int n, IntBounds intBounds, SourceLocation sourceLocation, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = viewInfo.fileName;
        }
        if ((n2 & 2) != 0) {
            n = viewInfo.lineNumber;
        }
        if ((n2 & 4) != 0) {
            intBounds = viewInfo.bounds;
        }
        if ((n2 & 8) != 0) {
            sourceLocation = viewInfo.location;
        }
        if ((n2 & 0x10) != 0) {
            list = viewInfo.children;
        }
        return viewInfo.copy(string, n, intBounds, sourceLocation, list);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = result * 31 + Integer.hashCode(this.lineNumber);
        result = result * 31 + this.bounds.hashCode();
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + ((Object)this.children).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewInfo)) {
            return false;
        }
        ViewInfo viewInfo = (ViewInfo)other;
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)viewInfo.fileName)) {
            return false;
        }
        if (this.lineNumber != viewInfo.lineNumber) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bounds, (Object)viewInfo.bounds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.location, (Object)viewInfo.location)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, viewInfo.children);
    }
}

