/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.preview.animation;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.compose.animation.core.AnimationClockObservable;
import androidx.compose.animation.core.AnimationClockObserver;
import androidx.compose.animation.core.ManualAnimationClock;
import androidx.compose.animation.core.PropKey;
import androidx.compose.animation.core.SeekableAnimation;
import androidx.compose.animation.core.ToolingGlueKt;
import androidx.compose.animation.core.TransitionAnimation;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.ComposeAnimation;
import androidx.compose.animation.tooling.ComposeAnimationType;
import androidx.compose.ui.tooling.preview.animation.ComposeAnimationParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010#\u001a\u00020\u0006J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0015J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0015H\u0015J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0015H\u0015J\u000e\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0003J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0014H\u0016J\u0010\u00100\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0014H\u0016J\u0006\u00101\u001a\u00020\u0006J\u001e\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u00168\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u001bj\b\u0012\u0004\u0012\u00020\u0014`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u001f\u001a&\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u0013j\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030 `\u00168\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u000f\u001a\u0004\b\"\u0010\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Landroidx/compose/ui/tooling/preview/animation/PreviewAnimationClock;", "Landroidx/compose/animation/core/AnimationClockObservable;", "initialTimeMs", "", "setClockTimeCallback", "Lkotlin/Function0;", "", "(JLkotlin/jvm/functions/Function0;)V", "DEBUG", "", "TAG", "", "clock", "Landroidx/compose/animation/core/ManualAnimationClock;", "getClock$ui_tooling_release$annotations$ui_tooling_release", "()V", "getClock$ui_tooling_release", "()Landroidx/compose/animation/core/ManualAnimationClock;", "observersToAnimations", "Ljava/util/HashMap;", "Landroidx/compose/animation/core/AnimationClockObserver;", "Landroidx/compose/animation/tooling/ComposeAnimation;", "Lkotlin/collections/HashMap;", "getObserversToAnimations$ui_tooling_release$annotations$ui_tooling_release", "getObserversToAnimations$ui_tooling_release", "()Ljava/util/HashMap;", "pendingObservers", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "pendingObserversLock", "", "seekableAnimations", "Landroidx/compose/animation/core/SeekableAnimation;", "getSeekableAnimations$ui_tooling_release$annotations$ui_tooling_release", "getSeekableAnimations$ui_tooling_release", "dispose", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "animation", "getMaxDuration", "getMaxDurationPerIteration", "notifySubscribe", "notifyUnsubscribe", "setClockTime", "animationTimeMs", "subscribe", "observer", "unsubscribe", "updateAnimationStates", "updateSeekableAnimation", "composeAnimation", "fromState", "toState", "ui-tooling_release"})
public class PreviewAnimationClock
implements AnimationClockObservable {
    private final long initialTimeMs;
    @NotNull
    private final Function0<Unit> setClockTimeCallback;
    @NotNull
    private final String TAG;
    private final boolean DEBUG;
    @NotNull
    private final HashMap<AnimationClockObserver, ComposeAnimation> observersToAnimations;
    @NotNull
    private final HashMap<ComposeAnimation, SeekableAnimation<?>> seekableAnimations;
    @NotNull
    private final HashSet<AnimationClockObserver> pendingObservers;
    @NotNull
    private final Object pendingObserversLock;
    @NotNull
    private final ManualAnimationClock clock;

    public PreviewAnimationClock(long initialTimeMs, @NotNull Function0<Unit> setClockTimeCallback) {
        Intrinsics.checkNotNullParameter(setClockTimeCallback, (String)"setClockTimeCallback");
        this.initialTimeMs = initialTimeMs;
        this.setClockTimeCallback = setClockTimeCallback;
        this.TAG = "PreviewAnimationClock";
        boolean bl = false;
        this.observersToAnimations = new HashMap();
        bl = false;
        this.seekableAnimations = new HashMap();
        bl = false;
        this.pendingObservers = new HashSet();
        this.pendingObserversLock = new Object();
        this.clock = new ManualAnimationClock(this.initialTimeMs, false, 2, null);
    }

    public /* synthetic */ PreviewAnimationClock(long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(l, (Function0<Unit>)function0);
    }

    @NotNull
    public final HashMap<AnimationClockObserver, ComposeAnimation> getObserversToAnimations$ui_tooling_release() {
        return this.observersToAnimations;
    }

    @VisibleForTesting
    public static /* synthetic */ void getObserversToAnimations$ui_tooling_release$annotations$ui_tooling_release() {
    }

    @NotNull
    public final HashMap<ComposeAnimation, SeekableAnimation<?>> getSeekableAnimations$ui_tooling_release() {
        return this.seekableAnimations;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSeekableAnimations$ui_tooling_release$annotations$ui_tooling_release() {
    }

    @NotNull
    public final ManualAnimationClock getClock$ui_tooling_release() {
        return this.clock;
    }

    @VisibleForTesting
    public static /* synthetic */ void getClock$ui_tooling_release$annotations$ui_tooling_release() {
    }

    public void subscribe(@NotNull AnimationClockObserver observer) {
        ComposeAnimation composeAnimation;
        ComposeAnimation composeAnimation2;
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        if (this.observersToAnimations.containsKey(observer)) {
            return;
        }
        if (this.DEBUG) {
            Log.d((String)this.TAG, (String)("AnimationClockObserver " + observer + " subscribed"));
        }
        this.clock.subscribe(observer);
        AnimationClockObserver animationClockObserver = observer;
        if (animationClockObserver instanceof TransitionAnimation.TransitionAnimationClockObserver) {
            ((TransitionAnimation.TransitionAnimationClockObserver)observer).getAnimation().setMonotonic(false);
            composeAnimation2 = ComposeAnimationParserKt.parse((TransitionAnimation.TransitionAnimationClockObserver)observer);
        } else {
            composeAnimation2 = composeAnimation = null;
        }
        if (composeAnimation != null) {
            animationClockObserver = composeAnimation;
            boolean bl = false;
            boolean bl2 = false;
            AnimationClockObserver it = animationClockObserver;
            boolean bl3 = false;
            Map map = this.getObserversToAnimations$ui_tooling_release();
            boolean bl4 = false;
            map.put(observer, it);
            this.notifySubscribe((ComposeAnimation)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(@NotNull AnimationClockObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Object object = this.pendingObserversLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.pendingObservers.remove(observer)) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (this.DEBUG) {
            Log.d((String)this.TAG, (String)("AnimationClockObserver " + observer + " unsubscribed"));
        }
        this.clock.unsubscribe(observer);
        object = this.observersToAnimations.remove(observer);
        if (object != null) {
            Object object2 = object;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it = object2;
            boolean bl6 = false;
            this.notifyUnsubscribe((ComposeAnimation)it);
            this.getSeekableAnimations$ui_tooling_release().remove(it);
        }
    }

    @VisibleForTesting
    protected void notifySubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    @VisibleForTesting
    protected void notifyUnsubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public final void updateSeekableAnimation(@NotNull ComposeAnimation composeAnimation, @NotNull Object fromState, @NotNull Object toState) {
        Intrinsics.checkNotNullParameter((Object)composeAnimation, (String)"composeAnimation");
        Intrinsics.checkNotNullParameter((Object)fromState, (String)"fromState");
        Intrinsics.checkNotNullParameter((Object)toState, (String)"toState");
        if (composeAnimation.getType() != ComposeAnimationType.TRANSITION_ANIMATION) {
            return;
        }
        TransitionAnimation animation = (TransitionAnimation)composeAnimation.getAnimationObject();
        Map map = this.seekableAnimations;
        SeekableAnimation seekableAnimation = ToolingGlueKt.createSeekableAnimation((TransitionAnimation)animation, (Object)fromState, (Object)toState);
        boolean bl = false;
        map.put(composeAnimation, seekableAnimation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAnimationStates() {
        Map $this$forEach$iv = this.observersToAnimations;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$observer$composeAnimation = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$observer$composeAnimation;
            boolean bl3 = false;
            AnimationClockObserver observer = (AnimationClockObserver)entry.getKey();
            Map.Entry entry2 = $dstr$observer$composeAnimation;
            boolean bl4 = false;
            ComposeAnimation composeAnimation = (ComposeAnimation)entry2.getValue();
            entry2 = this.getSeekableAnimations$ui_tooling_release().get(composeAnimation);
            if (entry2 == null) continue;
            Map.Entry entry3 = entry2;
            boolean bl5 = false;
            boolean bl6 = false;
            Map.Entry seekableAnimation = entry3;
            boolean bl7 = false;
            Object object = this.pendingObserversLock;
            boolean bl8 = false;
            boolean bl9 = false;
            synchronized (object) {
                boolean bl10 = false;
                bl9 = this.pendingObservers.add(observer);
            }
            TransitionAnimation animation = (TransitionAnimation)composeAnimation.getAnimationObject();
            Object object2 = seekableAnimation.getFromState();
            Intrinsics.checkNotNull((Object)object2);
            animation.snapToState(object2);
            object2 = seekableAnimation.getToState();
            Intrinsics.checkNotNull((Object)object2);
            animation.toState(object2);
        }
        Object object = this.pendingObserversLock;
        boolean bl11 = false;
        boolean bl12 = false;
        synchronized (object) {
            boolean bl13 = false;
            this.pendingObservers.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.clock.setClockTimeMillis(this.initialTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDuration() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.seekableAnimations;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Long l = ((SeekableAnimation)it.getValue()).getDuration();
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return l == null ? -1L : l;
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDurationPerIteration() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.seekableAnimations;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Long l = ((SeekableAnimation)it.getValue()).getMaxDurationPerIteration();
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return l == null ? -1L : l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ComposeAnimatedProperty> getAnimatedProperties(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (animation.getType() != ComposeAnimationType.TRANSITION_ANIMATION) {
            return CollectionsKt.emptyList();
        }
        SeekableAnimation<?> seekableAnimation = this.seekableAnimations.get(animation);
        if (seekableAnimation != null) {
            void $this$mapTo$iv$iv;
            SeekableAnimation<?> seekableAnimation2 = seekableAnimation;
            boolean bl = false;
            boolean bl2 = false;
            SeekableAnimation<?> seekableAnimation3 = seekableAnimation2;
            boolean bl3 = false;
            long time = this.getClock$ui_tooling_release().getClockTimeMillis() - this.initialTimeMs;
            Iterable $this$map$iv = seekableAnimation3.getAnimValuesAt(time).entrySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ComposeAnimatedProperty composeAnimatedProperty = new ComposeAnimatedProperty(((PropKey)it.getKey()).getLabel(), it.getValue());
                collection.add(composeAnimatedProperty);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    public final void setClockTime(long animationTimeMs) {
        this.clock.setClockTimeMillis(this.initialTimeMs + animationTimeMs);
        this.setClockTimeCallback.invoke();
    }

    public final void dispose() {
        this.observersToAnimations.clear();
        this.seekableAnimations.clear();
    }

    public PreviewAnimationClock() {
        this(0L, null, 3, null);
    }
}

