/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.inspector;

import android.util.Log;
import android.view.View;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.runtime.internal.ComposableLambda;
import androidx.compose.ui.AbsoluteAlignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.vector.ImageVector;
import androidx.compose.ui.platform.InspectableValue;
import androidx.compose.ui.platform.ValueElement;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.ResourceFont;
import androidx.compose.ui.text.intl.Locale;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.tooling.inspector.InlineClassConverter;
import androidx.compose.ui.tooling.inspector.InspectorNode;
import androidx.compose.ui.tooling.inspector.NodeParameter;
import androidx.compose.ui.tooling.inspector.ParameterFactory;
import androidx.compose.ui.tooling.inspector.ParameterFactory$ParameterCreator$createFromKotlinReflection$;
import androidx.compose.ui.tooling.inspector.ParameterFactory$ParameterCreator$findBestResourceFont$;
import androidx.compose.ui.tooling.inspector.ParameterType;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u001b\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0001J\u001a\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0012\u0010&\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0002J\u001e\u0010'\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0002\b\u00030\u001cH\u0002J\u0014\u0010(\u001a\u00020)2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0014\u0010*\u001a\u00020)2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0014\u0010+\u001a\u00020)2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0002J\u0014\u0010.\u001a\u00020)2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001a\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Landroidx/compose/ui/tooling/inspector/ParameterFactory;", "", "inlineClassConverter", "Landroidx/compose/ui/tooling/inspector/InlineClassConverter;", "(Landroidx/compose/ui/tooling/inspector/InlineClassConverter;)V", "creatorCache", "Landroidx/compose/ui/tooling/inspector/ParameterFactory$ParameterCreator;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "setDensity", "(Landroidx/compose/ui/unit/Density;)V", "ignoredClasses", "", "Ljava/lang/Class;", "ignoredPackagePrefixes", "", "kotlinReflectionSupported", "", "valueLookup", "", "valuesLoaded", "", "constantValueOf", "field", "Ljava/lang/reflect/Field;", "property", "Lkotlin/reflect/KProperty1;", "instance", "create", "Landroidx/compose/ui/tooling/inspector/NodeParameter;", "node", "Landroidx/compose/ui/tooling/inspector/InspectorNode;", "name", "value", "findPackageLevelClass", "javaClass", "ignoredValue", "inlineResultClass", "loadConstantsFrom", "", "loadConstantsFromEnclosedClasses", "loadConstantsFromObjectInstance", "kClass", "Lkotlin/reflect/KClass;", "loadConstantsFromStaticFinal", "safeEnclosingClass", "klass", "ParameterCreator", "ui-tooling_release"})
public final class ParameterFactory {
    @NotNull
    private final InlineClassConverter inlineClassConverter;
    @NotNull
    private final Map<Object, String> valueLookup;
    @NotNull
    private final Set<Class<?>> valuesLoaded;
    @NotNull
    private final List<Class<? extends Object>> ignoredClasses;
    @Nullable
    private ParameterCreator creatorCache;
    private final boolean kotlinReflectionSupported;
    @NotNull
    private final List<String> ignoredPackagePrefixes;
    @NotNull
    private Density density;

    public ParameterFactory(@NotNull InlineClassConverter inlineClassConverter) {
        boolean bl;
        ParameterFactory parameterFactory;
        Intrinsics.checkNotNullParameter((Object)inlineClassConverter, (String)"inlineClassConverter");
        this.inlineClassConverter = inlineClassConverter;
        boolean bl2 = false;
        this.valueLookup = new LinkedHashMap();
        bl2 = false;
        this.valuesLoaded = new LinkedHashSet();
        Object[] objectArray = new Class[]{Color.class, Dp.class};
        this.ignoredClasses = CollectionsKt.listOf((Object[])objectArray);
        ParameterFactory parameterFactory2 = this;
        try {
            parameterFactory = parameterFactory2;
            Class.forName("kotlin.reflect.full.KClasses");
            bl = true;
        }
        catch (Exception exception) {
            parameterFactory = parameterFactory2;
            bl = false;
        }
        parameterFactory.kotlinReflectionSupported = bl;
        this.ignoredPackagePrefixes = CollectionsKt.listOf((Object)"android.graphics.");
        this.density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        Object object = new TextDecoration[]{TextDecoration.Companion.getLineThrough(), TextDecoration.Companion.getUnderline()};
        TextDecoration textDecorationCombination = TextDecoration.Companion.combine(CollectionsKt.listOf((Object[])object));
        object = this.valueLookup;
        String string = "LineThrough+Underline";
        boolean bl3 = false;
        object.put(textDecorationCombination, string);
        object = this.valueLookup;
        string = Color.box-impl((long)Color.Companion.getUnspecified-0d7_KjU());
        String string2 = "Unspecified";
        boolean bl4 = false;
        object.put(string, string2);
        object = this.valueLookup;
        string = RectangleShapeKt.getRectangleShape();
        string2 = "RectangleShape";
        bl4 = false;
        object.put(string, string2);
        this.valuesLoaded.add(Enum.class);
        this.valuesLoaded.add(Object.class);
        this.loadConstantsFromEnclosedClasses(AbsoluteAlignment.class);
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public final void setDensity(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"<set-?>");
        this.density = density;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final NodeParameter create(@NotNull InspectorNode node, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.creatorCache;
        ParameterCreator creator = object == null ? new ParameterCreator() : object;
        try {
            object = creator.create(node, name, value);
            return object;
        }
        finally {
            this.creatorCache = creator;
        }
    }

    private final void loadConstantsFrom(Class<?> javaClass) {
        Sequence related2;
        if (this.valuesLoaded.contains(javaClass)) {
            return;
        }
        Sequence sequence = SequencesKt.generateSequence(javaClass, (Function1)loadConstantsFrom.related.1.INSTANCE);
        Class<?>[] classArray = javaClass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"javaClass.interfaces");
        Sequence $this$forEach$iv = related2 = SequencesKt.plus((Sequence)sequence, (Object[])classArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class aClass = (Class)element$iv;
            boolean bl = false;
            Class topClass2 = (Class)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)aClass, (Function1)new Function1<Class<?>, Class<?>>(this){
                final /* synthetic */ ParameterFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Class<?> invoke(@NotNull Class<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return ParameterFactory.access$safeEnclosingClass(this.this$0, it);
                }
            }));
            this.loadConstantsFromEnclosedClasses(topClass2);
            Class<?> clazz = this.findPackageLevelClass(topClass2);
            if (clazz == null) continue;
            Class<?> clazz2 = clazz;
            boolean bl2 = false;
            boolean bl3 = false;
            Class<?> it = clazz2;
            boolean bl4 = false;
            this.loadConstantsFromStaticFinal(it);
        }
    }

    private final Class<?> safeEnclosingClass(Class<?> klass) {
        Class clazz;
        try {
            clazz = klass.getEnclosingClass();
        }
        catch (Error _) {
            clazz = null;
        }
        return clazz;
    }

    private final Class<?> findPackageLevelClass(Class<?> javaClass) {
        Class<?> clazz;
        try {
            clazz = Class.forName(Intrinsics.stringPlus((String)javaClass.getName(), (Object)"Kt"));
        }
        catch (Throwable ex) {
            clazz = null;
        }
        return clazz;
    }

    private final void loadConstantsFromEnclosedClasses(Class<?> javaClass) {
        if (this.valuesLoaded.contains(javaClass)) {
            return;
        }
        this.loadConstantsFromObjectInstance(JvmClassMappingKt.getKotlinClass(javaClass));
        this.loadConstantsFromStaticFinal(javaClass);
        this.valuesLoaded.add(javaClass);
        Class<?>[] classArray = javaClass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"javaClass.declaredClasses");
        Object[] $this$forEach$iv = classArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.loadConstantsFromEnclosedClasses(it);
        }
    }

    private final void loadConstantsFromObjectInstance(KClass<?> kClass) {
        try {
            Object object = kClass.getObjectInstance();
            if (object == null) {
                return;
            }
            Object instance = object;
            MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)KClasses.getDeclaredMemberProperties(kClass)), (Function1)loadConstantsFromObjectInstance.1.INSTANCE), (Function1)new Function1<KProperty1<? extends Object, ?>, Pair<? extends Object, ? extends String>>(this, instance){
                final /* synthetic */ ParameterFactory this$0;
                final /* synthetic */ Object $instance;
                {
                    this.this$0 = $receiver;
                    this.$instance = $instance;
                    super(1);
                }

                @Nullable
                public final Pair<Object, String> invoke(@NotNull KProperty1<? extends Object, ?> it) {
                    Pair pair;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Object object = ParameterFactory.access$constantValueOf(this.this$0, it, this.$instance);
                    if (object == null) {
                        pair = null;
                    } else {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object key = object2;
                        boolean bl3 = false;
                        pair = new Pair(key, (Object)it.getName());
                    }
                    return pair;
                }
            }), (Function1)((Function1)new Function1<Pair<? extends Object, ? extends String>, Boolean>(this){
                final /* synthetic */ ParameterFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull Pair<? extends Object, String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return !ParameterFactory.access$ignoredValue(this.this$0, it.getFirst());
                }
            })), this.valueLookup);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void loadConstantsFromStaticFinal(Class<?> javaClass) {
        try {
            Method[] methodArray = javaClass.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"javaClass.declaredMethods");
            MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)loadConstantsFromStaticFinal.1.INSTANCE), (Function1)((Function1)new Function1<Method, Field>(javaClass){
                final /* synthetic */ Class<?> $javaClass;
                {
                    this.$javaClass = $javaClass;
                    super(1);
                }

                @Nullable
                public final Field invoke(Method it) {
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    int n = 3;
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    return this.$javaClass.getDeclaredField(string2);
                }
            })), (Function1)((Function1)new Function1<Field, Pair<? extends Object, ? extends String>>(this){
                final /* synthetic */ ParameterFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Pair<Object, String> invoke(@NotNull Field it) {
                    Pair pair;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = ParameterFactory.access$constantValueOf(this.this$0, it);
                    if (object == null) {
                        pair = null;
                    } else {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object key = object2;
                        boolean bl3 = false;
                        pair = new Pair(key, (Object)it.getName());
                    }
                    return pair;
                }
            })), (Function1)((Function1)new Function1<Pair<? extends Object, ? extends String>, Boolean>(this){
                final /* synthetic */ ParameterFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull Pair<? extends Object, String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return !ParameterFactory.access$ignoredValue(this.this$0, it.getFirst());
                }
            })), this.valueLookup);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private final Object constantValueOf(Field field) {
        Field field2;
        try {
            field2 = field;
            if (field2 != null) {
                field2.setAccessible(true);
            }
            field2 = field;
            field2 = field2 == null ? null : field2.get(null);
        }
        catch (ReflectiveOperationException _) {
            field2 = null;
        }
        return field2;
    }

    private final Object constantValueOf(KProperty1<? extends Object, ?> property, Object instance) {
        Object object;
        try {
            Field field;
            Field field2 = field = ReflectJvmMapping.getJavaField((KProperty)((KProperty)property));
            if (field2 != null) {
                field2.setAccessible(true);
            }
            field2 = field;
            object = this.inlineClassConverter.castParameterValue(this.inlineResultClass(property), field2 == null ? null : field2.get(instance));
        }
        catch (ReflectiveOperationException _) {
            object = null;
        }
        return object;
    }

    private final String inlineResultClass(KProperty1<? extends Object, ?> property) {
        String string;
        Method method = ReflectJvmMapping.getJavaGetter((KProperty)((KProperty)property));
        if (Intrinsics.areEqual(method == null ? null : ((string = method.getName()) == null ? null : Boolean.valueOf(StringsKt.contains$default((CharSequence)string, (char)'-', (boolean)false, (int)2, null))), (Object)true)) {
            return property.getReturnType().toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ignoredValue(Object value) {
        boolean bl;
        if (value == null) return true;
        Iterable $this$any$iv = this.ignoredClasses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Class ignored = (Class)element$iv;
                boolean bl2 = false;
                if (!ignored.isInstance(value)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!value.getClass().isPrimitive()) return false;
        return true;
    }

    public static final /* synthetic */ Object access$constantValueOf(ParameterFactory $this, KProperty1 property, Object instance) {
        return $this.constantValueOf(property, instance);
    }

    public static final /* synthetic */ boolean access$ignoredValue(ParameterFactory $this, Object value) {
        return $this.ignoredValue(value);
    }

    public static final /* synthetic */ Object access$constantValueOf(ParameterFactory $this, Field field) {
        return $this.constantValueOf(field);
    }

    public static final /* synthetic */ Class access$safeEnclosingClass(ParameterFactory $this, Class klass) {
        return $this.safeEnclosingClass(klass);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J%\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJj\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2V\u0010\u000b\u001aR\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u001c\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\"H\u0002J%\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020$H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020(H\u0002J%\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020*H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010&J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u000b\u001a\u00020\u0017H\u0002J$\u0010.\u001a\u0004\u0018\u00010\u00012\u0010\u0010/\u001a\f\u0012\u0004\u0012\u00020\u0001\u0012\u0002\b\u0003002\u0006\u00101\u001a\u00020\u0001H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00062"}, d2={"Landroidx/compose/ui/tooling/inspector/ParameterFactory$ParameterCreator;", "", "(Landroidx/compose/ui/tooling/inspector/ParameterFactory;)V", "node", "Landroidx/compose/ui/tooling/inspector/InspectorNode;", "recursions", "", "create", "Landroidx/compose/ui/tooling/inspector/NodeParameter;", "name", "", "value", "createFromBaselineShift", "Landroidx/compose/ui/text/style/BaselineShift;", "createFromBaselineShift-8a2Sb4w", "(Ljava/lang/String;F)Landroidx/compose/ui/tooling/inspector/NodeParameter;", "createFromCLambda", "Landroidx/compose/runtime/internal/ComposableLambda;", "Landroidx/compose/ui/tooling/inspector/CLambda;", "createFromConstant", "createFromCornerSize", "Landroidx/compose/foundation/shape/CornerSize;", "createFromFontListFamily", "Landroidx/compose/ui/text/font/FontListFontFamily;", "createFromImageVector", "Landroidx/compose/ui/graphics/vector/ImageVector;", "createFromInspectableValue", "Landroidx/compose/ui/platform/InspectableValue;", "createFromIterable", "", "createFromKotlinReflection", "createFromLambda", "Lkotlin/jvm/internal/Lambda;", "createFromModifier", "Landroidx/compose/ui/Modifier;", "createFromOffset", "Landroidx/compose/ui/geometry/Offset;", "createFromOffset-Uv8p0NA", "(Ljava/lang/String;J)Landroidx/compose/ui/tooling/inspector/NodeParameter;", "createFromShadow", "Landroidx/compose/ui/graphics/Shadow;", "createFromTextUnit", "Landroidx/compose/ui/unit/TextUnit;", "createFromTextUnit-mpE4wyQ", "findBestResourceFont", "Landroidx/compose/ui/text/font/ResourceFont;", "valueOf", "property", "Lkotlin/reflect/KProperty1;", "instance", "ui-tooling_release"})
    private final class ParameterCreator {
        @Nullable
        private InspectorNode node;
        private int recursions;

        public ParameterCreator() {
            Intrinsics.checkNotNullParameter((Object)ParameterFactory.this, (String)"this$0");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final NodeParameter create(@NotNull InspectorNode node, @NotNull String name, @Nullable Object value) {
            NodeParameter nodeParameter;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                this.node = node;
                this.recursions = 0;
                nodeParameter = this.create(name, value);
            }
            finally {
                this.node = null;
            }
            return nodeParameter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final NodeParameter create(String name, Object value) {
            NodeParameter nodeParameter;
            Object object;
            block26: {
                if (value == null || this.recursions >= 10) {
                    return null;
                }
                try {
                    object = this;
                    int n = ((ParameterCreator)object).recursions;
                    ((ParameterCreator)object).recursions = n + 1;
                    object = this.createFromConstant(name, value);
                    if (object == null) break block26;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    ParameterCreator parameterCreator = this;
                    int n2 = parameterCreator.recursions;
                    parameterCreator.recursions = n2 + -1;
                    return object3;
                }
                catch (Throwable throwable) {
                    ParameterCreator parameterCreator = this;
                    int n = parameterCreator.recursions;
                    parameterCreator.recursions = n + -1;
                    throw throwable;
                }
            }
            object = value;
            if (object instanceof AnnotatedString) {
                nodeParameter = new NodeParameter(name, ParameterType.String, ((AnnotatedString)value).getText());
            } else if (object instanceof BaselineShift) {
                nodeParameter = this.createFromBaselineShift-8a2Sb4w(name, ((BaselineShift)value).unbox-impl());
            } else if (object instanceof Boolean) {
                nodeParameter = new NodeParameter(name, ParameterType.Boolean, value);
            } else if (object instanceof ComposableLambda) {
                nodeParameter = this.createFromCLambda(name, (ComposableLambda)value);
            } else if (object instanceof Color) {
                nodeParameter = new NodeParameter(name, ParameterType.Color, ColorKt.toArgb-8_81llA((long)((Color)value).unbox-impl()));
            } else if (object instanceof CornerSize) {
                nodeParameter = this.createFromCornerSize(name, (CornerSize)value);
            } else if (object instanceof Double) {
                nodeParameter = new NodeParameter(name, ParameterType.Double, value);
            } else if (object instanceof Dp) {
                nodeParameter = new NodeParameter(name, ParameterType.DimensionDp, Float.valueOf(((Dp)value).unbox-impl()));
            } else if (object instanceof Enum) {
                nodeParameter = new NodeParameter(name, ParameterType.String, value.toString());
            } else if (object instanceof Float) {
                nodeParameter = new NodeParameter(name, ParameterType.Float, value);
            } else if (object instanceof FunctionReference) {
                Object[] objectArray = new Object[2];
                objectArray[0] = value;
                String string = ((FunctionReference)value).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.name");
                objectArray[1] = string;
                NodeParameter nodeParameter2 = new NodeParameter(name, ParameterType.FunctionReference, objectArray);
                nodeParameter = nodeParameter2;
            } else {
                nodeParameter = object instanceof FontListFontFamily ? this.createFromFontListFamily(name, (FontListFontFamily)value) : (object instanceof FontWeight ? new NodeParameter(name, ParameterType.Int32, ((FontWeight)value).getWeight()) : (object instanceof Modifier ? this.createFromModifier(name, (Modifier)value) : (object instanceof InspectableValue ? this.createFromInspectableValue(name, (InspectableValue)value) : (object instanceof Integer ? new NodeParameter(name, ParameterType.Int32, value) : (object instanceof Iterable ? this.createFromIterable(name, (Iterable)value) : (object instanceof Lambda ? this.createFromLambda(name, (Lambda)value) : (object instanceof Locale ? new NodeParameter(name, ParameterType.String, value.toString()) : (object instanceof LocaleList ? new NodeParameter(name, ParameterType.String, CollectionsKt.joinToString$default((Iterable)((LocaleList)value).getLocaleList(), null, null, null, (int)0, null, null, (int)63, null)) : (object instanceof Long ? new NodeParameter(name, ParameterType.Int64, value) : (object instanceof Offset ? this.createFromOffset-Uv8p0NA(name, ((Offset)value).unbox-impl()) : (object instanceof Shadow ? this.createFromShadow(name, (Shadow)value) : (object instanceof SolidColor ? new NodeParameter(name, ParameterType.Color, ColorKt.toArgb-8_81llA((long)((SolidColor)value).getValue-0d7_KjU())) : (object instanceof String ? new NodeParameter(name, ParameterType.String, value) : (object instanceof TextUnit ? this.createFromTextUnit-mpE4wyQ(name, ((TextUnit)value).unbox-impl()) : (object instanceof ImageVector ? this.createFromImageVector(name, (ImageVector)value) : (object instanceof View ? new NodeParameter(name, ParameterType.String, value.getClass().getSimpleName()) : this.createFromKotlinReflection(name, value)))))))))))))))));
            }
            object = nodeParameter;
            ParameterCreator parameterCreator = this;
            int n = parameterCreator.recursions;
            parameterCreator.recursions = n + -1;
            return object;
        }

        private final NodeParameter createFromBaselineShift-8a2Sb4w(String name, float value) {
            String string;
            float f = value;
            if (f == BaselineShift.Companion.getNone-y9eOQZs()) {
                string = "None";
            } else if (f == BaselineShift.Companion.getSubscript-y9eOQZs()) {
                string = "Subscript";
            } else if (f == BaselineShift.Companion.getSuperscript-y9eOQZs()) {
                string = "Superscript";
            } else {
                return new NodeParameter(name, ParameterType.Float, Float.valueOf(value));
            }
            String converted = string;
            return new NodeParameter(name, ParameterType.String, converted);
        }

        private final NodeParameter createFromCLambda(String name, ComposableLambda<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> value) {
            NodeParameter nodeParameter;
            try {
                Object[] objectArray = value.getClass().getDeclaredField("_block");
                boolean bl = false;
                boolean bl2 = false;
                Object[] $this$createFromCLambda_u24lambda_u2d1 = objectArray;
                boolean bl3 = false;
                $this$createFromCLambda_u24lambda_u2d1.setAccessible(true);
                Object lambda = objectArray.get(value);
                objectArray = new Object[]{lambda};
                nodeParameter = new NodeParameter(name, ParameterType.Lambda, objectArray);
            }
            catch (Throwable _) {
                nodeParameter = null;
            }
            return nodeParameter;
        }

        private final NodeParameter createFromConstant(String name, Object value) {
            NodeParameter nodeParameter;
            if (!ParameterFactory.this.kotlinReflectionSupported) {
                return null;
            }
            ParameterFactory.this.loadConstantsFrom(value.getClass());
            String string = (String)ParameterFactory.this.valueLookup.get(value);
            if (string == null) {
                nodeParameter = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                nodeParameter = new NodeParameter(name, ParameterType.String, it);
            }
            return nodeParameter;
        }

        /*
         * WARNING - void declaration
         */
        private final NodeParameter createFromCornerSize(String name, CornerSize value) {
            void $this$createFromCornerSize_u24lambda_u2d3;
            InspectorNode inspectorNode = this.node;
            Intrinsics.checkNotNull((Object)inspectorNode);
            float f = inspectorNode.getWidth();
            inspectorNode = this.node;
            Intrinsics.checkNotNull((Object)inspectorNode);
            long size = SizeKt.Size((float)f, (float)inspectorNode.getHeight());
            float pixels = value.toPx-TmRCtEA(size, ParameterFactory.this.getDensity());
            Density density = ParameterFactory.this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            Density density2 = density;
            ParameterType parameterType = ParameterType.DimensionDp;
            String string = name;
            boolean bl3 = false;
            Float f2 = Float.valueOf($this$createFromCornerSize_u24lambda_u2d3.toDp-u2uoSUM(pixels));
            Float f3 = f2;
            ParameterType parameterType2 = parameterType;
            String string2 = string;
            return new NodeParameter(string2, parameterType2, f3);
        }

        private final NodeParameter createFromFontListFamily(String name, FontListFontFamily value) {
            NodeParameter nodeParameter;
            ResourceFont resourceFont = this.findBestResourceFont(value);
            if (resourceFont == null) {
                nodeParameter = null;
            } else {
                ResourceFont resourceFont2 = resourceFont;
                boolean bl = false;
                boolean bl2 = false;
                ResourceFont it = resourceFont2;
                boolean bl3 = false;
                nodeParameter = new NodeParameter(name, ParameterType.Resource, it.getResId());
            }
            return nodeParameter;
        }

        /*
         * WARNING - void declaration
         */
        private final NodeParameter createFromKotlinReflection(String name, Object value) {
            void $this$mapNotNullTo$iv;
            KClass kClass;
            block14: {
                block13: {
                    boolean bl;
                    block12: {
                        kClass = Reflection.getOrCreateKotlinClass(value.getClass());
                        String qualifiedName = kClass.getQualifiedName();
                        if (kClass.getSimpleName() == null || qualifiedName == null) break block13;
                        Iterable $this$any$iv = ParameterFactory.this.ignoredPackagePrefixes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.startsWith$default((String)qualifiedName, (String)it, (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (!bl && ParameterFactory.this.kotlinReflectionSupported) break block14;
                }
                return null;
            }
            NodeParameter parameter = new NodeParameter(name, ParameterType.String, kClass.getSimpleName());
            boolean bl = false;
            Map properties = new LinkedHashMap();
            try {
                void $this$associateByTo$iv;
                Sequence $this$filterIsInstance$iv;
                KClass[] kClassArray = new KClass[]{kClass};
                kClassArray = SequencesKt.flatMap((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])kClassArray), (Sequence)CollectionsKt.asSequence((Iterable)KClasses.getAllSuperclasses((KClass)kClass))), (Function1)createFromKotlinReflection.2.INSTANCE);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)ParameterCreator$createFromKotlinReflection$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $this$filterIsInstance$iv = sequence;
                boolean $i$f$associateByTo = false;
                for (Object element$iv : $this$associateByTo$iv) {
                    void it;
                    KProperty1 kProperty1 = (KProperty1)element$iv;
                    Map map = properties;
                    boolean bl3 = false;
                    String string = it.getName();
                    map.put(string, element$iv);
                }
            }
            catch (Throwable ex) {
                Log.w((String)"Compose", (String)Intrinsics.stringPlus((String)"Could not decompose ", (Object)kClass.getSimpleName()));
                return parameter;
            }
            Iterable ex = properties.values();
            Collection destination$iv = parameter.getElements();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                NodeParameter nodeParameter;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl4 = false;
                KProperty1 it = (KProperty1)element$iv;
                boolean bl5 = false;
                if (this.create(it.getName(), this.valueOf(it, value)) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                NodeParameter it$iv = nodeParameter;
                boolean bl8 = false;
                destination$iv.add(it$iv);
            }
            return parameter;
        }

        private final Object valueOf(KProperty1<Object, ?> property, Object instance) {
            Object object;
            try {
                KCallablesJvm.setAccessible((KCallable)((KCallable)property), (boolean)true);
                object = property.get(instance);
            }
            catch (Throwable ex) {
                Log.w((String)"Compose", (String)Intrinsics.stringPlus((String)"Could not get value of ", (Object)property.getName()));
                object = null;
            }
            return object;
        }

        private final NodeParameter createFromInspectableValue(String name, InspectableValue value) {
            CharSequence charSequence;
            Object object = value.getValueOverride();
            Object tempValue = object == null ? "" : object;
            CharSequence charSequence2 = name;
            boolean bl = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl2 = false;
            if (charSequence3.length() == 0) {
                boolean bl3 = false;
                charSequence = value.getNameFallback();
            } else {
                charSequence = charSequence2;
            }
            String string = (String)charSequence;
            String parameterName = string == null ? "element" : string;
            Object parameterValue = tempValue instanceof InspectableValue ? "" : tempValue;
            NodeParameter nodeParameter = this.create(parameterName, parameterValue);
            NodeParameter parameter = nodeParameter == null ? new NodeParameter(parameterName, ParameterType.String, "") : nodeParameter;
            List<NodeParameter> elements = parameter.getElements();
            Sequence $this$mapNotNullTo$iv = value.getInspectableElements();
            boolean $i$f$mapNotNullTo = false;
            Sequence $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                NodeParameter nodeParameter2;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl4 = false;
                ValueElement it = (ValueElement)element$iv;
                boolean bl5 = false;
                if (this.create(it.getName(), it.getValue()) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                NodeParameter it$iv = nodeParameter2;
                boolean bl8 = false;
                ((Collection)elements).add(it$iv);
            }
            return parameter;
        }

        private final NodeParameter createFromIterable(String name, Iterable<?> value) {
            NodeParameter parameter = new NodeParameter(name, ParameterType.String, "");
            List<NodeParameter> elements = parameter.getElements();
            SequencesKt.toCollection((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence(value), (Function1)((Function1)new Function1<Object, NodeParameter>(this, elements){
                final /* synthetic */ ParameterCreator this$0;
                final /* synthetic */ List<NodeParameter> $elements;
                {
                    this.this$0 = $receiver;
                    this.$elements = $elements;
                    super(1);
                }

                @Nullable
                public final NodeParameter invoke(@Nullable Object it) {
                    return ParameterCreator.access$create(this.this$0, String.valueOf(this.$elements.size()), it);
                }
            })), (Function1)((Function1)new Function1<NodeParameter, Boolean>(elements){
                final /* synthetic */ List<NodeParameter> $elements;
                {
                    this.$elements = $elements;
                    super(1);
                }

                public final boolean invoke(@NotNull NodeParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$elements.size() < 25;
                }
            })), (Collection)elements);
            return parameter;
        }

        private final NodeParameter createFromLambda(String name, Lambda<?> value) {
            Object[] objectArray = new Object[]{value};
            return new NodeParameter(name, ParameterType.Lambda, objectArray);
        }

        private final NodeParameter createFromModifier(String name, Modifier value) {
            Object object;
            CharSequence charSequence = name;
            boolean bl = false;
            if (charSequence.length() > 0) {
                NodeParameter parameter = new NodeParameter(name, ParameterType.String, "");
                List<NodeParameter> elements = parameter.getElements();
                value.foldIn(elements, (Function2)new Function2<List<NodeParameter>, Modifier.Element, List<NodeParameter>>(this){
                    final /* synthetic */ ParameterCreator this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final List<NodeParameter> invoke(@NotNull List<NodeParameter> acc, @NotNull Modifier.Element m) {
                        List<NodeParameter> list;
                        Intrinsics.checkNotNullParameter(acc, (String)"acc");
                        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                        NodeParameter nodeParameter = ParameterCreator.access$create(this.this$0, "", m);
                        if (nodeParameter == null) {
                            list = acc;
                        } else {
                            List<NodeParameter> list2;
                            NodeParameter nodeParameter2 = nodeParameter;
                            boolean bl = false;
                            boolean bl2 = false;
                            NodeParameter param = nodeParameter2;
                            boolean bl3 = false;
                            List<NodeParameter> list3 = acc;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            List<NodeParameter> $this$invoke_u24lambda_u2d1_u24lambda_u2d0 = list3;
                            boolean bl6 = false;
                            $this$invoke_u24lambda_u2d1_u24lambda_u2d0.add(param);
                            list = list2 = list3;
                        }
                        return list;
                    }
                });
                object = charSequence;
            } else {
                object = value instanceof InspectableValue ? this.createFromInspectableValue(name, (InspectableValue)value) : null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final NodeParameter createFromOffset-Uv8p0NA(String name, long value) {
            void $this$createFromOffset_Uv8p0NA_u24lambda_u2d11;
            Density $this$createFromOffset_Uv8p0NA_u24lambda_u2d10;
            NodeParameter parameter = new NodeParameter(name, ParameterType.String, Offset.class.getSimpleName());
            List<NodeParameter> elements = parameter.getElements();
            Density density = ParameterFactory.this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            Density density2 = density;
            ParameterType parameterType = ParameterType.DimensionDp;
            String string = "x";
            List<NodeParameter> list = elements;
            boolean bl3 = false;
            Float f = Float.valueOf($this$createFromOffset_Uv8p0NA_u24lambda_u2d10.toDp-u2uoSUM(Offset.getX-impl((long)value)));
            Float f2 = f;
            ParameterType parameterType2 = parameterType;
            String string2 = string;
            list.add(new NodeParameter(string2, parameterType2, f2));
            density = ParameterFactory.this.getDensity();
            bl = false;
            bl2 = false;
            $this$createFromOffset_Uv8p0NA_u24lambda_u2d10 = density;
            parameterType = ParameterType.DimensionDp;
            string = "y";
            list = elements;
            boolean bl4 = false;
            f = Float.valueOf($this$createFromOffset_Uv8p0NA_u24lambda_u2d11.toDp-u2uoSUM(Offset.getY-impl((long)value)));
            Float f3 = f;
            ParameterType parameterType3 = parameterType;
            String string3 = string;
            list.add(new NodeParameter(string3, parameterType3, f3));
            return parameter;
        }

        private final NodeParameter createFromShadow(String name, Shadow value) {
            int index;
            List<NodeParameter> elements;
            NodeParameter parameter;
            block4: {
                int n;
                NodeParameter nodeParameter = this.createFromKotlinReflection(name, value);
                if (nodeParameter == null) {
                    return null;
                }
                parameter = nodeParameter;
                List<NodeParameter> $this$indexOfFirst$iv = elements = parameter.getElements();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<NodeParameter> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    NodeParameter item$iv;
                    NodeParameter it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)"blurRadius")) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                Density density = ParameterFactory.this.getDensity();
                boolean bl = false;
                boolean bl2 = false;
                Density $this$createFromShadow_u24lambda_u2d13 = density;
                boolean bl3 = false;
                float blurRadius = $this$createFromShadow_u24lambda_u2d13.toDp-u2uoSUM(value.getBlurRadius());
                elements.set(index, new NodeParameter("blurRadius", ParameterType.DimensionDp, Float.valueOf(blurRadius)));
            }
            return parameter;
        }

        private final NodeParameter createFromTextUnit-mpE4wyQ(String name, long value) {
            NodeParameter nodeParameter;
            TextUnitType textUnitType = TextUnit.getType-impl((long)value);
            int n = WhenMappings.$EnumSwitchMapping$0[textUnitType.ordinal()];
            switch (n) {
                case 1: {
                    nodeParameter = new NodeParameter(name, ParameterType.DimensionSp, Float.valueOf(TextUnit.getValue-impl((long)value)));
                    break;
                }
                case 2: {
                    nodeParameter = new NodeParameter(name, ParameterType.DimensionEm, Float.valueOf(TextUnit.getValue-impl((long)value)));
                    break;
                }
                case 3: {
                    nodeParameter = new NodeParameter(name, ParameterType.String, "Unspecified");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return nodeParameter;
        }

        private final NodeParameter createFromImageVector(String name, ImageVector value) {
            return new NodeParameter(name, ParameterType.String, value.getName());
        }

        private final ResourceFont findBestResourceFont(FontListFontFamily value) {
            Object v1;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)value.getFonts());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)ParameterCreator$findBestResourceFont$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence $this$minByOrNull$iv = sequence;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    ResourceFont it = (ResourceFont)minElem$iv;
                    boolean bl = false;
                    int n = it.getWeight().getWeight() - FontWeight.Companion.getNormal().getWeight();
                    boolean bl2 = false;
                    int minValue$iv = Math.abs(n) + it.getStyle().ordinal();
                    do {
                        Object e$iv = iterator$iv.next();
                        ResourceFont it2 = (ResourceFont)e$iv;
                        $i$a$-minByOrNull-ParameterFactory$ParameterCreator$findBestResourceFont$1 = false;
                        int n2 = it2.getWeight().getWeight() - FontWeight.Companion.getNormal().getWeight();
                        boolean bl3 = false;
                        int v$iv = Math.abs(n2) + it2.getStyle().ordinal();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            return v1;
        }

        public static final /* synthetic */ NodeParameter access$create(ParameterCreator $this, String name, Object value) {
            return $this.create(name, value);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TextUnitType.values().length];
                nArray[TextUnitType.Sp.ordinal()] = 1;
                nArray[TextUnitType.Em.ordinal()] = 2;
                nArray[TextUnitType.Unspecified.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

