/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.compose.animation.core.Animatable;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.DecayAnimation;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.InfiniteRepeatableSpec;
import androidx.compose.animation.core.InfiniteTransition;
import androidx.compose.animation.core.KeyframesSpec;
import androidx.compose.animation.core.RepeatableSpec;
import androidx.compose.animation.core.SnapSpec;
import androidx.compose.animation.core.StartOffset;
import androidx.compose.animation.core.StartOffsetType;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.Transition;
import androidx.compose.animation.core.TweenSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.ComposeAnimation;
import androidx.compose.animation.tooling.ComposeAnimationType;
import androidx.compose.animation.tooling.TransitionInfo;
import androidx.compose.ui.tooling.animation.AnimatedVisibilityComposeAnimation;
import androidx.compose.ui.tooling.animation.AnimatedVisibilityState;
import androidx.compose.ui.tooling.animation.ComposeAnimationParserKt;
import androidx.compose.ui.tooling.animation.PreviewAnimationClock;
import androidx.compose.ui.tooling.animation.TransitionComposeAnimation;
import androidx.compose.ui.tooling.animation.UnsupportedComposeAnimation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001:\u0002pqB\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u00103\u001a\u00020\u0004J\u0014\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u000208J\u001e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020!\u00f8\u0001\u0001\u00f8\u0001\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b;\u0010<J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020>J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020A052\u0006\u00107\u001a\u0002082\u0006\u0010B\u001a\u00020>J\u0010\u0010C\u001a\u00020>2\u0006\u0010D\u001a\u00020>H\u0002J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020>H\u0002J\u0010\u0010G\u001a\u00020\u00042\u0006\u00107\u001a\u000208H\u0015J\u0010\u0010H\u001a\u00020\u00042\u0006\u00107\u001a\u000208H\u0015J\u000e\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020>J\u001a\u0010K\u001a\u00020\u00042\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020>0MJ\u000e\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u0001J\u0016\u0010P\u001a\u00020\u00042\u000e\u0010Q\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rJ\u0012\u0010R\u001a\u00020\u00042\n\u0010S\u001a\u0006\u0012\u0002\b\u00030\u000fJ$\u0010T\u001a\u00020\u00042\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u000e\b\u0002\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0016\u0010W\u001a\u00020\u00042\u000e\u0010X\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aJ\u000e\u0010Y\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020\u001cJ\u0016\u0010[\u001a\u00020\u00042\u000e\u0010\\\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001eJ\u0014\u0010]\u001a\u00020\u00042\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fJ\u0016\u0010_\u001a\u00020\u00042\u0006\u0010:\u001a\u00020!2\u0006\u0010`\u001a\u00020\u0001J\u001e\u0010a\u001a\u00020\u00042\u0006\u0010:\u001a\u0002082\u0006\u0010b\u001a\u00020\u00012\u0006\u0010c\u001a\u00020\u0001J&\u0010d\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u00030eR\u0006\u0012\u0002\b\u00030\u000f05*\u0006\u0012\u0002\b\u00030\u000fH\u0002JB\u0010f\u001a\u00020A\"\u0004\b\u0000\u0010g\"\b\b\u0001\u0010h*\u00020i\"\u0004\b\u0002\u0010j*\u0018\u0012\u0004\u0012\u0002Hg\u0012\u0004\u0012\u0002Hh0eR\b\u0012\u0004\u0012\u0002Hj0\u000f2\b\b\u0002\u0010k\u001a\u00020>H\u0002J%\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070m*\u00020\u0012H\u0002\u00f8\u0001\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bn\u0010oR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00010\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\u0010\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0012\u0004\u0012\u00020\u00120\u0011j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0012\u0004\u0012\u00020\u0012`\u00138\u0000X\u0081\u0004\u00f8\u0001\u0000\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a0\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001c0\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e0\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\u0015\u001a\u0004\b$\u0010%R,\u0010&\u001a\u0012\u0012\u0004\u0012\u00020'0 j\b\u0012\u0004\u0012\u00020'`\"8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0015\u001a\u0004\b)\u0010%R,\u0010*\u001a\u0012\u0012\u0004\u0012\u00020+0 j\b\u0012\u0004\u0012\u00020+`\"8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b,\u0010\u0015\u001a\u0004\b-\u0010%RD\u0010.\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0012\u0004\u0012\u00020/0\u0011j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0012\u0004\u0012\u00020/`\u00138\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0015\u001a\u0004\b1\u0010\u0017R\u000e\u00102\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006r"}, d2={"Landroidx/compose/ui/tooling/animation/PreviewAnimationClock;", "", "setAnimationsTimeCallback", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "DEBUG", "", "TAG", "", "animateContentSizeSubscriber", "Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$UnsupportedComposeAnimationSubscriber;", "animateXAsStateSubscriber", "Landroidx/compose/animation/core/Animatable;", "animatedContentSubscriber", "Landroidx/compose/animation/core/Transition;", "animatedVisibilityStates", "Ljava/util/HashMap;", "Landroidx/compose/ui/tooling/animation/AnimatedVisibilityState;", "Lkotlin/collections/HashMap;", "getAnimatedVisibilityStates$ui_tooling_release$annotations", "()V", "getAnimatedVisibilityStates$ui_tooling_release", "()Ljava/util/HashMap;", "animatedVisibilityStatesLock", "decayAnimationSubscriber", "Landroidx/compose/animation/core/DecayAnimation;", "infiniteTransitionSubscriber", "Landroidx/compose/animation/core/InfiniteTransition;", "targetBasedAnimationSubscriber", "Landroidx/compose/animation/core/TargetBasedAnimation;", "trackedAnimatedVisibility", "Ljava/util/LinkedHashSet;", "Landroidx/compose/ui/tooling/animation/AnimatedVisibilityComposeAnimation;", "Lkotlin/collections/LinkedHashSet;", "getTrackedAnimatedVisibility$ui_tooling_release$annotations", "getTrackedAnimatedVisibility$ui_tooling_release", "()Ljava/util/LinkedHashSet;", "trackedTransitions", "Landroidx/compose/ui/tooling/animation/TransitionComposeAnimation;", "getTrackedTransitions$ui_tooling_release$annotations", "getTrackedTransitions$ui_tooling_release", "trackedUnsupported", "Landroidx/compose/ui/tooling/animation/UnsupportedComposeAnimation;", "getTrackedUnsupported$ui_tooling_release$annotations", "getTrackedUnsupported$ui_tooling_release", "transitionStates", "Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$TransitionState;", "getTransitionStates$ui_tooling_release$annotations", "getTransitionStates$ui_tooling_release", "transitionStatesLock", "dispose", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "animation", "Landroidx/compose/animation/tooling/ComposeAnimation;", "getAnimatedVisibilityState", "composeAnimation", "getAnimatedVisibilityState-zrx7VqY", "(Landroidx/compose/ui/tooling/animation/AnimatedVisibilityComposeAnimation;)Ljava/lang/String;", "getMaxDuration", "", "getMaxDurationPerIteration", "getTransitions", "Landroidx/compose/animation/tooling/TransitionInfo;", "stepMillis", "millisToNanos", "timeMs", "nanosToMillis", "timeNs", "notifySubscribe", "notifyUnsubscribe", "setClockTime", "animationTimeMs", "setClockTimes", "animationTimeMillis", "", "trackAnimateContentSize", "sizeAnimationModifier", "trackAnimateXAsState", "animatable", "trackAnimatedContent", "animatedContent", "trackAnimatedVisibility", "parent", "onSeek", "trackDecayAnimations", "decayAnimation", "trackInfiniteTransition", "infiniteTransition", "trackTargetBasedAnimations", "targetBasedAnimation", "trackTransition", "transition", "updateAnimatedVisibilityState", "state", "updateFromAndToStates", "fromState", "toState", "allAnimations", "Landroidx/compose/animation/core/Transition$TransitionAnimationState;", "createTransitionInfo", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "S", "stepMs", "toCurrentTargetPair", "Lkotlin/Pair;", "toCurrentTargetPair-RvB7uIg", "(Ljava/lang/String;)Lkotlin/Pair;", "TransitionState", "UnsupportedComposeAnimationSubscriber", "ui-tooling_release"})
public class PreviewAnimationClock {
    @NotNull
    private final Function0<Unit> setAnimationsTimeCallback;
    @NotNull
    private final String TAG;
    private final boolean DEBUG;
    @NotNull
    private final LinkedHashSet<TransitionComposeAnimation> trackedTransitions;
    @NotNull
    private final LinkedHashSet<AnimatedVisibilityComposeAnimation> trackedAnimatedVisibility;
    @NotNull
    private final LinkedHashSet<UnsupportedComposeAnimation> trackedUnsupported;
    @NotNull
    private final HashMap<Transition<Object>, TransitionState> transitionStates;
    @NotNull
    private final Object transitionStatesLock;
    @NotNull
    private final HashMap<Transition<Object>, AnimatedVisibilityState> animatedVisibilityStates;
    @NotNull
    private final Object animatedVisibilityStatesLock;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<Animatable<?, ?>> animateXAsStateSubscriber;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<Object> animateContentSizeSubscriber;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<TargetBasedAnimation<?, ?>> targetBasedAnimationSubscriber;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<DecayAnimation<?, ?>> decayAnimationSubscriber;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<Transition<?>> animatedContentSubscriber;
    @NotNull
    private final UnsupportedComposeAnimationSubscriber<InfiniteTransition> infiniteTransitionSubscriber;

    public PreviewAnimationClock(@NotNull Function0<Unit> setAnimationsTimeCallback) {
        Intrinsics.checkNotNullParameter(setAnimationsTimeCallback, (String)"setAnimationsTimeCallback");
        this.setAnimationsTimeCallback = setAnimationsTimeCallback;
        this.TAG = "PreviewAnimationClock";
        this.trackedTransitions = new LinkedHashSet();
        this.trackedAnimatedVisibility = new LinkedHashSet();
        this.trackedUnsupported = new LinkedHashSet();
        this.transitionStates = new HashMap();
        this.transitionStatesLock = new Object();
        this.animatedVisibilityStates = new HashMap();
        this.animatedVisibilityStatesLock = new Object();
        this.animateXAsStateSubscriber = new UnsupportedComposeAnimationSubscriber();
        this.animateContentSizeSubscriber = new UnsupportedComposeAnimationSubscriber();
        this.targetBasedAnimationSubscriber = new UnsupportedComposeAnimationSubscriber();
        this.decayAnimationSubscriber = new UnsupportedComposeAnimationSubscriber();
        this.animatedContentSubscriber = new UnsupportedComposeAnimationSubscriber();
        this.infiniteTransitionSubscriber = new UnsupportedComposeAnimationSubscriber();
    }

    public /* synthetic */ PreviewAnimationClock(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Unit>)function0);
    }

    @NotNull
    public final LinkedHashSet<TransitionComposeAnimation> getTrackedTransitions$ui_tooling_release() {
        return this.trackedTransitions;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTrackedTransitions$ui_tooling_release$annotations() {
    }

    @NotNull
    public final LinkedHashSet<AnimatedVisibilityComposeAnimation> getTrackedAnimatedVisibility$ui_tooling_release() {
        return this.trackedAnimatedVisibility;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTrackedAnimatedVisibility$ui_tooling_release$annotations() {
    }

    @NotNull
    public final LinkedHashSet<UnsupportedComposeAnimation> getTrackedUnsupported$ui_tooling_release() {
        return this.trackedUnsupported;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTrackedUnsupported$ui_tooling_release$annotations() {
    }

    @NotNull
    public final HashMap<Transition<Object>, TransitionState> getTransitionStates$ui_tooling_release() {
        return this.transitionStates;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTransitionStates$ui_tooling_release$annotations() {
    }

    @NotNull
    public final HashMap<Transition<Object>, AnimatedVisibilityState> getAnimatedVisibilityStates$ui_tooling_release() {
        return this.animatedVisibilityStates;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAnimatedVisibilityStates$ui_tooling_release$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackTransition(@NotNull Transition<Object> transition) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Object object = this.transitionStatesLock;
        synchronized (object) {
            boolean bl = false;
            if (this.transitionStates.containsKey(transition)) {
                if (this.DEBUG) {
                    Log.d((String)this.TAG, (String)("Transition " + transition + " is already being tracked"));
                }
                return;
            }
            ((Map)this.transitionStates).put(transition, new TransitionState(transition.getCurrentState(), transition.getTargetState()));
            Unit unit = Unit.INSTANCE;
        }
        if (this.DEBUG) {
            Log.d((String)this.TAG, (String)("Transition " + transition + " is now tracked"));
        }
        TransitionComposeAnimation composeAnimation = ComposeAnimationParserKt.parse(transition);
        this.trackedTransitions.add(composeAnimation);
        this.notifySubscribe(composeAnimation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackAnimatedVisibility(@NotNull Transition<Object> parent, @NotNull Function0<Unit> onSeek) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(onSeek, (String)"onSeek");
        Pair<Boolean, Boolean> pair = this.animatedVisibilityStatesLock;
        synchronized (pair) {
            boolean bl = false;
            if (this.animatedVisibilityStates.containsKey(parent)) {
                if (this.DEBUG) {
                    Log.d((String)this.TAG, (String)("AnimatedVisibility transition " + parent + " is already being tracked"));
                }
                return;
            }
            Map map = this.animatedVisibilityStates;
            Object object = parent.getCurrentState();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            AnimatedVisibilityState animatedVisibilityState = AnimatedVisibilityState.box-impl((Boolean)object != false ? AnimatedVisibilityState.Companion.getExit-q9NwIk0() : AnimatedVisibilityState.Companion.getEnter-q9NwIk0());
            map.put(parent, animatedVisibilityState);
            Unit $i$a$-synchronized-PreviewAnimationClock$trackAnimatedVisibility$3 = Unit.INSTANCE;
        }
        if (this.DEBUG) {
            Log.d((String)this.TAG, (String)("AnimatedVisibility transition " + parent + " is now tracked"));
        }
        AnimatedVisibilityComposeAnimation composeAnimation = ComposeAnimationParserKt.parseAnimatedVisibility(parent);
        AnimatedVisibilityState animatedVisibilityState = this.animatedVisibilityStates.get(parent);
        Intrinsics.checkNotNull((Object)animatedVisibilityState);
        pair = this.toCurrentTargetPair-RvB7uIg(animatedVisibilityState.unbox-impl());
        boolean current = (Boolean)pair.component1();
        boolean target = (Boolean)pair.component2();
        parent.seek((Object)current, (Object)target, 0L);
        onSeek.invoke();
        this.trackedAnimatedVisibility.add(composeAnimation);
        this.notifySubscribe(composeAnimation);
    }

    public static /* synthetic */ void trackAnimatedVisibility$default(PreviewAnimationClock previewAnimationClock, Transition transition, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trackAnimatedVisibility");
        }
        if ((n & 2) != 0) {
            function0 = trackAnimatedVisibility.1.INSTANCE;
        }
        previewAnimationClock.trackAnimatedVisibility((Transition<Object>)transition, (Function0<Unit>)function0);
    }

    public final void trackAnimateXAsState(@NotNull Animatable<?, ?> animatable) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        this.animateXAsStateSubscriber.trackAnimation(animatable, animatable.getLabel());
    }

    public final void trackAnimateContentSize(@NotNull Object sizeAnimationModifier) {
        Intrinsics.checkNotNullParameter((Object)sizeAnimationModifier, (String)"sizeAnimationModifier");
        this.animateContentSizeSubscriber.trackAnimation(sizeAnimationModifier, "animateContentSize");
    }

    public final void trackTargetBasedAnimations(@NotNull TargetBasedAnimation<?, ?> targetBasedAnimation) {
        Intrinsics.checkNotNullParameter(targetBasedAnimation, (String)"targetBasedAnimation");
        this.targetBasedAnimationSubscriber.trackAnimation(targetBasedAnimation, "TargetBasedAnimation");
    }

    public final void trackDecayAnimations(@NotNull DecayAnimation<?, ?> decayAnimation) {
        Intrinsics.checkNotNullParameter(decayAnimation, (String)"decayAnimation");
        this.decayAnimationSubscriber.trackAnimation(decayAnimation, "DecayAnimation");
    }

    public final void trackAnimatedContent(@NotNull Transition<?> animatedContent) {
        Intrinsics.checkNotNullParameter(animatedContent, (String)"animatedContent");
        this.animatedContentSubscriber.trackAnimation(animatedContent, "AnimatedContent");
    }

    public final void trackInfiniteTransition(@NotNull InfiniteTransition infiniteTransition) {
        Intrinsics.checkNotNullParameter((Object)infiniteTransition, (String)"infiniteTransition");
        this.infiniteTransitionSubscriber.trackAnimation(infiniteTransition, "InfiniteTransition");
    }

    @VisibleForTesting
    protected void notifySubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    @VisibleForTesting
    protected void notifyUnsubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateFromAndToStates(@NotNull ComposeAnimation composeAnimation, @NotNull Object fromState, @NotNull Object toState) {
        Intrinsics.checkNotNullParameter((Object)composeAnimation, (String)"composeAnimation");
        Intrinsics.checkNotNullParameter((Object)fromState, (String)"fromState");
        Intrinsics.checkNotNullParameter((Object)toState, (String)"toState");
        if (composeAnimation.getType() != ComposeAnimationType.TRANSITION_ANIMATION) {
            return;
        }
        if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)composeAnimation)) {
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)composeAnimation;
            Object object = this.transitionStatesLock;
            synchronized (object) {
                boolean bl = false;
                ((Map)this.transitionStates).put(transitionComposeAnimation.getAnimationObject(), new TransitionState(fromState, toState));
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAnimatedVisibilityState(@NotNull AnimatedVisibilityComposeAnimation composeAnimation, @NotNull Object state) {
        Intrinsics.checkNotNullParameter((Object)composeAnimation, (String)"composeAnimation");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.trackedAnimatedVisibility.contains(composeAnimation)) {
            Object object = this.animatedVisibilityStatesLock;
            synchronized (object) {
                boolean bl = false;
                ((Map)this.animatedVisibilityStates).put(composeAnimation.getAnimationObject(), (AnimatedVisibilityState)state);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final String getAnimatedVisibilityState-zrx7VqY(@NotNull AnimatedVisibilityComposeAnimation composeAnimation) {
        Intrinsics.checkNotNullParameter((Object)composeAnimation, (String)"composeAnimation");
        AnimatedVisibilityState animatedVisibilityState = this.animatedVisibilityStates.get(composeAnimation.getAnimationObject());
        String string = animatedVisibilityState != null ? animatedVisibilityState.unbox-impl() : null;
        return string == null ? AnimatedVisibilityState.Companion.getEnter-q9NwIk0() : string;
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDuration() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.trackedTransitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void composeAnimation;
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.nanosToMillis(composeAnimation.getAnimationObject().getTotalDurationNanos()));
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        long transitionsDuration = l != null ? l : -1L;
        Iterable $this$map$iv2 = this.trackedAnimatedVisibility;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long l2;
            void composeAnimation;
            AnimatedVisibilityComposeAnimation animatedVisibilityComposeAnimation = (AnimatedVisibilityComposeAnimation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Transition<Object> transition = composeAnimation.getChildTransition();
            collection.add(transition == null ? (l2 = -1L) : this.nanosToMillis(transition.getTotalDurationNanos()));
        }
        Long l3 = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        long animatedVisibilityDuration = l3 != null ? l3 : -1L;
        return Math.max(transitionsDuration, animatedVisibilityDuration);
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDurationPerIteration() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.trackedTransitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void composeAnimation;
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.nanosToMillis(composeAnimation.getAnimationObject().getTotalDurationNanos()));
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        long transitionsDuration = l != null ? l : -1L;
        Iterable $this$map$iv2 = this.trackedAnimatedVisibility;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long l2;
            void composeAnimation;
            AnimatedVisibilityComposeAnimation animatedVisibilityComposeAnimation = (AnimatedVisibilityComposeAnimation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Transition<Object> transition = composeAnimation.getChildTransition();
            collection.add(transition == null ? (l2 = -1L) : this.nanosToMillis(transition.getTotalDurationNanos()));
        }
        Long l3 = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        long animatedVisibilityDuration = l3 != null ? l3 : -1L;
        return Math.max(transitionsDuration, animatedVisibilityDuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ComposeAnimatedProperty> getAnimatedProperties(@NotNull ComposeAnimation animation) {
        Transition<Object> transition;
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)animation)) {
            void $this$mapNotNullTo$iv$iv;
            Transition<Object> transition2 = ((TransitionComposeAnimation)animation).getAnimationObject();
            Iterable $this$mapNotNull$iv = this.allAnimations(transition2);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ComposeAnimatedProperty composeAnimatedProperty;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Transition.TransitionAnimationState it = (Transition.TransitionAnimationState)element$iv$iv;
                boolean bl2 = false;
                if (it.getValue() == null) {
                    Object var16_29 = null;
                    it.getLabel();
                    composeAnimatedProperty = var16_29;
                } else {
                    Object object;
                    String string;
                    composeAnimatedProperty = new ComposeAnimatedProperty(string, object);
                }
                if (composeAnimatedProperty == null) continue;
                ComposeAnimatedProperty it$iv$iv = composeAnimatedProperty;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (CollectionsKt.contains((Iterable)this.trackedAnimatedVisibility, (Object)animation) && (transition = ((AnimatedVisibilityComposeAnimation)animation).getChildTransition()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Transition<Object> child = transition;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = this.allAnimations(child);
            boolean $i$f$mapNotNull = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                ComposeAnimatedProperty composeAnimatedProperty;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                Transition.TransitionAnimationState it = (Transition.TransitionAnimationState)element$iv$iv;
                boolean bl5 = false;
                if (it.getValue() == null) {
                    Object var19_37 = null;
                    it.getLabel();
                    composeAnimatedProperty = var19_37;
                } else {
                    Object object;
                    String string;
                    composeAnimatedProperty = new ComposeAnimatedProperty(string, object);
                }
                if (composeAnimatedProperty == null) continue;
                ComposeAnimatedProperty it$iv$iv = composeAnimatedProperty;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TransitionInfo> getTransitions(@NotNull ComposeAnimation animation, long stepMillis) {
        Transition<Object> transition;
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)animation)) {
            void $this$mapTo$iv$iv;
            Transition<Object> transition2 = ((TransitionComposeAnimation)animation).getAnimationObject();
            Iterable $this$map$iv = this.allAnimations(transition2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Transition.TransitionAnimationState transitionAnimationState = (Transition.TransitionAnimationState)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.createTransitionInfo((Transition.TransitionAnimationState)it, stepMillis));
            }
            return (List)destination$iv$iv;
        }
        if (CollectionsKt.contains((Iterable)this.trackedAnimatedVisibility, (Object)animation) && (transition = ((AnimatedVisibilityComposeAnimation)animation).getChildTransition()) != null) {
            void $this$mapTo$iv$iv;
            Transition<Object> child = transition;
            boolean bl = false;
            Iterable $this$map$iv = this.allAnimations(child);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Transition.TransitionAnimationState transitionAnimationState = (Transition.TransitionAnimationState)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.createTransitionInfo((Transition.TransitionAnimationState)it, stepMillis));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public final void setClockTime(long animationTimeMs) {
        void $this$associateWith$iv;
        Iterable iterable = SetsKt.plus((Set)this.trackedTransitions, (Iterable)this.trackedAnimatedVisibility);
        PreviewAnimationClock previewAnimationClock = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            ComposeAnimation composeAnimation = (ComposeAnimation)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Long l = animationTimeMs;
            map.put(t, l);
        }
        previewAnimationClock.setClockTimes(result$iv);
    }

    public final void setClockTimes(@NotNull Map<ComposeAnimation, Long> animationTimeMillis) {
        Intrinsics.checkNotNullParameter(animationTimeMillis, (String)"animationTimeMillis");
        Map<ComposeAnimation, Long> $this$forEach$iv = animationTimeMillis;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ComposeAnimation, Long>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object states;
            Transition<Object> it;
            Map.Entry<ComposeAnimation, Long> element$iv;
            Map.Entry<ComposeAnimation, Long> entry = element$iv = iterator.next();
            boolean bl = false;
            ComposeAnimation composeAnimation = entry.getKey();
            long millis = ((Number)entry.getValue()).longValue();
            long timeNs = TimeUnit.MILLISECONDS.toNanos(millis);
            if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)composeAnimation)) {
                Intrinsics.checkNotNull((Object)composeAnimation, (String)"null cannot be cast to non-null type androidx.compose.ui.tooling.animation.TransitionComposeAnimation");
                it = ((TransitionComposeAnimation)composeAnimation).getAnimationObject();
                boolean bl2 = false;
                if (this.transitionStates.get(it) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)states, (String)"transitionStates[it] ?: return@let");
                it.seek(states.getCurrent(), states.getTarget(), timeNs);
                continue;
            }
            if (!CollectionsKt.contains((Iterable)this.trackedAnimatedVisibility, (Object)composeAnimation)) continue;
            Intrinsics.checkNotNull((Object)composeAnimation, (String)"null cannot be cast to non-null type androidx.compose.ui.tooling.animation.AnimatedVisibilityComposeAnimation");
            it = ((AnimatedVisibilityComposeAnimation)composeAnimation).getAnimationObject();
            boolean bl3 = false;
            AnimatedVisibilityState animatedVisibilityState = this.animatedVisibilityStates.get(it);
            states = animatedVisibilityState != null ? animatedVisibilityState.unbox-impl() : null;
            Pair<Boolean, Boolean> pair = states;
            if (pair == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)(pair != null ? AnimatedVisibilityState.box-impl((String)pair) : null), (String)"animatedVisibilityStates[it]");
            pair = this.toCurrentTargetPair-RvB7uIg((String)states);
            if (pair == null) {
                continue;
            }
            Pair<Boolean, Boolean> pair2 = pair;
            boolean current = (Boolean)pair2.component1();
            boolean target = (Boolean)pair2.component2();
            it.seek((Object)current, (Object)target, timeNs);
        }
        this.setAnimationsTimeCallback.invoke();
    }

    public final void dispose() {
        Object it;
        Iterable $this$forEach$iv = this.trackedTransitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TransitionComposeAnimation)element$iv;
            boolean bl = false;
            this.notifyUnsubscribe((ComposeAnimation)it);
        }
        $this$forEach$iv = this.trackedAnimatedVisibility;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AnimatedVisibilityComposeAnimation)element$iv;
            boolean bl = false;
            this.notifyUnsubscribe((ComposeAnimation)it);
        }
        $this$forEach$iv = this.trackedUnsupported;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (UnsupportedComposeAnimation)element$iv;
            boolean bl = false;
            this.notifyUnsubscribe((ComposeAnimation)it);
        }
        this.trackedAnimatedVisibility.clear();
        this.trackedTransitions.clear();
        this.animatedVisibilityStates.clear();
        this.transitionStates.clear();
        this.trackedUnsupported.clear();
        this.animatedContentSubscriber.clear();
        this.animateXAsStateSubscriber.clear();
        this.targetBasedAnimationSubscriber.clear();
        this.decayAnimationSubscriber.clear();
        this.animateContentSizeSubscriber.clear();
        this.infiniteTransitionSubscriber.clear();
    }

    private final <T, V extends AnimationVector, S> TransitionInfo createTransitionInfo(Transition.TransitionAnimationState<T, V> $this$createTransitionInfo, long stepMs) {
        long endTimeMs = this.nanosToMillis($this$createTransitionInfo.getAnimation().getDurationNanos());
        Lazy startTimeMs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>($this$createTransitionInfo){
            final /* synthetic */ Transition.TransitionAnimationState<T, V> $this_createTransitionInfo;
            {
                this.$this_createTransitionInfo = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                FiniteAnimationSpec animationSpec = this.$this_createTransitionInfo.getAnimationSpec();
                FiniteAnimationSpec finiteAnimationSpec = animationSpec;
                return ((Number)(finiteAnimationSpec instanceof TweenSpec ? (Number)Integer.valueOf(((TweenSpec)animationSpec).getDelay()) : (Number)(finiteAnimationSpec instanceof SnapSpec ? (Number)Integer.valueOf(((SnapSpec)animationSpec).getDelay()) : (Number)(finiteAnimationSpec instanceof KeyframesSpec ? (Number)Integer.valueOf(((KeyframesSpec)animationSpec).getConfig().getDelayMillis()) : (Number)(finiteAnimationSpec instanceof RepeatableSpec ? (Number)(StartOffsetType.equals-impl0((int)StartOffset.getOffsetType-Eo1U57Q((long)((RepeatableSpec)animationSpec).getInitialStartOffset-Rmkjzm4()), (int)StartOffsetType.Companion.getDelay-Eo1U57Q()) ? (Number)Integer.valueOf(StartOffset.getOffsetMillis-impl((long)((RepeatableSpec)animationSpec).getInitialStartOffset-Rmkjzm4())) : (Number)Long.valueOf(0L)) : (Number)(finiteAnimationSpec instanceof InfiniteRepeatableSpec ? (Number)(StartOffsetType.equals-impl0((int)StartOffset.getOffsetType-Eo1U57Q((long)((InfiniteRepeatableSpec)animationSpec).getInitialStartOffset-Rmkjzm4()), (int)StartOffsetType.Companion.getDelay-Eo1U57Q()) ? (Number)Integer.valueOf(StartOffset.getOffsetMillis-impl((long)((InfiniteRepeatableSpec)animationSpec).getInitialStartOffset-Rmkjzm4())) : (Number)Long.valueOf(0L)) : (Number)(finiteAnimationSpec instanceof VectorizedDurationBasedAnimationSpec ? (Number)Integer.valueOf(((VectorizedDurationBasedAnimationSpec)animationSpec).getDelayMillis()) : (Number)Long.valueOf(0L)))))))).longValue();
            }
        }));
        Lazy values$delegate = LazyKt.lazy((Function0)new Function0<Map<Long, T>>($this$createTransitionInfo, this, endTimeMs, stepMs, (Lazy<Long>)startTimeMs$delegate){
            final /* synthetic */ Transition.TransitionAnimationState<T, V> $this_createTransitionInfo;
            final /* synthetic */ PreviewAnimationClock this$0;
            final /* synthetic */ long $endTimeMs;
            final /* synthetic */ long $stepMs;
            final /* synthetic */ Lazy<Long> $startTimeMs$delegate;
            {
                this.$this_createTransitionInfo = $receiver;
                this.this$0 = $receiver2;
                this.$endTimeMs = $endTimeMs;
                this.$stepMs = $stepMs;
                this.$startTimeMs$delegate = $startTimeMs$delegate;
                super(0);
            }

            @NotNull
            public final Map<Long, T> invoke() {
                Map values2 = new LinkedHashMap<K, V>();
                values2.put(PreviewAnimationClock.access$createTransitionInfo$lambda-21(this.$startTimeMs$delegate), this.$this_createTransitionInfo.getAnimation().getValueFromNanos(PreviewAnimationClock.access$millisToNanos(this.this$0, PreviewAnimationClock.access$createTransitionInfo$lambda-21(this.$startTimeMs$delegate))));
                values2.put(this.$endTimeMs, this.$this_createTransitionInfo.getAnimation().getValueFromNanos(PreviewAnimationClock.access$millisToNanos(this.this$0, this.$endTimeMs)));
                long l = PreviewAnimationClock.access$createTransitionInfo$lambda-21(this.$startTimeMs$delegate);
                if (this.$stepMs <= 0L) {
                    throw new IllegalArgumentException("Step must be positive, was: " + this.$stepMs + '.');
                }
                long millis = l;
                long l2 = ProgressionUtilKt.getProgressionLastElement((long)l, (long)this.$endTimeMs, (long)this.$stepMs);
                if (millis <= l2) {
                    while (true) {
                        Long l3 = millis;
                        values2.put(l3, this.$this_createTransitionInfo.getAnimation().getValueFromNanos(PreviewAnimationClock.access$millisToNanos(this.this$0, millis)));
                        if (millis == l2) break;
                        millis += this.$stepMs;
                    }
                }
                return values2;
            }
        });
        String string = $this$createTransitionInfo.getLabel();
        String string2 = $this$createTransitionInfo.getAnimationSpec().getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.animationSpec.javaClass.name");
        return new TransitionInfo(string, string2, PreviewAnimationClock.createTransitionInfo$lambda-21((Lazy<Long>)startTimeMs$delegate), endTimeMs, PreviewAnimationClock.createTransitionInfo$lambda-22(values$delegate));
    }

    static /* synthetic */ TransitionInfo createTransitionInfo$default(PreviewAnimationClock previewAnimationClock, Transition.TransitionAnimationState transitionAnimationState, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTransitionInfo");
        }
        if ((n & 1) != 0) {
            l = 1L;
        }
        return previewAnimationClock.createTransitionInfo(transitionAnimationState, l);
    }

    private final long nanosToMillis(long timeNs) {
        return (timeNs + (long)999999) / (long)1000000;
    }

    private final long millisToNanos(long timeMs) {
        return timeMs * 1000000L;
    }

    private final Pair<Boolean, Boolean> toCurrentTargetPair-RvB7uIg(String $this$toCurrentTargetPair_u2dRvB7uIg) {
        return AnimatedVisibilityState.equals-impl0($this$toCurrentTargetPair_u2dRvB7uIg, AnimatedVisibilityState.Companion.getEnter-q9NwIk0()) ? TuplesKt.to((Object)false, (Object)true) : TuplesKt.to((Object)true, (Object)false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Transition.TransitionAnimationState<?, ?>> allAnimations(Transition<?> $this$allAnimations) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$allAnimations.getTransitions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Transition it = (Transition)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.allAnimations(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List descendantAnimations = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)$this$allAnimations.getAnimations(), (Iterable)descendantAnimations);
    }

    private static final long createTransitionInfo$lambda-21(Lazy<Long> $startTimeMs$delegate) {
        Lazy<Long> lazy = $startTimeMs$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private static final <T> Map<Long, T> createTransitionInfo$lambda-22(Lazy<? extends Map<Long, T>> $values$delegate) {
        Lazy<? extends Map<Long, T>> lazy = $values$delegate;
        return (Map)lazy.getValue();
    }

    public PreviewAnimationClock() {
        this(null, 1, null);
    }

    public static final /* synthetic */ long access$createTransitionInfo$lambda-21(Lazy $startTimeMs$delegate) {
        return PreviewAnimationClock.createTransitionInfo$lambda-21((Lazy<Long>)$startTimeMs$delegate);
    }

    public static final /* synthetic */ long access$millisToNanos(PreviewAnimationClock $this, long timeMs) {
        return $this.millisToNanos(timeMs);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u001b\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$UnsupportedComposeAnimationSubscriber;", "T", "", "(Landroidx/compose/ui/tooling/animation/PreviewAnimationClock;)V", "animations", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "lock", "clear", "", "trackAnimation", "animation", "label", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "ui-tooling_release"})
    private final class UnsupportedComposeAnimationSubscriber<T> {
        @NotNull
        private final LinkedHashSet<T> animations = new LinkedHashSet();
        @NotNull
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void trackAnimation(T animation, @NotNull String label) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                if (!UnsupportedComposeAnimation.Companion.getApiAvailable()) {
                    return;
                }
                Object object = this.lock;
                Object object2 = PreviewAnimationClock.this;
                Object object3 = object;
                synchronized (object3) {
                    boolean bl = false;
                    if (this.animations.contains(animation)) {
                        if (((PreviewAnimationClock)object2).DEBUG) {
                            Log.d((String)((PreviewAnimationClock)object2).TAG, (String)("Animation " + animation + " is already being tracked"));
                        }
                        return;
                    }
                    bl = this.animations.add(animation);
                }
                if (PreviewAnimationClock.this.DEBUG) {
                    Log.d((String)PreviewAnimationClock.this.TAG, (String)("Animation " + animation + " is now tracked"));
                }
                UnsupportedComposeAnimation unsupportedComposeAnimation = UnsupportedComposeAnimation.Companion.create(label);
                if (unsupportedComposeAnimation == null) break block7;
                object2 = unsupportedComposeAnimation;
                object3 = PreviewAnimationClock.this;
                Object it = object2;
                boolean bl = false;
                ((PreviewAnimationClock)object3).getTrackedUnsupported$ui_tooling_release().add((UnsupportedComposeAnimation)it);
                ((PreviewAnimationClock)object3).notifySubscribe((ComposeAnimation)it);
            }
        }

        public final void clear() {
            this.animations.clear();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$TransitionState;", "", "current", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getCurrent", "()Ljava/lang/Object;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-tooling_release"})
    @VisibleForTesting
    public static final class TransitionState {
        @NotNull
        private final Object current;
        @NotNull
        private final Object target;

        public TransitionState(@NotNull Object current, @NotNull Object target) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.current = current;
            this.target = target;
        }

        @NotNull
        public final Object getCurrent() {
            return this.current;
        }

        @NotNull
        public final Object getTarget() {
            return this.target;
        }

        @NotNull
        public final Object component1() {
            return this.current;
        }

        @NotNull
        public final Object component2() {
            return this.target;
        }

        @NotNull
        public final TransitionState copy(@NotNull Object current, @NotNull Object target) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new TransitionState(current, target);
        }

        public static /* synthetic */ TransitionState copy$default(TransitionState transitionState, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = transitionState.current;
            }
            if ((n & 2) != 0) {
                object2 = transitionState.target;
            }
            return transitionState.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "TransitionState(current=" + this.current + ", target=" + this.target + ')';
        }

        public int hashCode() {
            int result = this.current.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransitionState)) {
                return false;
            }
            TransitionState transitionState = (TransitionState)other;
            if (!Intrinsics.areEqual((Object)this.current, (Object)transitionState.current)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)transitionState.target);
        }
    }
}

