/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation.clock;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.TransitionInfo;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.tooling.animation.AnimateXAsStateComposeAnimation;
import androidx.compose.ui.tooling.animation.clock.ComposeAnimationClock;
import androidx.compose.ui.tooling.animation.clock.UtilsKt;
import androidx.compose.ui.tooling.animation.states.TargetState;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0004B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0002J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\fH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\fH\u0016J\u001a\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010)H\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000@BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\"\u0004\b\u0013\u0010\u0014R0\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Landroidx/compose/ui/tooling/animation/clock/AnimateXAsStateClock;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/ui/tooling/animation/clock/ComposeAnimationClock;", "Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;", "Landroidx/compose/ui/tooling/animation/states/TargetState;", "animation", "(Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;)V", "getAnimation", "()Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;", "value", "", "clockTimeNanos", "setClockTimeNanos", "(J)V", "currAnimation", "Landroidx/compose/animation/core/TargetBasedAnimation;", "currentValue", "setCurrentValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "state", "getState", "()Landroidx/compose/ui/tooling/animation/states/TargetState;", "setState", "(Landroidx/compose/ui/tooling/animation/states/TargetState;)V", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "getCurrentAnimation", "getMaxDuration", "getMaxDurationPerIteration", "getTransitions", "Landroidx/compose/animation/tooling/TransitionInfo;", "stepMillis", "setClockTime", "", "animationTimeNanos", "setStateParameters", "par1", "", "par2", "ui-tooling_release"})
public final class AnimateXAsStateClock<T, V extends AnimationVector>
implements ComposeAnimationClock<AnimateXAsStateComposeAnimation<T, V>, TargetState<T>> {
    @NotNull
    private final AnimateXAsStateComposeAnimation<T, V> animation;
    @NotNull
    private TargetState<T> state;
    private T currentValue;
    @NotNull
    private TargetBasedAnimation<T, V> currAnimation;
    private long clockTimeNanos;

    public AnimateXAsStateClock(@NotNull AnimateXAsStateComposeAnimation<T, V> animation) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        this.animation = animation;
        this.state = new TargetState<Object>(this.getAnimation().getAnimationObject().getValue(), this.getAnimation().getAnimationObject().getValue());
        this.currentValue = this.getAnimation().getToolingState().getValue();
        this.currAnimation = this.getCurrentAnimation();
    }

    @Override
    @NotNull
    public AnimateXAsStateComposeAnimation<T, V> getAnimation() {
        return this.animation;
    }

    @Override
    @NotNull
    public TargetState<T> getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull TargetState<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.state = value;
        this.currAnimation = this.getCurrentAnimation();
        this.setClockTime(0L);
    }

    private final void setCurrentValue(T value) {
        this.currentValue = value;
        this.getAnimation().getToolingState().setValue(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setStateParameters(@NotNull Object par1, @Nullable Object par2) {
        Intrinsics.checkNotNullParameter((Object)par1, (String)"par1");
        if (!AnimateXAsStateClock.setStateParameters$parametersAreValid(this, par1, par2)) {
            return;
        }
        T t = this.currentValue;
        Intrinsics.checkNotNull(t);
        Object object = par2;
        Intrinsics.checkNotNull((Object)object);
        if (AnimateXAsStateClock.setStateParameters$parametersHasTheSameType(t, par1, object)) {
            this.setState(new TargetState<Object>(par1, par2));
            return;
        }
        if (!(par1 instanceof List) || !(par2 instanceof List)) return;
        try {
            TargetState targetState;
            T t2 = this.currentValue;
            if (t2 instanceof IntSize) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)e;
                Object e2 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Int");
                IntSize intSize = IntSize.box-impl((long)IntSizeKt.IntSize((int)n, (int)((Integer)e2)));
                Object e3 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type kotlin.Int");
                int n2 = (Integer)e3;
                Object e4 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type kotlin.Int");
                targetState = new TargetState(intSize, IntSize.box-impl((long)IntSizeKt.IntSize((int)n2, (int)((Integer)e4))));
            } else if (t2 instanceof IntOffset) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)e;
                Object e5 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type kotlin.Int");
                IntOffset intOffset = IntOffset.box-impl((long)IntOffsetKt.IntOffset((int)n, (int)((Integer)e5)));
                Object e6 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e6, (String)"null cannot be cast to non-null type kotlin.Int");
                int n3 = (Integer)e6;
                Object e7 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e7, (String)"null cannot be cast to non-null type kotlin.Int");
                targetState = new TargetState<IntOffset>(intOffset, IntOffset.box-impl((long)IntOffsetKt.IntOffset((int)n3, (int)((Integer)e7))));
            } else if (t2 instanceof Size) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)e).floatValue();
                Object e8 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e8, (String)"null cannot be cast to non-null type kotlin.Float");
                Size size = Size.box-impl((long)SizeKt.Size((float)f, (float)((Float)e8).floatValue()));
                Object e9 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e9, (String)"null cannot be cast to non-null type kotlin.Float");
                float f2 = ((Float)e9).floatValue();
                Object e10 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e10, (String)"null cannot be cast to non-null type kotlin.Float");
                targetState = new TargetState<Size>(size, Size.box-impl((long)SizeKt.Size((float)f2, (float)((Float)e10).floatValue())));
            } else if (t2 instanceof Offset) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)e).floatValue();
                Object e11 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e11, (String)"null cannot be cast to non-null type kotlin.Float");
                Offset offset = Offset.box-impl((long)OffsetKt.Offset((float)f, (float)((Float)e11).floatValue()));
                Object e12 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e12, (String)"null cannot be cast to non-null type kotlin.Float");
                float f3 = ((Float)e12).floatValue();
                Object e13 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e13, (String)"null cannot be cast to non-null type kotlin.Float");
                targetState = new TargetState<Offset>(offset, Offset.box-impl((long)OffsetKt.Offset((float)f3, (float)((Float)e13).floatValue())));
            } else if (t2 instanceof Rect) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)e).floatValue();
                Object e14 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e14, (String)"null cannot be cast to non-null type kotlin.Float");
                float f4 = ((Float)e14).floatValue();
                Object e15 = ((List)par1).get(2);
                Intrinsics.checkNotNull(e15, (String)"null cannot be cast to non-null type kotlin.Float");
                float f5 = ((Float)e15).floatValue();
                Object e16 = ((List)par1).get(3);
                Intrinsics.checkNotNull(e16, (String)"null cannot be cast to non-null type kotlin.Float");
                Rect rect = new Rect(f, f4, f5, ((Float)e16).floatValue());
                Object e17 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e17, (String)"null cannot be cast to non-null type kotlin.Float");
                float f6 = ((Float)e17).floatValue();
                Object e18 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e18, (String)"null cannot be cast to non-null type kotlin.Float");
                float f7 = ((Float)e18).floatValue();
                Object e19 = ((List)par2).get(2);
                Intrinsics.checkNotNull(e19, (String)"null cannot be cast to non-null type kotlin.Float");
                float f8 = ((Float)e19).floatValue();
                Object e20 = ((List)par2).get(3);
                Intrinsics.checkNotNull(e20, (String)"null cannot be cast to non-null type kotlin.Float");
                targetState = new TargetState<Rect>(rect, new Rect(f6, f7, f8, ((Float)e20).floatValue()));
            } else if (t2 instanceof Color) {
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)e).floatValue();
                Object e21 = ((List)par1).get(1);
                Intrinsics.checkNotNull(e21, (String)"null cannot be cast to non-null type kotlin.Float");
                float f9 = ((Float)e21).floatValue();
                Object e22 = ((List)par1).get(2);
                Intrinsics.checkNotNull(e22, (String)"null cannot be cast to non-null type kotlin.Float");
                float f10 = ((Float)e22).floatValue();
                Object e23 = ((List)par1).get(3);
                Intrinsics.checkNotNull(e23, (String)"null cannot be cast to non-null type kotlin.Float");
                Color color = Color.box-impl((long)ColorKt.Color$default((float)f, (float)f9, (float)f10, (float)((Float)e23).floatValue(), null, (int)16, null));
                Object e24 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e24, (String)"null cannot be cast to non-null type kotlin.Float");
                float f11 = ((Float)e24).floatValue();
                Object e25 = ((List)par2).get(1);
                Intrinsics.checkNotNull(e25, (String)"null cannot be cast to non-null type kotlin.Float");
                float f12 = ((Float)e25).floatValue();
                Object e26 = ((List)par2).get(2);
                Intrinsics.checkNotNull(e26, (String)"null cannot be cast to non-null type kotlin.Float");
                float f13 = ((Float)e26).floatValue();
                Object e27 = ((List)par2).get(3);
                Intrinsics.checkNotNull(e27, (String)"null cannot be cast to non-null type kotlin.Float");
                targetState = new TargetState<Color>(color, Color.box-impl((long)ColorKt.Color$default((float)f11, (float)f12, (float)f13, (float)((Float)e27).floatValue(), null, (int)16, null)));
            } else if (t2 instanceof Dp) {
                T t3 = this.currentValue;
                Intrinsics.checkNotNull(t3);
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e);
                Object e28 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e28);
                if (AnimateXAsStateClock.setStateParameters$parametersHasTheSameType(t3, e, e28)) {
                    targetState = new TargetState(((List)par1).get(0), ((List)par2).get(0));
                } else {
                    Object e29 = ((List)par1).get(0);
                    Intrinsics.checkNotNull(e29, (String)"null cannot be cast to non-null type kotlin.Float");
                    float $this$dp$iv = ((Float)e29).floatValue();
                    boolean $i$f$getDp = false;
                    Dp dp = Dp.box-impl((float)Dp.constructor-impl((float)$this$dp$iv));
                    Object e30 = ((List)par2).get(0);
                    Intrinsics.checkNotNull(e30, (String)"null cannot be cast to non-null type kotlin.Float");
                    $this$dp$iv = ((Float)e30).floatValue();
                    $i$f$getDp = false;
                    TargetState<Dp> targetState2 = new TargetState<Dp>(dp, Dp.box-impl((float)Dp.constructor-impl((float)$this$dp$iv)));
                    targetState = targetState2;
                }
            } else {
                if (!AnimateXAsStateClock.setStateParameters$parametersAreValid(this, ((List)par1).get(0), ((List)par2).get(0))) return;
                T t4 = this.currentValue;
                Intrinsics.checkNotNull(t4);
                Object e = ((List)par1).get(0);
                Intrinsics.checkNotNull(e);
                Object e31 = ((List)par2).get(0);
                Intrinsics.checkNotNull(e31);
                if (!AnimateXAsStateClock.setStateParameters$parametersHasTheSameType(t4, e, e31)) return;
                targetState = new TargetState(((List)par1).get(0), ((List)par2).get(0));
            }
            this.setState(targetState);
            return;
        }
        catch (IndexOutOfBoundsException _) {
            return;
        }
        catch (ClassCastException _) {
            return;
        }
        catch (IllegalArgumentException _) {
            return;
        }
        catch (NullPointerException _) {
            return;
        }
    }

    @Override
    @NotNull
    public List<ComposeAnimatedProperty> getAnimatedProperties() {
        String string = this.getAnimation().getLabel();
        T t = this.currentValue;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
        return CollectionsKt.listOf((Object)new ComposeAnimatedProperty(string, t));
    }

    @Override
    public long getMaxDurationPerIteration() {
        return UtilsKt.nanosToMillis(this.currAnimation.getDurationNanos());
    }

    @Override
    public long getMaxDuration() {
        return UtilsKt.nanosToMillis(this.currAnimation.getDurationNanos());
    }

    @Override
    @NotNull
    public List<TransitionInfo> getTransitions(long stepMillis) {
        return CollectionsKt.listOf((Object)UtilsKt.createTransitionInfo((Animation)this.currAnimation, this.getAnimation().getLabel(), this.getAnimation().getAnimationSpec(), stepMillis));
    }

    private final void setClockTimeNanos(long value) {
        this.clockTimeNanos = value;
        this.setCurrentValue(this.currAnimation.getValueFromNanos(value));
    }

    @Override
    public void setClockTime(long animationTimeNanos) {
        this.setClockTimeNanos(animationTimeNanos);
    }

    private final TargetBasedAnimation<T, V> getCurrentAnimation() {
        AnimationSpec animationSpec = this.getAnimation().getAnimationSpec();
        Object t = ((TargetState)this.getState()).getInitial();
        Object t2 = ((TargetState)this.getState()).getTarget();
        TwoWayConverter twoWayConverter = this.getAnimation().getAnimationObject().getTypeConverter();
        Object object = this.getAnimation().getAnimationObject().getVelocity();
        return AnimationKt.TargetBasedAnimation(animationSpec, (TwoWayConverter)twoWayConverter, t, t2, (Object)object);
    }

    private static final <T, V extends AnimationVector> boolean setStateParameters$parametersAreValid(AnimateXAsStateClock<T, V> this$0, Object par1, Object par2) {
        return this$0.currentValue != null && par1 != null && par2 != null && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(par1.getClass()), (Object)Reflection.getOrCreateKotlinClass(par2.getClass()));
    }

    private static final boolean setStateParameters$parametersHasTheSameType(Object value, Object par1, Object par2) {
        return Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(value.getClass()), (Object)Reflection.getOrCreateKotlinClass(par1.getClass())) && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(value.getClass()), (Object)Reflection.getOrCreateKotlinClass(par2.getClass()));
    }
}

