/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation.clock;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.InfiniteRepeatableSpec;
import androidx.compose.animation.core.KeyframesSpec;
import androidx.compose.animation.core.RepeatableSpec;
import androidx.compose.animation.core.SnapSpec;
import androidx.compose.animation.core.StartOffset;
import androidx.compose.animation.core.StartOffsetType;
import androidx.compose.animation.core.Transition;
import androidx.compose.animation.core.TweenSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.tooling.TransitionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a&\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007R\u0006\u0012\u0002\b\u00030\b0\u0006*\u0006\u0012\u0002\b\u00030\bH\u0000\u001aH\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\r*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0000\u001aB\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\r\"\u0004\b\u0002\u0010\u0014*\u0018\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u0007R\b\u0012\u0004\u0012\u0002H\u00140\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0000\u00a8\u0006\u0015"}, d2={"millisToNanos", "", "timeMs", "nanosToMillis", "timeNs", "allAnimations", "", "Landroidx/compose/animation/core/Transition$TransitionAnimationState;", "Landroidx/compose/animation/core/Transition;", "createTransitionInfo", "Landroidx/compose/animation/tooling/TransitionInfo;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/Animation;", "label", "", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "stepMs", "S", "ui-tooling_release"})
public final class UtilsKt {
    public static final long nanosToMillis(long timeNs) {
        return (timeNs + (long)999999) / (long)1000000;
    }

    public static final long millisToNanos(long timeMs) {
        return timeMs * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Transition.TransitionAnimationState<?, ?>> allAnimations(@NotNull Transition<?> $this$allAnimations) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$allAnimations, (String)"<this>");
        Iterable $this$flatMap$iv = $this$allAnimations.getTransitions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Transition it = (Transition)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = UtilsKt.allAnimations(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List descendantAnimations = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)$this$allAnimations.getAnimations(), (Iterable)descendantAnimations);
    }

    @NotNull
    public static final <T, V extends AnimationVector, S> TransitionInfo createTransitionInfo(@NotNull Transition.TransitionAnimationState<T, V> $this$createTransitionInfo, long stepMs) {
        Intrinsics.checkNotNullParameter($this$createTransitionInfo, (String)"<this>");
        return UtilsKt.createTransitionInfo((Animation)$this$createTransitionInfo.getAnimation(), $this$createTransitionInfo.getLabel(), (AnimationSpec)$this$createTransitionInfo.getAnimationSpec(), stepMs);
    }

    public static /* synthetic */ TransitionInfo createTransitionInfo$default(Transition.TransitionAnimationState transitionAnimationState, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        return UtilsKt.createTransitionInfo(transitionAnimationState, l);
    }

    @NotNull
    public static final <T, V extends AnimationVector> TransitionInfo createTransitionInfo(@NotNull Animation<T, V> $this$createTransitionInfo, @NotNull String label, @NotNull AnimationSpec<T> animationSpec, long stepMs) {
        Intrinsics.checkNotNullParameter($this$createTransitionInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        long endTimeMs = UtilsKt.nanosToMillis($this$createTransitionInfo.getDurationNanos());
        Lazy startTimeMs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(animationSpec){
            final /* synthetic */ AnimationSpec<T> $animationSpec;
            {
                this.$animationSpec = $animationSpec;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                AnimationSpec<T> animationSpec = this.$animationSpec;
                return ((Number)(animationSpec instanceof TweenSpec ? (Number)Integer.valueOf(((TweenSpec)this.$animationSpec).getDelay()) : (Number)(animationSpec instanceof SnapSpec ? (Number)Integer.valueOf(((SnapSpec)this.$animationSpec).getDelay()) : (Number)(animationSpec instanceof KeyframesSpec ? (Number)Integer.valueOf(((KeyframesSpec)this.$animationSpec).getConfig().getDelayMillis()) : (Number)(animationSpec instanceof RepeatableSpec ? (Number)(StartOffsetType.equals-impl0((int)StartOffset.getOffsetType-Eo1U57Q((long)((RepeatableSpec)this.$animationSpec).getInitialStartOffset-Rmkjzm4()), (int)StartOffsetType.Companion.getDelay-Eo1U57Q()) ? (Number)Integer.valueOf(StartOffset.getOffsetMillis-impl((long)((RepeatableSpec)this.$animationSpec).getInitialStartOffset-Rmkjzm4())) : (Number)Long.valueOf(0L)) : (Number)(animationSpec instanceof InfiniteRepeatableSpec ? (Number)(StartOffsetType.equals-impl0((int)StartOffset.getOffsetType-Eo1U57Q((long)((InfiniteRepeatableSpec)this.$animationSpec).getInitialStartOffset-Rmkjzm4()), (int)StartOffsetType.Companion.getDelay-Eo1U57Q()) ? (Number)Integer.valueOf(StartOffset.getOffsetMillis-impl((long)((InfiniteRepeatableSpec)this.$animationSpec).getInitialStartOffset-Rmkjzm4())) : (Number)Long.valueOf(0L)) : (Number)(animationSpec instanceof VectorizedDurationBasedAnimationSpec ? (Number)Integer.valueOf(((VectorizedDurationBasedAnimationSpec)this.$animationSpec).getDelayMillis()) : (Number)Long.valueOf(0L)))))))).longValue();
            }
        }));
        Lazy values$delegate = LazyKt.lazy((Function0)new Function0<Map<Long, T>>($this$createTransitionInfo, endTimeMs, stepMs, (Lazy<Long>)startTimeMs$delegate){
            final /* synthetic */ Animation<T, V> $this_createTransitionInfo;
            final /* synthetic */ long $endTimeMs;
            final /* synthetic */ long $stepMs;
            final /* synthetic */ Lazy<Long> $startTimeMs$delegate;
            {
                this.$this_createTransitionInfo = $receiver;
                this.$endTimeMs = $endTimeMs;
                this.$stepMs = $stepMs;
                this.$startTimeMs$delegate = $startTimeMs$delegate;
                super(0);
            }

            @NotNull
            public final Map<Long, T> invoke() {
                Map values2 = new LinkedHashMap<K, V>();
                values2.put(UtilsKt.access$createTransitionInfo$lambda$1(this.$startTimeMs$delegate), this.$this_createTransitionInfo.getValueFromNanos(UtilsKt.millisToNanos(UtilsKt.access$createTransitionInfo$lambda$1(this.$startTimeMs$delegate))));
                values2.put(this.$endTimeMs, this.$this_createTransitionInfo.getValueFromNanos(UtilsKt.millisToNanos(this.$endTimeMs)));
                long l = UtilsKt.access$createTransitionInfo$lambda$1(this.$startTimeMs$delegate);
                if (this.$stepMs <= 0L) {
                    throw new IllegalArgumentException("Step must be positive, was: " + this.$stepMs + '.');
                }
                long millis = l;
                long l2 = ProgressionUtilKt.getProgressionLastElement((long)l, (long)this.$endTimeMs, (long)this.$stepMs);
                if (millis <= l2) {
                    while (true) {
                        Long l3 = millis;
                        values2.put(l3, this.$this_createTransitionInfo.getValueFromNanos(UtilsKt.millisToNanos(millis)));
                        if (millis == l2) break;
                        millis += this.$stepMs;
                    }
                }
                return values2;
            }
        });
        String string = animationSpec.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"animationSpec.javaClass.name");
        return new TransitionInfo(label, string, UtilsKt.createTransitionInfo$lambda$1((Lazy<Long>)startTimeMs$delegate), endTimeMs, UtilsKt.createTransitionInfo$lambda$2(values$delegate));
    }

    public static /* synthetic */ TransitionInfo createTransitionInfo$default(Animation animation, String string, AnimationSpec animationSpec, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 1L;
        }
        return UtilsKt.createTransitionInfo(animation, string, animationSpec, l);
    }

    private static final long createTransitionInfo$lambda$1(Lazy<Long> $startTimeMs$delegate) {
        Lazy<Long> lazy = $startTimeMs$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private static final <T> Map<Long, T> createTransitionInfo$lambda$2(Lazy<? extends Map<Long, T>> $values$delegate) {
        Lazy<? extends Map<Long, T>> lazy = $values$delegate;
        return (Map)lazy.getValue();
    }

    public static final /* synthetic */ long access$createTransitionInfo$lambda$1(Lazy $startTimeMs$delegate) {
        return UtilsKt.createTransitionInfo$lambda$1((Lazy<Long>)$startTimeMs$delegate);
    }
}

