/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.unit.fontscaling;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/unit/fontscaling/MathUtils;", "", "()V", "constrainedMap", "", "rangeMin", "rangeMax", "valueMin", "valueMax", "value", "lerp", "start", "stop", "amount", "lerpInv", "a", "b", "ui-unit_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@StabilityInferred(parameters=0)
public final class MathUtils {
    @NotNull
    public static final MathUtils INSTANCE = new MathUtils();
    public static final int $stable;

    private MathUtils() {
    }

    public final float lerp(float start, float stop, float amount) {
        return start + (stop - start) * amount;
    }

    public final float lerpInv(float a, float b, float value) {
        return !(a == b) ? (value - a) / (b - a) : 0.0f;
    }

    public final float constrainedMap(float rangeMin, float rangeMax, float valueMin, float valueMax, float value) {
        return this.lerp(rangeMin, rangeMax, Math.max(0.0f, Math.min(1.0f, this.lerpInv(valueMin, valueMax, value))));
    }
}

