/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.unit.fontscaling;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.fontscaling.FontScaleConverter;
import androidx.compose.ui.unit.fontscaling.MathUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\b\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001c"}, d2={"Landroidx/compose/ui/unit/fontscaling/FontScaleConverterTable;", "Landroidx/compose/ui/unit/fontscaling/FontScaleConverter;", "fromSp", "", "toDp", "([F[F)V", "mFromSpValues", "getMFromSpValues$annotations", "()V", "getMFromSpValues", "()[F", "mToDpValues", "getMToDpValues$annotations", "getMToDpValues", "convertDpToSp", "", "dp", "convertSpToDp", "sp", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "ui-unit_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class FontScaleConverterTable
implements FontScaleConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] mFromSpValues;
    @NotNull
    private final float[] mToDpValues;
    public static final int $stable = 8;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FontScaleConverterTable(@NotNull float[] fromSp, @NotNull float[] toDp) {
        if (!(fromSp.length == toDp.length && !(fromSp.length == 0))) {
            boolean bl = false;
            String string = "Array lengths must match and be nonzero";
            throw new IllegalArgumentException(string.toString());
        }
        this.mFromSpValues = fromSp;
        this.mToDpValues = toDp;
    }

    @NotNull
    public final float[] getMFromSpValues() {
        return this.mFromSpValues;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMFromSpValues$annotations() {
    }

    @NotNull
    public final float[] getMToDpValues() {
        return this.mToDpValues;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMToDpValues$annotations() {
    }

    @Override
    public float convertDpToSp(float dp) {
        return FontScaleConverterTable.Companion.lookupAndInterpolate(dp, this.mToDpValues, this.mFromSpValues);
    }

    @Override
    public float convertSpToDp(float sp) {
        return FontScaleConverterTable.Companion.lookupAndInterpolate(sp, this.mFromSpValues, this.mToDpValues);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof FontScaleConverterTable)) {
            return false;
        }
        return Arrays.equals(this.mFromSpValues, ((FontScaleConverterTable)other).mFromSpValues) && Arrays.equals(this.mToDpValues, ((FontScaleConverterTable)other).mToDpValues);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mFromSpValues);
        result = 31 * result + Arrays.hashCode(this.mToDpValues);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("FontScaleConverter{fromSpValues=");
        String string = Arrays.toString(this.mFromSpValues);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(", toDpValues=");
        String string2 = Arrays.toString(this.mToDpValues);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append('}').toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/unit/fontscaling/FontScaleConverterTable$Companion;", "", "()V", "lookupAndInterpolate", "", "sourceValue", "sourceValues", "", "targetValues", "ui-unit_release"})
    public static final class Companion {
        private Companion() {
        }

        private final float lookupAndInterpolate(float sourceValue, float[] sourceValues, float[] targetValues) {
            float f;
            float sourceValuePositive = Math.abs(sourceValue);
            float sign = Math.signum(sourceValue);
            int index = Arrays.binarySearch(sourceValues, sourceValuePositive);
            if (index >= 0) {
                f = sign * targetValues[index];
            } else {
                int lowerIndex = -(index + 1) - 1;
                float startSp = 0.0f;
                float endSp = 0.0f;
                float startDp = 0.0f;
                float endDp = 0.0f;
                if (lowerIndex >= sourceValues.length - 1) {
                    startSp = sourceValues[sourceValues.length - 1];
                    startDp = targetValues[sourceValues.length - 1];
                    if (startSp == 0.0f) {
                        return 0.0f;
                    }
                    float scalingFactor = startDp / startSp;
                    return sourceValue * scalingFactor;
                }
                if (lowerIndex == -1) {
                    startSp = 0.0f;
                    startDp = 0.0f;
                    endSp = sourceValues[0];
                    endDp = targetValues[0];
                } else {
                    startSp = sourceValues[lowerIndex];
                    endSp = sourceValues[lowerIndex + 1];
                    startDp = targetValues[lowerIndex];
                    endDp = targetValues[lowerIndex + 1];
                }
                f = sign * MathUtils.INSTANCE.constrainedMap(startDp, endDp, startSp, endSp, sourceValuePositive);
            }
            return f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

