/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import android.util.Log;
import androidx.constraintlayout.compose.ExperimentalMotionApi;
import androidx.constraintlayout.compose.Transition;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.TransitionParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/compose/TransitionImpl;", "Landroidx/constraintlayout/compose/Transition;", "parsedTransition", "Landroidx/constraintlayout/core/parser/CLObject;", "pixelDp", "Landroidx/constraintlayout/core/state/CorePixelDp;", "(Landroidx/constraintlayout/core/parser/CLObject;Landroidx/constraintlayout/core/state/CorePixelDp;)V", "applyAllTo", "", "transition", "Landroidx/constraintlayout/core/state/Transition;", "applyKeyFramesTo", "getEndConstraintSetId", "", "getStartConstraintSetId", "constraintlayout-compose_release"})
@ExperimentalMotionApi
public final class TransitionImpl
implements Transition {
    @NotNull
    private final CLObject parsedTransition;
    @NotNull
    private final CorePixelDp pixelDp;

    public TransitionImpl(@NotNull CLObject parsedTransition, @NotNull CorePixelDp pixelDp2) {
        Intrinsics.checkNotNullParameter((Object)parsedTransition, (String)"parsedTransition");
        Intrinsics.checkNotNullParameter((Object)pixelDp2, (String)"pixelDp");
        this.parsedTransition = parsedTransition;
        this.pixelDp = pixelDp2;
    }

    public final void applyAllTo(@NotNull androidx.constraintlayout.core.state.Transition transition2) {
        Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
        try {
            TransitionParser.parse((CLObject)this.parsedTransition, (androidx.constraintlayout.core.state.Transition)transition2, (CorePixelDp)this.pixelDp);
        }
        catch (CLParsingException e) {
            Log.e((String)"CML", (String)("Error parsing JSON " + (Object)((Object)e)));
        }
    }

    public final void applyKeyFramesTo(@NotNull androidx.constraintlayout.core.state.Transition transition2) {
        Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
        try {
            TransitionParser.parseKeyFrames((CLObject)this.parsedTransition, (androidx.constraintlayout.core.state.Transition)transition2);
        }
        catch (CLParsingException e) {
            Log.e((String)"CML", (String)("Error parsing JSON " + (Object)((Object)e)));
        }
    }

    @Override
    @NotNull
    public String getStartConstraintSetId() {
        String string = this.parsedTransition.getStringOrNull("from");
        if (string == null) {
            string = "start";
        }
        return string;
    }

    @Override
    @NotNull
    public String getEndConstraintSetId() {
        String string = this.parsedTransition.getStringOrNull("to");
        if (string == null) {
            string = "end";
        }
        return string;
    }
}

