/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/constraintlayout/compose/lint/ConstraintLayoutDslDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "knownOwnersOfCreateRefsFor", "", "", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "constraintlayout-compose-lint"})
public final class ConstraintLayoutDslDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> knownOwnersOfCreateRefsFor;
    @NotNull
    private static final Issue IncorrectReferencesDeclarationIssue = Issue.Companion.create("IncorrectReferencesDeclaration", "`createRefsFor(vararg ids: Any)` should have at least one argument and match assigned variables", "`createRefsFor(vararg ids: Any)` conveniently allows creating multiple references using destructuring. However, providing an un-equal amount of arguments to the assigned variables will result in unexpected behavior since the variables may reference a ConstrainedLayoutReference with unknown ID.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(ConstraintLayoutDslDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));

    public ConstraintLayoutDslDetector() {
        Object[] objectArray = new String[]{"androidx.constraintlayout.compose.ConstraintSetScope", "androidx.constraintlayout.compose.MotionSceneScope"};
        this.knownOwnersOfCreateRefsFor = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ ConstraintLayoutDslDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                int varsReceived;
                PsiElement psiElement;
                block9: {
                    block8: {
                        void $this$getParentOfType$iv;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!Intrinsics.areEqual((Object)node.getMethodName(), (Object)"createRefsFor")) {
                            return;
                        }
                        psiElement = node.getSourcePsi();
                        if (psiElement == null) break block8;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = true;
                        boolean $i$f$getParentOfType = false;
                        psiElement = (KtDestructuringDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDestructuringDeclaration.class, (boolean)strict$iv);
                        if (psiElement != null) break block9;
                    }
                    return;
                }
                PsiElement destructuringDeclarationElement = psiElement;
                int argsGiven = node.getValueArgumentCount();
                if (argsGiven == (varsReceived = destructuringDeclarationElement.getEntries().size())) {
                    return;
                }
                Iterable $this$forEach$iv = node.getValueArguments();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UExpression argExpression = (UExpression)element$iv;
                    boolean bl = false;
                    PsiType psiType = argExpression.getExpressionType();
                    if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)String.class.getName())) continue;
                    return;
                }
                Object object = node.resolve();
                if (object == null || (object = object.getContainingClass()) == null || (object = object.getQualifiedName()) == null) {
                    return;
                }
                Object classOwnerFqName = object;
                if (!ConstraintLayoutDslDetector.access$getKnownOwnersOfCreateRefsFor$p(this.this$0).contains(classOwnerFqName)) {
                    return;
                }
                JavaContext.report$default((JavaContext)this.$context, (Issue)ConstraintLayoutDslDetector.Companion.getIncorrectReferencesDeclarationIssue(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)("Arguments of `createRefsFor` (" + argsGiven + ") do not match assigned variables (" + varsReceived + ")"), null, (int)16, null);
            }
        };
    }

    public static final /* synthetic */ Set access$getKnownOwnersOfCreateRefsFor$p(ConstraintLayoutDslDetector $this) {
        return $this.knownOwnersOfCreateRefsFor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/compose/lint/ConstraintLayoutDslDetector$Companion;", "", "()V", "IncorrectReferencesDeclarationIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getIncorrectReferencesDeclarationIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "constraintlayout-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getIncorrectReferencesDeclarationIssue() {
            return IncorrectReferencesDeclarationIssue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

