/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import androidx.compose.runtime.MutableState;
import androidx.constraintlayout.compose.LayoutInfoFlags;
import androidx.constraintlayout.compose.LayoutInformationReceiver;
import androidx.constraintlayout.compose.MotionLayoutDebugFlags;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.Registry;
import androidx.constraintlayout.core.state.RegistryCallback;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0011\b!\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0003J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\nH\u0004J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\nH\u0004J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0016\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010\u0003J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0016\u0010)\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016J\b\u0010+\u001a\u00020\u001bH\u0004R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/constraintlayout/compose/EditableJSONLayout;", "Landroidx/constraintlayout/compose/LayoutInformationReceiver;", "content", "", "(Ljava/lang/String;)V", "currentContent", "debugName", "forcedDrawDebug", "Landroidx/constraintlayout/compose/MotionLayoutDebugFlags;", "forcedHeight", "", "forcedWidth", "last", "", "layoutInformation", "layoutInformationMode", "Landroidx/constraintlayout/compose/LayoutInfoFlags;", "updateFlag", "Landroidx/compose/runtime/MutableState;", "getCurrentContent", "getDebugName", "getForcedDrawDebug", "getForcedHeight", "getForcedWidth", "getLayoutInformation", "getLayoutInformationMode", "initialization", "", "onDrawDebug", "debugMode", "onLayoutInformation", "mode", "onNewContent", "onNewDimensions", "width", "height", "setCurrentContent", "setDebugName", "name", "setLayoutInformation", "information", "setUpdateFlag", "needsUpdate", "signalUpdate", "constraintlayout-compose_release"})
@PublishedApi
public abstract class EditableJSONLayout
implements LayoutInformationReceiver {
    private int forcedWidth;
    private int forcedHeight;
    @NotNull
    private MotionLayoutDebugFlags forcedDrawDebug;
    @Nullable
    private MutableState<Long> updateFlag;
    @NotNull
    private LayoutInfoFlags layoutInformationMode;
    @NotNull
    private String layoutInformation;
    private long last;
    @Nullable
    private String debugName;
    @NotNull
    private String currentContent;

    public EditableJSONLayout(@Language(value="json5") @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.forcedWidth = Integer.MIN_VALUE;
        this.forcedHeight = Integer.MIN_VALUE;
        this.forcedDrawDebug = MotionLayoutDebugFlags.UNKNOWN;
        this.layoutInformationMode = LayoutInfoFlags.NONE;
        this.layoutInformation = "";
        this.last = System.nanoTime();
        this.currentContent = content;
    }

    protected final void initialization() {
        try {
            this.onNewContent(this.currentContent);
            if (this.debugName != null) {
                RegistryCallback callback2 = new RegistryCallback(this){
                    final /* synthetic */ EditableJSONLayout this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onNewMotionScene(@Nullable String content) {
                        if (content == null) {
                            return;
                        }
                        this.this$0.onNewContent(content);
                    }

                    public void onProgress(float progress) {
                        this.this$0.onNewProgress(progress);
                    }

                    public void onDimensions(int width, int height) {
                        this.this$0.onNewDimensions(width, height);
                    }

                    @NotNull
                    public String currentMotionScene() {
                        return EditableJSONLayout.access$getCurrentContent$p(this.this$0);
                    }

                    @NotNull
                    public String currentLayoutInformation() {
                        return EditableJSONLayout.access$getLayoutInformation$p(this.this$0);
                    }

                    public void setLayoutInformationMode(int mode) {
                        this.this$0.onLayoutInformation(mode);
                    }

                    public long getLastModified() {
                        return EditableJSONLayout.access$getLast$p(this.this$0);
                    }

                    public void setDrawDebug(int debugMode) {
                        this.this$0.onDrawDebug(debugMode);
                    }
                };
                Registry registry = Registry.getInstance();
                registry.register(this.debugName, callback2);
            }
        }
        catch (CLParsingException cLParsingException) {
            // empty catch block
        }
    }

    @Override
    public void setUpdateFlag(@NotNull MutableState<Long> needsUpdate) {
        Intrinsics.checkNotNullParameter(needsUpdate, (String)"needsUpdate");
        this.updateFlag = needsUpdate;
    }

    protected final void signalUpdate() {
        if (this.updateFlag != null) {
            MutableState<Long> mutableState = this.updateFlag;
            Intrinsics.checkNotNull(mutableState);
            MutableState<Long> mutableState2 = this.updateFlag;
            Intrinsics.checkNotNull(mutableState2);
            mutableState.setValue((Object)(((Number)mutableState2.getValue()).longValue() + 1L));
        }
    }

    public final void setCurrentContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.onNewContent(content);
    }

    @NotNull
    public final String getCurrentContent() {
        return this.currentContent;
    }

    public final void setDebugName(@Nullable String name) {
        this.debugName = name;
    }

    @Nullable
    public final String getDebugName() {
        return this.debugName;
    }

    @Override
    @NotNull
    public MotionLayoutDebugFlags getForcedDrawDebug() {
        return this.forcedDrawDebug;
    }

    @Override
    public int getForcedWidth() {
        return this.forcedWidth;
    }

    @Override
    public int getForcedHeight() {
        return this.forcedHeight;
    }

    @Override
    public void setLayoutInformation(@NotNull String information) {
        Intrinsics.checkNotNullParameter((Object)information, (String)"information");
        this.last = System.nanoTime();
        this.layoutInformation = information;
    }

    @NotNull
    public final String getLayoutInformation() {
        return this.layoutInformation;
    }

    @Override
    @NotNull
    public LayoutInfoFlags getLayoutInformationMode() {
        return this.layoutInformationMode;
    }

    protected void onNewContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.currentContent = content;
        try {
            CLObject json = CLParser.parse((String)this.currentContent);
            if (json != null) {
                CLObject debug;
                boolean firstTime;
                boolean bl = firstTime = this.debugName == null;
                if (firstTime && (debug = json.getObjectOrNull("Header")) != null) {
                    this.debugName = debug.getStringOrNull("exportAs");
                    this.layoutInformationMode = LayoutInfoFlags.BOUNDS;
                }
                if (!firstTime) {
                    this.signalUpdate();
                }
            }
        }
        catch (CLParsingException cLParsingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void onNewDimensions(int width, int height) {
        this.forcedWidth = width;
        this.forcedHeight = height;
        this.signalUpdate();
    }

    protected final void onLayoutInformation(int mode) {
        int n = mode;
        if (n == LayoutInfoFlags.NONE.ordinal()) {
            this.layoutInformationMode = LayoutInfoFlags.NONE;
        } else if (n == LayoutInfoFlags.BOUNDS.ordinal()) {
            this.layoutInformationMode = LayoutInfoFlags.BOUNDS;
        }
        this.signalUpdate();
    }

    protected final void onDrawDebug(int debugMode) {
        int n = debugMode;
        this.forcedDrawDebug = n == MotionLayoutDebugFlags.UNKNOWN.ordinal() ? MotionLayoutDebugFlags.UNKNOWN : (n == MotionLayoutDebugFlags.NONE.ordinal() ? MotionLayoutDebugFlags.NONE : (n == MotionLayoutDebugFlags.SHOW_ALL.ordinal() ? MotionLayoutDebugFlags.SHOW_ALL : (n == -1 ? MotionLayoutDebugFlags.UNKNOWN : MotionLayoutDebugFlags.UNKNOWN)));
        this.signalUpdate();
    }

    public static final /* synthetic */ String access$getCurrentContent$p(EditableJSONLayout $this) {
        return $this.currentContent;
    }

    public static final /* synthetic */ String access$getLayoutInformation$p(EditableJSONLayout $this) {
        return $this.layoutInformation;
    }

    public static final /* synthetic */ long access$getLast$p(EditableJSONLayout $this) {
        return $this.last;
    }
}

