/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.compose.Arc;
import androidx.constraintlayout.compose.ConstrainedLayoutReference;
import androidx.constraintlayout.compose.ExperimentalMotionApi;
import androidx.constraintlayout.compose.KeyAttributesScope;
import androidx.constraintlayout.compose.KeyCyclesScope;
import androidx.constraintlayout.compose.KeyPositionsScope;
import androidx.constraintlayout.compose.OnSwipe;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLObject;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0001J\r\u0010!\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\"J8\u0010#\u001a\u00020\u001b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0%\"\u00020\u001f2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001b0'\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\u0010*J8\u0010+\u001a\u00020\u001b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0%\"\u00020\u001f2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001b0'\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\u0010*J8\u0010.\u001a\u00020\u001b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0%\"\u00020\u001f2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001b0'\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\u0010*J\r\u00101\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b2R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Landroidx/constraintlayout/compose/TransitionScope;", "", "from", "", "to", "(Ljava/lang/String;Ljava/lang/String;)V", "containerObject", "Landroidx/constraintlayout/core/parser/CLObject;", "keyAttributesArray", "Landroidx/constraintlayout/core/parser/CLArray;", "keyCyclesArray", "keyFramesObject", "keyPositionsArray", "motionArc", "Landroidx/constraintlayout/compose/Arc;", "getMotionArc", "()Landroidx/constraintlayout/compose/Arc;", "setMotionArc", "(Landroidx/constraintlayout/compose/Arc;)V", "onSwipe", "Landroidx/constraintlayout/compose/OnSwipe;", "getOnSwipe", "()Landroidx/constraintlayout/compose/OnSwipe;", "setOnSwipe", "(Landroidx/constraintlayout/compose/OnSwipe;)V", "onSwipeObject", "addKeyAttributesIfMissing", "", "addKeyCyclesIfMissing", "addKeyPositionsIfMissing", "createRefFor", "Landroidx/constraintlayout/compose/ConstrainedLayoutReference;", "id", "getObject", "getObject$constraintlayout_compose_release", "keyAttributes", "targets", "", "keyAttributesContent", "Lkotlin/Function1;", "Landroidx/constraintlayout/compose/KeyAttributesScope;", "Lkotlin/ExtensionFunctionType;", "([Landroidx/constraintlayout/compose/ConstrainedLayoutReference;Lkotlin/jvm/functions/Function1;)V", "keyCycles", "keyCyclesContent", "Landroidx/constraintlayout/compose/KeyCyclesScope;", "keyPositions", "keyPositionsContent", "Landroidx/constraintlayout/compose/KeyPositionsScope;", "reset", "reset$constraintlayout_compose_release", "constraintlayout-compose_release"})
@ExperimentalMotionApi
@StabilityInferred(parameters=0)
public final class TransitionScope {
    @NotNull
    private final String from;
    @NotNull
    private final String to;
    @NotNull
    private final CLObject containerObject;
    @NotNull
    private final CLObject keyFramesObject;
    @NotNull
    private final CLArray keyAttributesArray;
    @NotNull
    private final CLArray keyPositionsArray;
    @NotNull
    private final CLArray keyCyclesArray;
    @NotNull
    private final CLObject onSwipeObject;
    @NotNull
    private Arc motionArc;
    @Nullable
    private OnSwipe onSwipe;
    public static final int $stable = 8;

    public TransitionScope(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.from = from;
        this.to = to;
        this.containerObject = new CLObject(new char[0]);
        this.keyFramesObject = new CLObject(new char[0]);
        this.keyAttributesArray = new CLArray(new char[0]);
        this.keyPositionsArray = new CLArray(new char[0]);
        this.keyCyclesArray = new CLArray(new char[0]);
        this.onSwipeObject = new CLObject(new char[0]);
        this.motionArc = Arc.Companion.getNone();
    }

    public final void reset$constraintlayout_compose_release() {
        this.containerObject.clear();
        this.keyFramesObject.clear();
        this.keyAttributesArray.clear();
        this.onSwipeObject.clear();
    }

    private final void addKeyAttributesIfMissing() {
        this.containerObject.put("KeyFrames", (CLElement)this.keyFramesObject);
        this.keyFramesObject.put("KeyAttributes", (CLElement)this.keyAttributesArray);
    }

    private final void addKeyPositionsIfMissing() {
        this.containerObject.put("KeyFrames", (CLElement)this.keyFramesObject);
        this.keyFramesObject.put("KeyPositions", (CLElement)this.keyPositionsArray);
    }

    private final void addKeyCyclesIfMissing() {
        this.containerObject.put("KeyFrames", (CLElement)this.keyFramesObject);
        this.keyFramesObject.put("KeyCycles", (CLElement)this.keyCyclesArray);
    }

    @NotNull
    public final Arc getMotionArc() {
        return this.motionArc;
    }

    public final void setMotionArc(@NotNull Arc arc) {
        Intrinsics.checkNotNullParameter((Object)arc, (String)"<set-?>");
        this.motionArc = arc;
    }

    @Nullable
    public final OnSwipe getOnSwipe() {
        return this.onSwipe;
    }

    public final void setOnSwipe(@Nullable OnSwipe onSwipe) {
        this.onSwipe = onSwipe;
    }

    public final void keyAttributes(@NotNull ConstrainedLayoutReference[] targets, @NotNull Function1<? super KeyAttributesScope, Unit> keyAttributesContent) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Intrinsics.checkNotNullParameter(keyAttributesContent, (String)"keyAttributesContent");
        KeyAttributesScope scope = new KeyAttributesScope(Arrays.copyOf(targets, targets.length));
        keyAttributesContent.invoke((Object)scope);
        this.addKeyAttributesIfMissing();
        this.keyAttributesArray.add((CLElement)scope.getKeyFramePropsObject$constraintlayout_compose_release());
    }

    public final void keyPositions(@NotNull ConstrainedLayoutReference[] targets, @NotNull Function1<? super KeyPositionsScope, Unit> keyPositionsContent) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Intrinsics.checkNotNullParameter(keyPositionsContent, (String)"keyPositionsContent");
        KeyPositionsScope scope = new KeyPositionsScope(Arrays.copyOf(targets, targets.length));
        keyPositionsContent.invoke((Object)scope);
        this.addKeyPositionsIfMissing();
        this.keyPositionsArray.add((CLElement)scope.getKeyFramePropsObject$constraintlayout_compose_release());
    }

    public final void keyCycles(@NotNull ConstrainedLayoutReference[] targets, @NotNull Function1<? super KeyCyclesScope, Unit> keyCyclesContent) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Intrinsics.checkNotNullParameter(keyCyclesContent, (String)"keyCyclesContent");
        KeyCyclesScope scope = new KeyCyclesScope(Arrays.copyOf(targets, targets.length));
        keyCyclesContent.invoke((Object)scope);
        this.addKeyCyclesIfMissing();
        this.keyCyclesArray.add((CLElement)scope.getKeyFramePropsObject$constraintlayout_compose_release());
    }

    @NotNull
    public final ConstrainedLayoutReference createRefFor(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new ConstrainedLayoutReference(id);
    }

    @NotNull
    public final CLObject getObject$constraintlayout_compose_release() {
        block1: {
            this.containerObject.putString("pathMotionArc", this.motionArc.getName());
            this.containerObject.putString("from", this.from);
            this.containerObject.putString("to", this.to);
            OnSwipe onSwipe = this.onSwipe;
            if (onSwipe == null) break block1;
            OnSwipe it = onSwipe;
            boolean bl = false;
            this.containerObject.put("onSwipe", (CLElement)this.onSwipeObject);
            this.onSwipeObject.putString("direction", it.getDirection().getName());
            this.onSwipeObject.putNumber("dragScale", it.getDragScale());
            Object object = it.getDragAround();
            if (object != null && (object = ((ConstrainedLayoutReference)object).getId$constraintlayout_compose_release()) != null) {
                Object id = object;
                boolean bl2 = false;
                this.onSwipeObject.putString("around", id.toString());
            }
            this.onSwipeObject.putNumber("threshold", it.getDragThreshold());
            this.onSwipeObject.putString("anchor", it.getAnchor().getId$constraintlayout_compose_release().toString());
            this.onSwipeObject.putString("side", it.getSide().getName());
            this.onSwipeObject.putString("touchUp", it.getOnTouchUp().getName());
            this.onSwipeObject.putString("mode", it.getMode().getName());
            this.onSwipeObject.putNumber("maxVelocity", it.getMode().getMaxVelocity$constraintlayout_compose_release());
            this.onSwipeObject.putNumber("maxAccel", it.getMode().getMaxAcceleration$constraintlayout_compose_release());
            this.onSwipeObject.putNumber("springMass", it.getMode().getSpringMass$constraintlayout_compose_release());
            this.onSwipeObject.putNumber("springStiffness", it.getMode().getSpringStiffness$constraintlayout_compose_release());
            this.onSwipeObject.putNumber("springDamping", it.getMode().getSpringDamping$constraintlayout_compose_release());
            this.onSwipeObject.putNumber("stopThreshold", it.getMode().getSpringThreshold$constraintlayout_compose_release());
            this.onSwipeObject.putString("springBoundary", it.getMode().getSpringBoundary$constraintlayout_compose_release().getName());
        }
        return this.containerObject;
    }
}

