/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;

public class AccelerateInterpolator
implements Interpolator {
    private final float mFactor;
    private final double mDoubleFactor;

    public AccelerateInterpolator() {
        this.mFactor = 1.0f;
        this.mDoubleFactor = 2.0;
    }

    public AccelerateInterpolator(float factor) {
        this.mFactor = factor;
        this.mDoubleFactor = 2.0f * this.mFactor;
    }

    public AccelerateInterpolator(@NonNull Context context, @NonNull AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    AccelerateInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_ACCELERATE_INTERPOLATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ACCELERATE_INTERPOLATOR);
        this.mFactor = a.getFloat(0, 1.0f);
        this.mDoubleFactor = 2.0f * this.mFactor;
        a.recycle();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        if (this.mFactor == 1.0f) {
            return input * input;
        }
        return (float)Math.pow(input, this.mDoubleFactor);
    }
}

