/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.animation.ValueAnimator;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import androidx.annotation.RequiresApi;
import androidx.collection.SimpleArrayMap;
import androidx.core.animation.Animator;
import androidx.core.animation.ObjectAnimator;
import java.util.ArrayList;

class AnimationHandler {
    public static AnimationHandler sAnimationHandler = null;
    private static AnimationHandler sTestHandler = null;
    private static final ThreadLocal<AnimationCallbackData> sAnimationCallbackData = new ThreadLocal();
    private final AnimationFrameCallbackProvider mProvider;

    void onAnimationFrame(long frameTime) {
        this.doAnimationFrame(frameTime);
        if (this.getAnimationCallbacks().size() > 0) {
            this.mProvider.postFrameCallback();
        }
    }

    AnimationHandler(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? (Build.VERSION.SDK_INT >= 16 ? new FrameCallbackProvider16() : new FrameCallbackProvider14(this)) : provider;
    }

    public static AnimationHandler getInstance() {
        if (sTestHandler != null) {
            return sTestHandler;
        }
        if (sAnimationHandler == null) {
            sAnimationHandler = new AnimationHandler(null);
        }
        return sAnimationHandler;
    }

    static void setTestHandler(AnimationHandler handler) {
        sTestHandler = handler;
    }

    void setFrameDelay(long frameDelay) {
        this.mProvider.setFrameDelay(frameDelay);
    }

    long getFrameDelay() {
        return this.mProvider.getFrameDelay();
    }

    private SimpleArrayMap<AnimationFrameCallback, Long> getDelayedCallbackStartTime() {
        AnimationCallbackData data = sAnimationCallbackData.get();
        if (data == null) {
            data = new AnimationCallbackData();
            sAnimationCallbackData.set(data);
        }
        return data.mDelayedCallbackStartTime;
    }

    private ArrayList<AnimationFrameCallback> getAnimationCallbacks() {
        AnimationCallbackData data = sAnimationCallbackData.get();
        if (data == null) {
            data = new AnimationCallbackData();
            sAnimationCallbackData.set(data);
        }
        return data.mAnimationCallbacks;
    }

    private boolean isListDirty() {
        AnimationCallbackData data = sAnimationCallbackData.get();
        if (data == null) {
            data = new AnimationCallbackData();
            sAnimationCallbackData.set(data);
        }
        return data.mListDirty;
    }

    private void setListDirty(boolean dirty) {
        AnimationCallbackData data = sAnimationCallbackData.get();
        if (data == null) {
            data = new AnimationCallbackData();
            sAnimationCallbackData.set(data);
        }
        data.mListDirty = dirty;
    }

    void addAnimationFrameCallback(AnimationFrameCallback callback) {
        if (this.getAnimationCallbacks().size() == 0) {
            this.mProvider.postFrameCallback();
        }
        if (!this.getAnimationCallbacks().contains(callback)) {
            this.getAnimationCallbacks().add(callback);
        }
        this.mProvider.onNewCallbackAdded(callback);
    }

    public void removeCallback(AnimationFrameCallback callback) {
        this.getDelayedCallbackStartTime().remove((Object)callback);
        int id = this.getAnimationCallbacks().indexOf(callback);
        if (id >= 0) {
            this.getAnimationCallbacks().set(id, null);
            this.setListDirty(true);
        }
    }

    void autoCancelBasedOn(ObjectAnimator objectAnimator) {
        for (int i = this.getAnimationCallbacks().size() - 1; i >= 0; --i) {
            AnimationFrameCallback cb = this.getAnimationCallbacks().get(i);
            if (cb == null || !objectAnimator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)this.getAnimationCallbacks().get(i))).cancel();
        }
    }

    private void doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        for (int i = 0; i < this.getAnimationCallbacks().size(); ++i) {
            AnimationFrameCallback callback = this.getAnimationCallbacks().get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
        }
        this.cleanUpList();
    }

    private boolean isCallbackDue(AnimationFrameCallback callback, long currentTime) {
        Long startTime = (Long)this.getDelayedCallbackStartTime().get((Object)callback);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.getDelayedCallbackStartTime().remove((Object)callback);
            return true;
        }
        return false;
    }

    private void cleanUpList() {
        if (this.isListDirty()) {
            for (int i = this.getAnimationCallbacks().size() - 1; i >= 0; --i) {
                if (this.getAnimationCallbacks().get(i) != null) continue;
                this.getAnimationCallbacks().remove(i);
            }
            this.setListDirty(false);
        }
    }

    private int getCallbackSize() {
        int count = 0;
        int size = this.getAnimationCallbacks().size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.getAnimationCallbacks().get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static int getAnimationCount() {
        AnimationHandler handler = AnimationHandler.getInstance();
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    static interface AnimationFrameCallbackProvider {
        public void onNewCallbackAdded(AnimationFrameCallback var1);

        public void postFrameCallback();

        public void setFrameDelay(long var1);

        public long getFrameDelay();
    }

    private static class FrameCallbackProvider14
    implements AnimationFrameCallbackProvider,
    Runnable {
        private static final ThreadLocal<Handler> sHandler = new ThreadLocal();
        private long mLastFrameTime = -1L;
        private long mFrameDelay = 16L;
        AnimationHandler mAnimationHandler;

        FrameCallbackProvider14(AnimationHandler animationHandler) {
            this.mAnimationHandler = animationHandler;
        }

        Handler getHandler() {
            if (sHandler.get() == null) {
                sHandler.set(new Handler(Looper.myLooper()));
            }
            return sHandler.get();
        }

        @Override
        public void run() {
            this.mLastFrameTime = SystemClock.uptimeMillis();
            this.mAnimationHandler.onAnimationFrame(this.mLastFrameTime);
        }

        @Override
        public void onNewCallbackAdded(AnimationFrameCallback callback) {
        }

        @Override
        public void postFrameCallback() {
            long delay = this.mFrameDelay - (SystemClock.uptimeMillis() - this.mLastFrameTime);
            delay = Math.max(delay, 0L);
            this.getHandler().postDelayed((Runnable)this, delay);
        }

        @Override
        public void setFrameDelay(long delay) {
            this.mFrameDelay = delay > 0L ? delay : 0L;
        }

        @Override
        public long getFrameDelay() {
            return this.mFrameDelay;
        }
    }

    @RequiresApi(value=16)
    private class FrameCallbackProvider16
    implements AnimationFrameCallbackProvider,
    Choreographer.FrameCallback {
        FrameCallbackProvider16() {
        }

        public void doFrame(long frameTimeNanos) {
            AnimationHandler.this.onAnimationFrame(frameTimeNanos / 1000000L);
        }

        @Override
        public void onNewCallbackAdded(AnimationFrameCallback callback) {
        }

        @Override
        public void postFrameCallback() {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }

        @Override
        public void setFrameDelay(long delay) {
            ValueAnimator.setFrameDelay((long)delay);
        }

        @Override
        public long getFrameDelay() {
            return ValueAnimator.getFrameDelay();
        }
    }

    static class AnimationCallbackData {
        final SimpleArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime = new SimpleArrayMap();
        final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
        boolean mListDirty = false;

        AnimationCallbackData() {
        }
    }

    static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

