/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;

public class CycleInterpolator
implements Interpolator {
    private float mCycles;

    public CycleInterpolator(float cycles) {
        this.mCycles = cycles;
    }

    public CycleInterpolator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    CycleInterpolator(Resources resources, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_CYCLE_INTERPOLATOR, 0, 0) : resources.obtainAttributes(attrs, AndroidResources.STYLEABLE_CYCLE_INTERPOLATOR);
        this.mCycles = a.getFloat(0, 1.0f);
        a.recycle();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        return (float)Math.sin((double)(2.0f * this.mCycles) * Math.PI * (double)input);
    }
}

