/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;

public class DecelerateInterpolator
implements Interpolator {
    private float mFactor = 1.0f;

    public DecelerateInterpolator() {
    }

    public DecelerateInterpolator(float factor) {
        this.mFactor = factor;
    }

    public DecelerateInterpolator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    DecelerateInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_DECELERATE_INTERPOLATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_DECELERATE_INTERPOLATOR);
        this.mFactor = a.getFloat(0, 1.0f);
        a.recycle();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        float result = this.mFactor == 1.0f ? 1.0f - (1.0f - input) * (1.0f - input) : (float)(1.0 - Math.pow(1.0f - input, 2.0f * this.mFactor));
        return result;
    }
}

