/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.TypeEvaluator;

public final class FloatArrayEvaluator
implements TypeEvaluator<float[]> {
    private float[] mArray;

    public FloatArrayEvaluator() {
    }

    public FloatArrayEvaluator(@Nullable float[] reuseArray) {
        this.mArray = reuseArray;
    }

    @Override
    @NonNull
    public float[] evaluate(float fraction, @NonNull float[] startValue, @NonNull float[] endValue) {
        float[] array = this.mArray;
        if (array == null) {
            array = new float[startValue.length];
        }
        for (int i = 0; i < array.length; ++i) {
            float start = startValue[i];
            float end = endValue[i];
            array[i] = start + fraction * (end - start);
        }
        return array;
    }
}

