/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import androidx.annotation.NonNull;
import androidx.core.animation.Interpolator;
import androidx.core.animation.Keyframe;
import androidx.core.animation.KeyframeSet;
import androidx.core.animation.Keyframes;
import java.util.List;

class IntKeyframeSet
extends KeyframeSet<Integer>
implements Keyframes.IntKeyframes {
    IntKeyframeSet(Keyframe.IntKeyframe ... keyframes) {
        super(keyframes);
    }

    @Override
    public Integer getValue(float fraction) {
        return this.getIntValue(fraction);
    }

    @Override
    @NonNull
    public IntKeyframeSet clone() {
        List keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.IntKeyframe[] newKeyframes = new Keyframe.IntKeyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = (Keyframe.IntKeyframe)((Keyframe)keyframes.get(i)).clone();
        }
        IntKeyframeSet newSet = new IntKeyframeSet(newKeyframes);
        return newSet;
    }

    @Override
    public int getIntValue(float fraction) {
        if (fraction <= 0.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue);
        }
        if (fraction >= 1.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue);
        }
        Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator = nextKeyframe.getInterpolator();
                float intervalFraction = (fraction - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                int prevValue = prevKeyframe.getIntValue();
                int nextValue = nextKeyframe.getIntValue();
                if (interpolator != null) {
                    intervalFraction = interpolator.getInterpolation(intervalFraction);
                }
                return this.mEvaluator == null ? prevValue + Math.round(intervalFraction * (float)(nextValue - prevValue)) : this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue);
            }
            prevKeyframe = nextKeyframe;
        }
        return (Integer)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue();
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

