/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.annotation.SuppressLint;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.Interpolator;

public abstract class Keyframe<T>
implements Cloneable {
    boolean mHasValue;
    boolean mValueWasSetOnStart;
    float mFraction;
    Class<?> mValueType;
    private Interpolator mInterpolator = null;

    @NonNull
    public static Keyframe<Integer> ofInt(@FloatRange(from=0.0, to=1.0) float fraction, int value) {
        return new IntKeyframe(fraction, value);
    }

    @NonNull
    public static Keyframe<Integer> ofInt(@FloatRange(from=0.0, to=1.0) float fraction) {
        return new IntKeyframe(fraction);
    }

    @NonNull
    public static Keyframe<Float> ofFloat(@FloatRange(from=0.0, to=1.0) float fraction, float value) {
        return new FloatKeyframe(fraction, value);
    }

    @NonNull
    public static Keyframe<Float> ofFloat(@FloatRange(from=0.0, to=1.0) float fraction) {
        return new FloatKeyframe(fraction);
    }

    @NonNull
    public static <T> Keyframe<T> ofObject(@FloatRange(from=0.0, to=1.0) float fraction, @Nullable T value) {
        return new ObjectKeyframe<T>(fraction, value);
    }

    @NonNull
    public static <T> Keyframe<T> ofObject(@FloatRange(from=0.0, to=1.0) float fraction) {
        return new ObjectKeyframe<Object>(fraction, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    boolean valueWasSetOnStart() {
        return this.mValueWasSetOnStart;
    }

    void setValueWasSetOnStart(boolean valueWasSetOnStart) {
        this.mValueWasSetOnStart = valueWasSetOnStart;
    }

    @Nullable
    public abstract T getValue();

    public abstract void setValue(@Nullable T var1);

    @FloatRange(from=0.0, to=1.0)
    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(@FloatRange(from=0.0, to=1.0) float fraction) {
        this.mFraction = fraction;
    }

    @Nullable
    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(@Nullable Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @NonNull
    public Class<?> getType() {
        return this.mValueType;
    }

    @SuppressLint(value={"NoClone"})
    @NonNull
    public abstract Keyframe<T> clone();

    static class FloatKeyframe
    extends Keyframe<Float> {
        float mValue;

        FloatKeyframe(float fraction, float value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mValueType = Float.TYPE;
            this.mHasValue = true;
        }

        FloatKeyframe(float fraction) {
            this.mFraction = fraction;
            this.mValueType = Float.TYPE;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.mValue);
        }

        @Override
        public void setValue(Float value) {
            if (value != null && value.getClass() == Float.class) {
                this.mValue = value.floatValue();
                this.mHasValue = true;
            }
        }

        @Override
        @NonNull
        public FloatKeyframe clone() {
            FloatKeyframe kfClone = this.mHasValue ? new FloatKeyframe(this.getFraction(), this.mValue) : new FloatKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static class IntKeyframe
    extends Keyframe<Integer> {
        int mValue;

        IntKeyframe(float fraction, int value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mValueType = Integer.TYPE;
            this.mHasValue = true;
        }

        IntKeyframe(float fraction) {
            this.mFraction = fraction;
            this.mValueType = Integer.TYPE;
        }

        public int getIntValue() {
            return this.mValue;
        }

        @Override
        public Integer getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Integer value) {
            if (value != null && value.getClass() == Integer.class) {
                this.mValue = value;
                this.mHasValue = true;
            }
        }

        @Override
        @NonNull
        public IntKeyframe clone() {
            IntKeyframe kfClone = this.mHasValue ? new IntKeyframe(this.getFraction(), this.mValue) : new IntKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static class ObjectKeyframe<T>
    extends Keyframe<T> {
        T mValue;

        ObjectKeyframe(float fraction, T value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mHasValue = value != null;
            this.mValueType = this.mHasValue ? value.getClass() : Object.class;
        }

        @Override
        public T getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(T value) {
            this.mValue = value;
            this.mHasValue = value != null;
        }

        @Override
        @NonNull
        public ObjectKeyframe<T> clone() {
            ObjectKeyframe<Object> kfClone = new ObjectKeyframe<Object>(this.getFraction(), (this.hasValue() ? (T)this.mValue : null));
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }
}

