/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;

class PathUtils {
    private static final int NUM_COMPONENTS = 3;
    private static final int MAX_NUM_POINTS = 100;
    private static final float EPSILON = 1.0E-4f;

    private PathUtils() {
    }

    static float[] createKeyFrameData(Path path, float precision) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.approximate(path, precision);
        }
        PathMeasure measureForTotalLength = new PathMeasure(path, false);
        float totalLength = 0.0f;
        ArrayList<Float> contourLengths = new ArrayList<Float>();
        contourLengths.add(Float.valueOf(0.0f));
        do {
            float pathLength = measureForTotalLength.getLength();
            contourLengths.add(Float.valueOf(totalLength += pathLength));
        } while (measureForTotalLength.nextContour());
        PathMeasure pathMeasure = new PathMeasure(path, false);
        int numPoints = Math.min(100, (int)(totalLength / precision) + 1);
        ArrayList<Float> results = new ArrayList<Float>(numPoints * 3);
        float[] position = new float[2];
        int contourIndex = 0;
        float step = totalLength / (float)(numPoints - 1 - contourLengths.size());
        float currentDistance = 0.0f;
        float[] lastTangent = new float[2];
        float[] tangent = new float[2];
        boolean lastTwoPointsOnALine = false;
        for (int i = 0; i < numPoints; ++i) {
            pathMeasure.getPosTan(currentDistance - ((Float)contourLengths.get(contourIndex)).floatValue(), position, tangent);
            int lastIndex = results.size() - 1;
            if (i > 0 && PathUtils.twoPointsOnTheSameLinePath(tangent, lastTangent, position[0], position[1], ((Float)results.get(lastIndex - 1)).floatValue(), ((Float)results.get(lastIndex)).floatValue())) {
                if (lastTwoPointsOnALine) {
                    results.set(lastIndex - 2, Float.valueOf(currentDistance / totalLength));
                    results.set(lastIndex - 1, Float.valueOf(position[0]));
                    results.set(lastIndex, Float.valueOf(position[1]));
                } else {
                    lastTwoPointsOnALine = true;
                    PathUtils.addDataEntry(results, currentDistance / totalLength, position[0], position[1]);
                }
            } else {
                int skippedPoints = i - results.size() / 3;
                if (skippedPoints > 0 && lastTwoPointsOnALine) {
                    float fineGrainedDistance = totalLength * ((Float)results.get(results.size() - 3)).floatValue();
                    float samplePoints = Math.min(skippedPoints, 4);
                    float smallStep = step / samplePoints;
                    while (fineGrainedDistance + smallStep < currentDistance) {
                        pathMeasure.getPosTan((fineGrainedDistance += smallStep) - ((Float)contourLengths.get(contourIndex)).floatValue(), position, tangent);
                        PathUtils.addDataEntry(results, fineGrainedDistance / totalLength, position[0], position[1]);
                    }
                } else {
                    PathUtils.addDataEntry(results, currentDistance / totalLength, position[0], position[1]);
                }
                lastTwoPointsOnALine = false;
            }
            currentDistance += step;
            if (contourIndex + 1 < contourLengths.size() && currentDistance > ((Float)contourLengths.get(contourIndex + 1)).floatValue()) {
                float currentContourSum = ((Float)contourLengths.get(contourIndex + 1)).floatValue();
                pathMeasure.getPosTan(currentContourSum - ((Float)contourLengths.get(contourIndex)).floatValue(), position, tangent);
                PathUtils.addDataEntry(results, currentContourSum / totalLength, position[0], position[1]);
                ++contourIndex;
                pathMeasure.nextContour();
            }
            lastTangent[0] = tangent[0];
            lastTangent[1] = tangent[1];
            if (currentDistance > totalLength) break;
        }
        float[] optimizedResults = new float[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            optimizedResults[i] = ((Float)results.get(i)).floatValue();
        }
        return optimizedResults;
    }

    private static boolean twoPointsOnTheSameLinePath(float[] tan1, float[] tan2, float x1, float y1, float x2, float y2) {
        if (Math.abs(tan1[0] - tan2[0]) > 1.0E-4f || Math.abs(tan1[1] - tan2[1]) > 1.0E-4f) {
            return false;
        }
        float deltaX = x1 - x2;
        float deltaY = y1 - y2;
        return Math.abs(deltaX * tan1[1] - deltaY * tan1[0]) < 1.0E-4f;
    }

    private static void addDataEntry(List<Float> data, float fraction, float x, float y) {
        data.add(Float.valueOf(fraction));
        data.add(Float.valueOf(x));
        data.add(Float.valueOf(y));
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static float[] approximate(Path path, float acceptableError) {
            return path.approximate(acceptableError);
        }
    }
}

