/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.core.animation.TypeEvaluator;

public class RectEvaluator
implements TypeEvaluator<Rect> {
    private Rect mRect;

    public RectEvaluator() {
    }

    public RectEvaluator(@NonNull Rect reuseRect) {
        this.mRect = reuseRect;
    }

    @Override
    @NonNull
    public Rect evaluate(float fraction, @NonNull Rect startValue, @NonNull Rect endValue) {
        int left = startValue.left + (int)((float)(endValue.left - startValue.left) * fraction);
        int top = startValue.top + (int)((float)(endValue.top - startValue.top) * fraction);
        int right = startValue.right + (int)((float)(endValue.right - startValue.right) * fraction);
        int bottom = startValue.bottom + (int)((float)(endValue.bottom - startValue.bottom) * fraction);
        if (this.mRect == null) {
            return new Rect(left, top, right, bottom);
        }
        this.mRect.set(left, top, right, bottom);
        return this.mRect;
    }
}

