/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.animation.AnimationUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.animation.AccelerateDecelerateInterpolator;
import androidx.core.animation.AnimationHandler;
import androidx.core.animation.Animator;
import androidx.core.animation.ArgbEvaluator;
import androidx.core.animation.Interpolator;
import androidx.core.animation.LinearInterpolator;
import androidx.core.animation.PropertyValuesHolder;
import androidx.core.animation.TypeEvaluator;
import androidx.tracing.Trace;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator
implements AnimationHandler.AnimationFrameCallback {
    private static final String TAG = "ValueAnimator";
    private static float sDurationScale = 1.0f;
    long mStartTime = -1L;
    float mSeekFraction = -1.0f;
    private long mPauseTime;
    private boolean mResumed = false;
    private static final Interpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mReversing;
    private float mOverallFraction = 0.0f;
    private float mCurrentFraction = 0.0f;
    private long mLastFrameTime = -1L;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mStartListenersCalled = false;
    boolean mInitialized = false;
    private boolean mAnimationEndRequested = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private boolean mSelfPulse = true;
    private boolean mSuppressSelfPulseRequested = false;
    private Interpolator mInterpolator = sDefaultInterpolator;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    private float mDurationScale = -1.0f;
    String mAnimTraceName = null;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    static void setDurationScale(float durationScale) {
        sDurationScale = durationScale;
    }

    static float getDurationScale() {
        return sDurationScale;
    }

    public static boolean areAnimatorsEnabled() {
        return sDurationScale != 0.0f;
    }

    @NonNull
    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setIntValues(values);
        return anim;
    }

    @NonNull
    public static ValueAnimator ofArgb(int ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setIntValues(values);
        anim.setEvaluator(ArgbEvaluator.getInstance());
        return anim;
    }

    @NonNull
    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setFloatValues(values);
        return anim;
    }

    @NonNull
    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(values);
        return anim;
    }

    @NonNull
    public static ValueAnimator ofObject(@NonNull TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setObjectValues(values);
        anim.setEvaluator(evaluator);
        return anim;
    }

    public void setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    @SuppressLint(value={"ArrayReturn"})
    @NonNull
    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    @CallSuper
    void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    @NonNull
    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDuration = duration;
        return this;
    }

    void overrideDurationScale(float durationScale) {
        this.mDurationScale = durationScale;
    }

    private float resolveDurationScale() {
        return this.mDurationScale >= 0.0f ? this.mDurationScale : sDurationScale;
    }

    private long getScaledDuration() {
        return (long)((float)this.mDuration * this.resolveDurationScale());
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public long getTotalDuration() {
        if (this.mRepeatCount == -1) {
            return -1L;
        }
        return this.mStartDelay + this.mDuration * (long)(this.mRepeatCount + 1);
    }

    public void setCurrentPlayTime(long playTime) {
        float fraction = this.mDuration > 0L ? (float)playTime / (float)this.mDuration : 1.0f;
        this.setCurrentFraction(fraction);
    }

    public void setCurrentFraction(float fraction) {
        this.initAnimation();
        fraction = this.clampFraction(fraction);
        if (this.isPulsingInternal()) {
            long seekTime = (long)((float)this.getScaledDuration() * fraction);
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = currentTime - seekTime;
        } else {
            this.mSeekFraction = fraction;
        }
        this.mOverallFraction = fraction;
        float currentIterationFraction = this.getCurrentIterationFraction(fraction, this.mReversing);
        this.animateValue(currentIterationFraction);
    }

    private int getCurrentIteration(float fraction) {
        double iteration;
        if ((double)(fraction = this.clampFraction(fraction)) == (iteration = Math.floor(fraction)) && fraction > 0.0f) {
            iteration -= 1.0;
        }
        return (int)iteration;
    }

    private float getCurrentIterationFraction(float fraction, boolean inReverse) {
        fraction = this.clampFraction(fraction);
        int iteration = this.getCurrentIteration(fraction);
        float currentFraction = fraction - (float)iteration;
        return this.shouldPlayBackward(iteration, inReverse) ? 1.0f - currentFraction : currentFraction;
    }

    private float clampFraction(float fraction) {
        if (fraction < 0.0f) {
            fraction = 0.0f;
        } else if (this.mRepeatCount != -1) {
            fraction = Math.min(fraction, (float)(this.mRepeatCount + 1));
        }
        return fraction;
    }

    private boolean shouldPlayBackward(int iteration, boolean inReverse) {
        if (iteration > 0 && this.mRepeatMode == 2 && (iteration < this.mRepeatCount + 1 || this.mRepeatCount == -1)) {
            if (inReverse) {
                return iteration % 2 == 0;
            }
            return iteration % 2 != 0;
        }
        return inReverse;
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || !this.mStarted && this.mSeekFraction < 0.0f) {
            return 0L;
        }
        if (this.mSeekFraction >= 0.0f) {
            return (long)((float)this.mDuration * this.mSeekFraction);
        }
        float durationScale = this.resolveDurationScale();
        if (durationScale == 0.0f) {
            durationScale = 1.0f;
        }
        return (long)((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / durationScale);
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            Log.w((String)TAG, (String)"Start delay should always be non-negative");
            startDelay = 0L;
        }
        this.mStartDelay = startDelay;
    }

    public static long getFrameDelay() {
        return AnimationHandler.getInstance().getFrameDelay();
    }

    public static void setFrameDelay(long frameDelay) {
        AnimationHandler.getInstance().setFrameDelay(frameDelay);
    }

    @NonNull
    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    @Nullable
    public Object getAnimatedValue(@NonNull String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    @Override
    public void setInterpolator(@Nullable Interpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    @Override
    @Nullable
    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(@NonNull TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private void notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this, this.mReversing);
            }
        }
        this.mStartListenersCalled = true;
    }

    private void start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mReversing = playBackwards;
        boolean bl = this.mSelfPulse = !this.mSuppressSelfPulseRequested;
        if (playBackwards && this.mSeekFraction != -1.0f && this.mSeekFraction != 0.0f) {
            if (this.mRepeatCount == -1) {
                float fraction = (float)((double)this.mSeekFraction - Math.floor(this.mSeekFraction));
                this.mSeekFraction = 1.0f - fraction;
            } else {
                this.mSeekFraction = (float)(1 + this.mRepeatCount) - this.mSeekFraction;
            }
        }
        this.mStarted = true;
        this.mPaused = false;
        this.mRunning = false;
        this.mAnimationEndRequested = false;
        this.mLastFrameTime = -1L;
        this.mStartTime = -1L;
        if (this.mStartDelay == 0L || this.mSeekFraction >= 0.0f || this.mReversing) {
            this.startAnimation();
            if (this.mSeekFraction == -1.0f) {
                this.setCurrentPlayTime(0L);
            } else {
                this.setCurrentFraction(this.mSeekFraction);
            }
        }
        this.addAnimationCallback();
    }

    @Override
    void startWithoutPulsing(boolean inReverse) {
        this.mSuppressSelfPulseRequested = true;
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
        this.mSuppressSelfPulseRequested = false;
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mAnimationEndRequested) {
            return;
        }
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (Animator.AnimatorListener listener : tmpListeners) {
                listener.onAnimationCancel(this);
            }
        }
        this.endAnimation();
    }

    @Override
    public void end() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (!this.mRunning) {
            this.startAnimation();
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.shouldPlayBackward(this.mRepeatCount, this.mReversing) ? 0.0f : 1.0f);
        this.endAnimation();
    }

    @Override
    public void resume() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be resumed from the same thread that the animator was started on");
        }
        if (this.mPaused && !this.mResumed) {
            this.mResumed = true;
            if (this.mPauseTime > 0L) {
                this.addAnimationCallback();
            }
        }
        super.resume();
    }

    @Override
    public void pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public void reverse() {
        if (this.isPulsingInternal()) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.getScaledDuration() - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
            this.mReversing = !this.mReversing;
        } else if (this.mStarted) {
            this.mReversing = !this.mReversing;
            this.end();
        } else {
            this.start(true);
        }
    }

    @Override
    boolean canReverse() {
        return true;
    }

    private void endAnimation() {
        boolean notify;
        if (this.mAnimationEndRequested) {
            return;
        }
        this.removeAnimationCallback();
        this.mAnimationEndRequested = true;
        this.mPaused = false;
        boolean bl = notify = (this.mStarted || this.mRunning) && this.mListeners != null;
        if (notify && !this.mRunning) {
            this.notifyStartListeners();
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mLastFrameTime = -1L;
        this.mStartTime = -1L;
        if (notify && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this, this.mReversing);
            }
        }
        this.mReversing = false;
        Trace.endSection();
    }

    private void startAnimation() {
        Trace.beginSection((String)this.getNameForTrace());
        this.mAnimationEndRequested = false;
        this.initAnimation();
        this.mRunning = true;
        this.mOverallFraction = this.mSeekFraction >= 0.0f ? this.mSeekFraction : 0.0f;
        if (this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private boolean isPulsingInternal() {
        return this.mLastFrameTime >= 0L;
    }

    @NonNull
    public String getNameForTrace() {
        return this.mAnimTraceName == null ? "animator" : this.mAnimTraceName;
    }

    public void setNameForTrace(@NonNull String animationName) {
        this.mAnimTraceName = animationName;
    }

    boolean animateBasedOnTime(long currentTime) {
        boolean done = false;
        if (this.mRunning) {
            boolean lastIterationFinished;
            long scaledDuration = this.getScaledDuration();
            float fraction = scaledDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)scaledDuration : 1.0f;
            float lastFraction = this.mOverallFraction;
            boolean newIteration = (int)fraction > (int)lastFraction;
            boolean bl = lastIterationFinished = fraction >= (float)(this.mRepeatCount + 1) && this.mRepeatCount != -1;
            if (scaledDuration == 0L) {
                done = true;
            } else if (newIteration && !lastIterationFinished) {
                if (this.mListeners != null) {
                    int numListeners = this.mListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                    }
                }
            } else if (lastIterationFinished) {
                done = true;
            }
            this.mOverallFraction = this.clampFraction(fraction);
            float currentIterationFraction = this.getCurrentIterationFraction(this.mOverallFraction, this.mReversing);
            this.animateValue(currentIterationFraction);
        }
        return done;
    }

    @Override
    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        this.initAnimation();
        if (this.mRepeatCount > 0) {
            int iteration = (int)(currentPlayTime / this.mDuration);
            int lastIteration = (int)(lastPlayTime / this.mDuration);
            if ((iteration = Math.min(iteration, this.mRepeatCount)) != (lastIteration = Math.min(lastIteration, this.mRepeatCount)) && this.mListeners != null) {
                int numListeners = this.mListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                }
            }
        }
        if (this.mRepeatCount != -1 && currentPlayTime >= (long)(this.mRepeatCount + 1) * this.mDuration) {
            this.skipToEndValue(inReverse);
        } else {
            float fraction = (float)currentPlayTime / (float)this.mDuration;
            fraction = this.getCurrentIterationFraction(fraction, inReverse);
            this.animateValue(fraction);
        }
    }

    @Override
    void skipToEndValue(boolean inReverse) {
        float endFraction;
        this.initAnimation();
        float f = endFraction = inReverse ? 0.0f : 1.0f;
        if (this.mRepeatCount % 2 == 1 && this.mRepeatMode == 2) {
            endFraction = 0.0f;
        }
        this.animateValue(endFraction);
    }

    @Override
    boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final boolean doAnimationFrame(long frameTime) {
        if (this.mStartTime < 0L) {
            long l = this.mStartTime = this.mReversing ? frameTime : frameTime + (long)((float)this.mStartDelay * this.resolveDurationScale());
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
            }
        }
        if (!this.mRunning) {
            if (this.mStartTime > frameTime && this.mSeekFraction == -1.0f) {
                return false;
            }
            this.mRunning = true;
            this.startAnimation();
        }
        if (this.mLastFrameTime < 0L && this.mSeekFraction >= 0.0f) {
            long seekTime = (long)((float)this.getScaledDuration() * this.mSeekFraction);
            this.mStartTime = frameTime - seekTime;
            this.mSeekFraction = -1.0f;
        }
        this.mLastFrameTime = frameTime;
        long currentTime = Math.max(frameTime, this.mStartTime);
        boolean finished = this.animateBasedOnTime(currentTime);
        if (finished) {
            this.endAnimation();
        }
        return finished;
    }

    @Override
    boolean pulseAnimationFrame(long frameTime) {
        if (this.mSelfPulse) {
            return false;
        }
        return this.doAnimationFrame(frameTime);
    }

    private void removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        ValueAnimator.removeAnimationCallback(this);
    }

    private void addAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        ValueAnimator.addAnimationCallback(this);
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    @CallSuper
    void animateValue(float fraction) {
        this.mCurrentFraction = fraction = this.mInterpolator.getInterpolation(fraction);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorUpdateListener)this.mUpdateListeners.get(i)).onAnimationUpdate(this);
            }
        }
    }

    @Override
    @SuppressLint(value={"NoClone"})
    @NonNull
    public ValueAnimator clone() {
        ValueAnimator anim = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            anim.mUpdateListeners = new ArrayList(this.mUpdateListeners);
        }
        anim.mSeekFraction = -1.0f;
        anim.mReversing = false;
        anim.mInitialized = false;
        anim.mStarted = false;
        anim.mRunning = false;
        anim.mPaused = false;
        anim.mResumed = false;
        anim.mStartListenersCalled = false;
        anim.mStartTime = -1L;
        anim.mAnimationEndRequested = false;
        anim.mPauseTime = -1L;
        anim.mLastFrameTime = -1L;
        anim.mOverallFraction = 0.0f;
        anim.mCurrentFraction = 0.0f;
        anim.mSelfPulse = true;
        anim.mSuppressSelfPulseRequested = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim.mValues = new PropertyValuesHolder[numValues];
            anim.mValuesMap = new HashMap(numValues);
            for (int i = 0; i < numValues; ++i) {
                PropertyValuesHolder newValuesHolder;
                anim.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim.mValuesMap.put(newValuesHolder.getPropertyName(), newValuesHolder);
            }
        }
        return anim;
    }

    static int getCurrentAnimationsCount() {
        return AnimationHandler.getAnimationCount();
    }

    @NonNull
    public String toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }
}

