/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.RequiresApi;
import androidx.core.graphics.PathSegment;
import java.util.ArrayList;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\f\u001a\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\n\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\f\u001a\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\n\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\f\u00a8\u0006\f"}, d2={"and", "Landroid/graphics/Path;", "p", "flatten", "", "Landroidx/core/graphics/PathSegment;", "error", "", "minus", "or", "plus", "xor", "core-ktx_release"})
public final class PathKt {
    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    @NotNull
    public static final Iterable<PathSegment> flatten(@NotNull Path $receiver, float error) {
        float[] pathData = $receiver.approximate(error);
        int pointCount = pathData.length / 3;
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>(pointCount / 2);
        int n = 1;
        int n2 = pointCount;
        while (n < n2) {
            void i;
            void index = i * 3;
            void prevIndex = (i - true) * 3;
            float d = pathData[index];
            float x = pathData[index + true];
            float y = pathData[index + 2];
            float pd = pathData[prevIndex];
            float px = pathData[prevIndex + true];
            float py = pathData[prevIndex + 2];
            if (d != pd && (x != px || y != py)) {
                segments.add(new PathSegment(new PointF(px, py), pd, new PointF(x, y), d));
            }
            ++i;
        }
        return segments;
    }

    @RequiresApi(value=26)
    @NotNull
    public static /* bridge */ /* synthetic */ Iterable flatten$default(Path path, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        return PathKt.flatten(path, f);
    }

    @RequiresApi(value=19)
    @NotNull
    public static final Path plus(@NotNull Path $receiver, @NotNull Path p) {
        Path path;
        Path $receiver2 = path = new Path($receiver);
        $receiver2.op(p, Path.Op.UNION);
        return path;
    }

    @RequiresApi(value=19)
    @NotNull
    public static final Path minus(@NotNull Path $receiver, @NotNull Path p) {
        Path path;
        Path $receiver2 = path = new Path($receiver);
        $receiver2.op(p, Path.Op.DIFFERENCE);
        return path;
    }

    @RequiresApi(value=19)
    @NotNull
    public static final Path and(@NotNull Path $receiver, @NotNull Path p) {
        Path path;
        Path $receiver$iv = $receiver;
        Path $receiver$iv2 = path = new Path($receiver$iv);
        $receiver$iv2.op(p, Path.Op.UNION);
        return path;
    }

    @RequiresApi(value=19)
    @NotNull
    public static final Path or(@NotNull Path $receiver, @NotNull Path p) {
        Path path;
        Path $receiver2 = path = new Path();
        $receiver2.op($receiver, p, Path.Op.INTERSECT);
        return path;
    }

    @RequiresApi(value=19)
    @NotNull
    public static final Path xor(@NotNull Path $receiver, @NotNull Path p) {
        Path path;
        Path $receiver2 = path = new Path($receiver);
        $receiver2.op(p, Path.Op.XOR);
        return path;
    }
}

