/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0017\u0010\u000b\u001a\u00020\f*\u00020\u00032\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0087\b\u001a2\u0010\u000f\u001a\u00020\f*\u00020\u00032#\b\u0004\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0011H\u0086\b\u001a2\u0010\u0015\u001a\u00020\f*\u00020\u00032#\b\u0004\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0011H\u0086\b\u001a2\u0010\u0016\u001a\u00020\f*\u00020\u00032#\b\u0004\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0011H\u0086\b\u001a%\u0010\u0017\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0004\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0086\b\u001a%\u0010\u001c\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0004\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0087\b\u001a\u0017\u0010\u001d\u001a\u00020\f*\u00020\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u000eH\u0086\b\u001a\u0014\u0010\u001f\u001a\u00020 *\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"\u001a7\u0010#\u001a\u00020\f\"\n\b\u0000\u0010$\u0018\u0001*\u00020%*\u00020\u00032\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\u0002\b'H\u0087\b\u00a2\u0006\u0002\b(\u001a&\u0010#\u001a\u00020\f*\u00020\u00032\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\u0002\b'H\u0086\b\u001a5\u0010)\u001a\u00020\f*\u00020\u00032\b\b\u0003\u0010*\u001a\u00020\u000e2\b\b\u0003\u0010+\u001a\u00020\u000e2\b\b\u0003\u0010,\u001a\u00020\u000e2\b\b\u0003\u0010-\u001a\u00020\u000eH\u0086\b\u001a5\u0010.\u001a\u00020\f*\u00020\u00032\b\b\u0003\u0010/\u001a\u00020\u000e2\b\b\u0003\u0010+\u001a\u00020\u000e2\b\b\u0003\u00100\u001a\u00020\u000e2\b\b\u0003\u0010-\u001a\u00020\u000eH\u0087\b\"*\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0004\"\u0004\b\u0005\u0010\u0006\"*\u0010\u0007\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\u0004\"\u0004\b\b\u0010\u0006\"*\u0010\t\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0004\"\u0004\b\n\u0010\u0006\u00a8\u00061"}, d2={"value", "", "isGone", "Landroid/view/View;", "(Landroid/view/View;)Z", "setGone", "(Landroid/view/View;Z)V", "isInvisible", "setInvisible", "isVisible", "setVisible", "announceForAccessibility", "", "resource", "", "doOnLayout", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "view", "doOnNextLayout", "doOnPreDraw", "postDelayed", "Ljava/lang/Runnable;", "delayInMillis", "", "Lkotlin/Function0;", "postOnAnimationDelayed", "setPadding", "size", "toBitmap", "Landroid/graphics/Bitmap;", "config", "Landroid/graphics/Bitmap$Config;", "updateLayoutParams", "T", "Landroid/view/ViewGroup$LayoutParams;", "block", "Lkotlin/ExtensionFunctionType;", "updateLayoutParamsTyped", "updatePadding", "left", "top", "right", "bottom", "updatePaddingRelative", "start", "end", "core-ktx_release"})
public final class ViewKt {
    public static final void doOnNextLayout(@NotNull View $receiver, @NotNull Function1<? super View, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        $receiver.addOnLayoutChangeListener(new View.OnLayoutChangeListener(action){
            final /* synthetic */ Function1 $action;

            public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                this.$action.invoke((Object)view);
            }
            {
                this.$action = $captured_local_variable$0;
            }
        });
    }

    public static final void doOnLayout(@NotNull View $receiver, @NotNull Function1<? super View, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if (ViewCompat.isLaidOut((View)$receiver) && !$receiver.isLayoutRequested()) {
            action.invoke((Object)$receiver);
        } else {
            View $receiver$iv = $receiver;
            $receiver$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(action){
                final /* synthetic */ Function1 $action$inlined;
                {
                    this.$action$inlined = function1;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    this.$action$inlined.invoke((Object)it);
                }
            });
        }
    }

    public static final void doOnPreDraw(@NotNull View $receiver, @NotNull Function1<? super View, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        ViewTreeObserver vto = $receiver.getViewTreeObserver();
        vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener($receiver, action, vto){
            final /* synthetic */ View receiver$0;
            final /* synthetic */ Function1 $action;
            final /* synthetic */ ViewTreeObserver $vto;

            public boolean onPreDraw() {
                this.$action.invoke((Object)this.receiver$0);
                ViewTreeObserver viewTreeObserver = this.$vto;
                Intrinsics.checkExpressionValueIsNotNull((Object)viewTreeObserver, (String)"vto");
                if (viewTreeObserver.isAlive()) {
                    this.$vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                } else {
                    this.receiver$0.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
            {
                this.receiver$0 = $receiver;
                this.$action = $captured_local_variable$1;
                this.$vto = $captured_local_variable$2;
            }
        });
    }

    @RequiresApi(value=16)
    public static final void announceForAccessibility(@NotNull View $receiver, @StringRes int resource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String announcement = $receiver.getResources().getString(resource);
        $receiver.announceForAccessibility((CharSequence)announcement);
    }

    @RequiresApi(value=17)
    public static final void updatePaddingRelative(@NotNull View $receiver, @Px int start, @Px int top, @Px int end, @Px int bottom) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setPaddingRelative(start, top, end, bottom);
    }

    @RequiresApi(value=17)
    public static /* bridge */ /* synthetic */ void updatePaddingRelative$default(View $receiver, int start, int top, int end, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            start = $receiver.getPaddingStart();
        }
        if ((n & 2) != 0) {
            top = $receiver.getPaddingTop();
        }
        if ((n & 4) != 0) {
            end = $receiver.getPaddingEnd();
        }
        if ((n & 8) != 0) {
            bottom = $receiver.getPaddingBottom();
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setPaddingRelative(start, top, end, bottom);
    }

    public static final void updatePadding(@NotNull View $receiver, @Px int left, @Px int top, @Px int right, @Px int bottom) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setPadding(left, top, right, bottom);
    }

    public static /* bridge */ /* synthetic */ void updatePadding$default(View $receiver, int left, int top, int right, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            left = $receiver.getPaddingLeft();
        }
        if ((n & 2) != 0) {
            top = $receiver.getPaddingTop();
        }
        if ((n & 4) != 0) {
            right = $receiver.getPaddingRight();
        }
        if ((n & 8) != 0) {
            bottom = $receiver.getPaddingBottom();
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setPadding(left, top, right, bottom);
    }

    public static final void setPadding(@NotNull View $receiver, @Px int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setPadding(size, size, size, size);
    }

    @NotNull
    public static final Runnable postDelayed(@NotNull View $receiver, long delayInMillis, @NotNull Function0<Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Runnable runnable2 = new Runnable(action){
            final /* synthetic */ Function0 $action;

            public final void run() {
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        $receiver.postDelayed(runnable2, delayInMillis);
        return runnable2;
    }

    @RequiresApi(value=16)
    @NotNull
    public static final Runnable postOnAnimationDelayed(@NotNull View $receiver, long delayInMillis, @NotNull Function0<Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Runnable runnable2 = new Runnable(action){
            final /* synthetic */ Function0 $action;

            public final void run() {
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        $receiver.postOnAnimationDelayed(runnable2, delayInMillis);
        return runnable2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Bitmap toBitmap(@NotNull View $receiver, @NotNull Bitmap.Config config) {
        void var2_2;
        Canvas c$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        if (!ViewCompat.isLaidOut((View)$receiver)) {
            throw (Throwable)new IllegalStateException("View needs to be laid out before calling toBitmap()");
        }
        Bitmap bitmap = Bitmap.createBitmap((int)$receiver.getWidth(), (int)$receiver.getHeight(), (Bitmap.Config)config);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(width, height, config)");
        Bitmap $receiver$iv = bitmap;
        Canvas $receiver2 = c$iv = new Canvas($receiver$iv);
        $receiver2.translate(-((float)$receiver.getScrollX()), -((float)$receiver.getScrollY()));
        $receiver.draw($receiver2);
        return var2_2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Bitmap toBitmap$default(View view, Bitmap.Config config, int n, Object object) {
        if ((n & 1) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        return ViewKt.toBitmap(view, config);
    }

    public static final boolean isVisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 0;
    }

    public static final void setVisible(@NotNull View $receiver, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setVisibility(value ? 0 : 8);
    }

    public static final boolean isInvisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 4;
    }

    public static final void setInvisible(@NotNull View $receiver, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setVisibility(value ? 4 : 0);
    }

    public static final boolean isGone(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 8;
    }

    public static final void setGone(@NotNull View $receiver, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setVisibility(value ? 8 : 0);
    }

    public static final void updateLayoutParams(@NotNull View $receiver, @NotNull Function1<? super ViewGroup.LayoutParams, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        View $receiver$iv = $receiver;
        ViewGroup.LayoutParams layoutParams = $receiver$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = layoutParams;
        block.invoke((Object)params$iv);
        $receiver$iv.setLayoutParams(params$iv);
    }

    @JvmName(name="updateLayoutParamsTyped")
    private static final <T extends ViewGroup.LayoutParams> void updateLayoutParamsTyped(@NotNull View $receiver, Function1<? super T, Unit> block) {
        ViewGroup.LayoutParams layoutParams = $receiver.getLayoutParams();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        ViewGroup.LayoutParams params = layoutParams;
        block.invoke((Object)params);
        $receiver.setLayoutParams(params);
    }
}

