/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Px;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a2\u0010\b\u001a\u00020\t*\u00020\u00022\b\b\u0003\u0010\n\u001a\u00020\u00042\b\b\u0003\u0010\u000b\u001a\u00020\u00042\b\b\u0003\u0010\f\u001a\u00020\u00042\b\b\u0003\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"toBitmap", "Landroid/graphics/Bitmap;", "Landroid/graphics/drawable/Drawable;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "updateBounds", "", "left", "top", "right", "bottom", "core-ktx_release"})
public final class DrawableKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Bitmap toBitmap(@NotNull Drawable $receiver, @Px int width, @Px int height, @Nullable Bitmap.Config config) {
        void oldRight;
        void oldTop;
        void oldLeft;
        Rect rect;
        block5: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                if (!($receiver instanceof BitmapDrawable)) break block5;
                if (config == null) break block6;
                Bitmap bitmap = ((BitmapDrawable)$receiver).getBitmap();
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bitmap");
                if (bitmap.getConfig() != config) break block5;
            }
            if (width == ((BitmapDrawable)$receiver).getIntrinsicWidth() && height == ((BitmapDrawable)$receiver).getIntrinsicHeight()) {
                Bitmap bitmap = ((BitmapDrawable)$receiver).getBitmap();
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bitmap");
                return bitmap;
            }
            Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)((BitmapDrawable)$receiver).getBitmap(), (int)width, (int)height, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026map, width, height, true)");
            return bitmap;
        }
        Rect $receiver$iv = rect = $receiver.getBounds();
        int n = $receiver$iv.left;
        $receiver$iv = rect;
        int n2 = $receiver$iv.top;
        $receiver$iv = rect;
        int n3 = $receiver$iv.right;
        $receiver$iv = rect;
        int oldBottom = $receiver$iv.bottom;
        Bitmap.Config config2 = config;
        if (config2 == null) {
            config2 = Bitmap.Config.ARGB_8888;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config2);
        $receiver.setBounds(0, 0, width, height);
        $receiver.draw(new Canvas(bitmap));
        $receiver.setBounds((int)oldLeft, (int)oldTop, (int)oldRight, oldBottom);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @NotNull
    public static /* synthetic */ Bitmap toBitmap$default(Drawable drawable, int n, int n2, Bitmap.Config config, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = drawable.getIntrinsicWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = drawable.getIntrinsicHeight();
        }
        if ((n3 & 4) != 0) {
            config = null;
        }
        return DrawableKt.toBitmap(drawable, n, n2, config);
    }

    public static final void updateBounds(@NotNull Drawable $receiver, @Px int left, @Px int top, @Px int right, @Px int bottom) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.setBounds(left, top, right, bottom);
    }

    public static /* synthetic */ void updateBounds$default(Drawable drawable, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = drawable.getBounds().left;
        }
        if ((n5 & 2) != 0) {
            n2 = drawable.getBounds().top;
        }
        if ((n5 & 4) != 0) {
            n3 = drawable.getBounds().right;
        }
        if ((n5 & 8) != 0) {
            n4 = drawable.getBounds().bottom;
        }
        DrawableKt.updateBounds(drawable, n, n2, n3, n4);
    }
}

