/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a=\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"persistableBundleOf", "Landroid/os/PersistableBundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/PersistableBundle;", "core-ktx_release"})
public final class PersistableBundleKt {
    @RequiresApi(value=21)
    @NotNull
    public static final PersistableBundle persistableBundleOf(Pair<String, ? extends Object> ... pairs) {
        PersistableBundle persistableBundle;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        PersistableBundle $receiver = persistableBundle = new PersistableBundle(pairs.length);
        for (Pair<String, ? extends Object> pair : pairs) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $receiver.putString(key, null);
                continue;
            }
            if (object instanceof Boolean) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $receiver.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                throw (Throwable)new IllegalArgumentException("Illegal value type boolean for key \"" + key + '\"');
            }
            if (object instanceof Double) {
                $receiver.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                $receiver.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $receiver.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof String) {
                $receiver.putString(key, (String)value);
                continue;
            }
            if (object instanceof boolean[]) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $receiver.putBooleanArray(key, (boolean[])value);
                    continue;
                }
                throw (Throwable)new IllegalArgumentException("Illegal value type boolean[] for key \"" + key + '\"');
            }
            if (object instanceof double[]) {
                $receiver.putDoubleArray(key, (double[])value);
                continue;
            }
            if (object instanceof int[]) {
                $receiver.putIntArray(key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $receiver.putLongArray(key, (long[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> componentType;
                if (value.getClass().getComponentType() == null) {
                    Intrinsics.throwNpe();
                }
                if (String.class.isAssignableFrom(componentType)) {
                    Object object2 = value;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    $receiver.putStringArray(key, (String[])object2);
                    continue;
                }
                String valueType = componentType.getCanonicalName();
                throw (Throwable)new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + key + '\"');
            }
            String valueType = value.getClass().getCanonicalName();
            throw (Throwable)new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + key + '\"');
        }
        return persistableBundle;
    }
}

