/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Px;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a,\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a2\u0010\t\u001a\u00020\n*\u00020\u00022\b\b\u0003\u0010\u000b\u001a\u00020\u00042\b\b\u0003\u0010\f\u001a\u00020\u00042\b\b\u0003\u0010\r\u001a\u00020\u00042\b\b\u0003\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"toBitmap", "Landroid/graphics/Bitmap;", "Landroid/graphics/drawable/Drawable;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "toBitmapOrNull", "updateBounds", "", "left", "top", "right", "bottom", "core-ktx_release"})
public final class DrawableKt {
    @NotNull
    public static final Bitmap toBitmap(@NotNull Drawable $this$toBitmap, @Px int width, @Px int height, @Nullable Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        if ($this$toBitmap instanceof BitmapDrawable) {
            if (((BitmapDrawable)$this$toBitmap).getBitmap() == null) {
                throw new IllegalArgumentException("bitmap is null");
            }
            if (config == null || ((BitmapDrawable)$this$toBitmap).getBitmap().getConfig() == config) {
                if (width == ((BitmapDrawable)$this$toBitmap).getBitmap().getWidth() && height == ((BitmapDrawable)$this$toBitmap).getBitmap().getHeight()) {
                    Bitmap bitmap = ((BitmapDrawable)$this$toBitmap).getBitmap();
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                    return bitmap;
                }
                Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)((BitmapDrawable)$this$toBitmap).getBitmap(), (int)width, (int)height, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(bitmap, width, height, true)");
                return bitmap;
            }
        }
        Rect rect = $this$toBitmap.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect $this$component1$iv = rect;
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        Bitmap.Config config2 = config;
        if (config2 == null) {
            config2 = Bitmap.Config.ARGB_8888;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config2);
        $this$toBitmap.setBounds(0, 0, width, height);
        $this$toBitmap.draw(new Canvas(bitmap));
        $this$toBitmap.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    public static /* synthetic */ Bitmap toBitmap$default(Drawable drawable, int n, int n2, Bitmap.Config config, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = drawable.getIntrinsicWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = drawable.getIntrinsicHeight();
        }
        if ((n3 & 4) != 0) {
            config = null;
        }
        return DrawableKt.toBitmap(drawable, n, n2, config);
    }

    @Nullable
    public static final Bitmap toBitmapOrNull(@NotNull Drawable $this$toBitmapOrNull, @Px int width, @Px int height, @Nullable Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmapOrNull, (String)"<this>");
        if ($this$toBitmapOrNull instanceof BitmapDrawable && ((BitmapDrawable)$this$toBitmapOrNull).getBitmap() == null) {
            return null;
        }
        return DrawableKt.toBitmap($this$toBitmapOrNull, width, height, config);
    }

    public static /* synthetic */ Bitmap toBitmapOrNull$default(Drawable drawable, int n, int n2, Bitmap.Config config, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = drawable.getIntrinsicWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = drawable.getIntrinsicHeight();
        }
        if ((n3 & 4) != 0) {
            config = null;
        }
        return DrawableKt.toBitmapOrNull(drawable, n, n2, config);
    }

    public static final void updateBounds(@NotNull Drawable $this$updateBounds, @Px int left, @Px int top, @Px int right, @Px int bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$updateBounds, (String)"<this>");
        $this$updateBounds.setBounds(left, top, right, bottom);
    }

    public static /* synthetic */ void updateBounds$default(Drawable drawable, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = drawable.getBounds().left;
        }
        if ((n5 & 2) != 0) {
            n2 = drawable.getBounds().top;
        }
        if ((n5 & 4) != 0) {
            n3 = drawable.getBounds().right;
        }
        if ((n5 & 8) != 0) {
            n4 = drawable.getBounds().bottom;
        }
        DrawableKt.updateBounds(drawable, n, n2, n3, n4);
    }
}

