/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.res.Resources;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.core.util.SizeFCompat;
import androidx.core.widget.AppWidgetManagerApi16Impl;
import androidx.core.widget.AppWidgetManagerApi31Impl;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000eH\u0000\u001a*\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000e\u001a8\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000e\u001a\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0080\u0004\u001a\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010\u0019\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000e\u001a4\u0010\u0019\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"LogTag", "", "area", "", "Landroidx/core/util/SizeFCompat;", "getArea", "(Landroidx/core/util/SizeFCompat;)F", "createAppWidgetFromProviderInfo", "Landroid/widget/RemoteViews;", "appWidgetManager", "Landroid/appwidget/AppWidgetManager;", "appWidgetId", "", "factory", "Lkotlin/Function1;", "createExactSizeAppWidget", "createResponsiveSizeAppWidget", "dpSizes", "", "approxDominates", "", "other", "getSizeFromProviderInfo", "requireValidAppWidgetId", "", "updateAppWidget", "core-remoteviews_release"})
@JvmName(name="AppWidgetManagerCompat")
public final class AppWidgetManagerCompat {
    @NotNull
    private static final String LogTag = "AppWidgetManagerCompat";

    public static final boolean approxDominates(@NotNull SizeFCompat $this$approxDominates, @NotNull SizeFCompat other) {
        Intrinsics.checkNotNullParameter((Object)$this$approxDominates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.ceil($this$approxDominates.getWidth()) + 1.0f >= other.getWidth() && (float)Math.ceil($this$approxDominates.getHeight()) + 1.0f >= other.getHeight();
    }

    public static final float getArea(@NotNull SizeFCompat $this$area) {
        Intrinsics.checkNotNullParameter((Object)$this$area, (String)"<this>");
        return $this$area.getWidth() * $this$area.getHeight();
    }

    public static final void updateAppWidget(@NotNull AppWidgetManager $this$updateAppWidget, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAppWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        $this$updateAppWidget.updateAppWidget(appWidgetId, AppWidgetManagerCompat.createExactSizeAppWidget($this$updateAppWidget, appWidgetId, factory));
    }

    @NotNull
    public static final RemoteViews createExactSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        AppWidgetManagerCompat.requireValidAppWidgetId(appWidgetManager, appWidgetId);
        return Build.VERSION.SDK_INT >= 31 ? AppWidgetManagerApi31Impl.INSTANCE.createExactSizeAppWidget(appWidgetManager, appWidgetId, factory) : (Build.VERSION.SDK_INT >= 16 ? AppWidgetManagerApi16Impl.INSTANCE.createExactSizeAppWidget(appWidgetManager, appWidgetId, factory) : AppWidgetManagerCompat.createAppWidgetFromProviderInfo(appWidgetManager, appWidgetId, factory));
    }

    public static final void updateAppWidget(@NotNull AppWidgetManager $this$updateAppWidget, int appWidgetId, @NotNull Collection<SizeFCompat> dpSizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAppWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter(dpSizes, (String)"dpSizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        $this$updateAppWidget.updateAppWidget(appWidgetId, AppWidgetManagerCompat.createResponsiveSizeAppWidget($this$updateAppWidget, appWidgetId, dpSizes, factory));
    }

    @NotNull
    public static final RemoteViews createResponsiveSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Collection<SizeFCompat> dpSizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(dpSizes, (String)"dpSizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        AppWidgetManagerCompat.requireValidAppWidgetId(appWidgetManager, appWidgetId);
        if (!(!dpSizes.isEmpty())) {
            boolean $i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32 = false;
            String $i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32 = "Sizes cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32.toString());
        }
        if (!(dpSizes.size() <= 16)) {
            boolean bl = false;
            String string = "At most 16 sizes may be provided";
            throw new IllegalArgumentException(string.toString());
        }
        return Build.VERSION.SDK_INT >= 31 ? AppWidgetManagerApi31Impl.INSTANCE.createResponsiveSizeAppWidget(dpSizes, factory) : (Build.VERSION.SDK_INT >= 16 ? AppWidgetManagerApi16Impl.INSTANCE.createResponsiveSizeAppWidget(appWidgetManager, appWidgetId, dpSizes, factory) : AppWidgetManagerCompat.createAppWidgetFromProviderInfo(appWidgetManager, appWidgetId, factory));
    }

    private static final void requireValidAppWidgetId(AppWidgetManager $this$requireValidAppWidgetId, int appWidgetId) {
        if ($this$requireValidAppWidgetId.getAppWidgetInfo(appWidgetId) == null) {
            boolean bl = false;
            String string = "Invalid app widget id: " + appWidgetId;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final RemoteViews createAppWidgetFromProviderInfo(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        return (RemoteViews)factory.invoke((Object)AppWidgetManagerCompat.getSizeFromProviderInfo(appWidgetManager, appWidgetId));
    }

    @NotNull
    public static final SizeFCompat getSizeFromProviderInfo(@NotNull AppWidgetManager $this$getSizeFromProviderInfo, int appWidgetId) {
        Intrinsics.checkNotNullParameter((Object)$this$getSizeFromProviderInfo, (String)"<this>");
        AppWidgetProviderInfo providerInfo = $this$getSizeFromProviderInfo.getAppWidgetInfo(appWidgetId);
        float width = AppWidgetManagerCompat.getSizeFromProviderInfo$pxToDp(providerInfo.minWidth);
        float height = AppWidgetManagerCompat.getSizeFromProviderInfo$pxToDp(providerInfo.minHeight);
        return new SizeFCompat(width, height);
    }

    private static final float getSizeFromProviderInfo$pxToDp(int value) {
        return (float)value / Resources.getSystem().getDisplayMetrics().density;
    }
}

