/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.splashscreen;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.window.SplashScreenView;
import androidx.annotation.RequiresApi;
import androidx.core.splashscreen.R;
import androidx.core.splashscreen.ThemeUtils;
import java.time.Duration;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0017\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001a"}, d2={"Landroidx/core/splashscreen/SplashScreenViewProvider;", "", "platformView", "Landroid/window/SplashScreenView;", "ctx", "Landroid/app/Activity;", "(Landroid/window/SplashScreenView;Landroid/app/Activity;)V", "(Landroid/app/Activity;)V", "iconAnimationDurationMillis", "", "getIconAnimationDurationMillis", "()J", "iconAnimationStartMillis", "getIconAnimationStartMillis", "iconView", "Landroid/view/View;", "getIconView", "()Landroid/view/View;", "impl", "Landroidx/core/splashscreen/SplashScreenViewProvider$ViewImpl;", "view", "getView", "remove", "", "ViewImpl", "ViewImpl31", "core-splashscreen_release"})
@SuppressLint(value={"ViewConstructor"})
public final class SplashScreenViewProvider {
    @NotNull
    private final ViewImpl impl;

    /*
     * WARNING - void declaration
     */
    public SplashScreenViewProvider(@NotNull Activity ctx) {
        void $this$impl_u24lambda_u2d0;
        ViewImpl viewImpl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ViewImpl viewImpl2 = viewImpl = Build.VERSION.SDK_INT >= 31 ? (ViewImpl)new ViewImpl31(ctx) : new ViewImpl(ctx);
        SplashScreenViewProvider splashScreenViewProvider = this;
        boolean bl = false;
        $this$impl_u24lambda_u2d0.createSplashScreenView();
        splashScreenViewProvider.impl = viewImpl;
    }

    @RequiresApi(value=31)
    public SplashScreenViewProvider(@NotNull SplashScreenView platformView, @NotNull Activity ctx) {
        Intrinsics.checkNotNullParameter((Object)platformView, (String)"platformView");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this(ctx);
        ((ViewImpl31)this.impl).setPlatformView(platformView);
    }

    @NotNull
    public final View getView() {
        return (View)this.impl.getSplashScreenView();
    }

    @NotNull
    public final View getIconView() {
        return this.impl.getIconView();
    }

    public final long getIconAnimationStartMillis() {
        return this.impl.getIconAnimationStartMillis();
    }

    public final long getIconAnimationDurationMillis() {
        return this.impl.getIconAnimationDurationMillis();
    }

    public final void remove() {
        this.impl.remove();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u001c"}, d2={"Landroidx/core/splashscreen/SplashScreenViewProvider$ViewImpl;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "_splashScreenView", "Landroid/view/ViewGroup;", "get_splashScreenView", "()Landroid/view/ViewGroup;", "_splashScreenView$delegate", "Lkotlin/Lazy;", "getActivity", "()Landroid/app/Activity;", "iconAnimationDurationMillis", "", "getIconAnimationDurationMillis", "()J", "iconAnimationStartMillis", "getIconAnimationStartMillis", "iconView", "Landroid/view/View;", "getIconView", "()Landroid/view/View;", "splashScreenView", "getSplashScreenView", "createSplashScreenView", "", "remove", "core-splashscreen_release"})
    private static class ViewImpl {
        @NotNull
        private final Activity activity;
        @NotNull
        private final Lazy _splashScreenView$delegate;

        public ViewImpl(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this._splashScreenView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ViewGroup>(this){
                final /* synthetic */ ViewImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewGroup invoke() {
                    View view = FrameLayout.inflate((Context)((Context)this.this$0.getActivity()), (int)R.layout.splash_screen_view, null);
                    if (view == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    return (ViewGroup)view;
                }
            }));
        }

        @NotNull
        public final Activity getActivity() {
            return this.activity;
        }

        private final ViewGroup get_splashScreenView() {
            Lazy lazy = this._splashScreenView$delegate;
            return (ViewGroup)lazy.getValue();
        }

        public void createSplashScreenView() {
            block0: {
                ViewGroup content = (ViewGroup)this.activity.findViewById(0x1020002);
                View view = content.getRootView();
                ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
                if (viewGroup == null) break block0;
                viewGroup.addView((View)this.get_splashScreenView());
            }
        }

        @NotNull
        public ViewGroup getSplashScreenView() {
            return this.get_splashScreenView();
        }

        @NotNull
        public View getIconView() {
            View view = this.getSplashScreenView().findViewById(R.id.splashscreen_icon_view);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"splashScreenView.findVie\u2026d.splashscreen_icon_view)");
            return view;
        }

        public long getIconAnimationStartMillis() {
            return 0L;
        }

        public long getIconAnimationDurationMillis() {
            return 0L;
        }

        public void remove() {
            block0: {
                ViewParent viewParent = this.getSplashScreenView().getParent();
                ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
                if (viewGroup == null) break block0;
                viewGroup.removeView((View)this.getSplashScreenView());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001a"}, d2={"Landroidx/core/splashscreen/SplashScreenViewProvider$ViewImpl31;", "Landroidx/core/splashscreen/SplashScreenViewProvider$ViewImpl;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "iconAnimationDurationMillis", "", "getIconAnimationDurationMillis", "()J", "iconAnimationStartMillis", "getIconAnimationStartMillis", "iconView", "Landroid/view/View;", "getIconView", "()Landroid/view/View;", "platformView", "Landroid/window/SplashScreenView;", "getPlatformView", "()Landroid/window/SplashScreenView;", "setPlatformView", "(Landroid/window/SplashScreenView;)V", "splashScreenView", "getSplashScreenView", "createSplashScreenView", "", "remove", "core-splashscreen_release"})
    @RequiresApi(value=31)
    private static final class ViewImpl31
    extends ViewImpl {
        public SplashScreenView platformView;

        public ViewImpl31(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            super(activity);
        }

        @NotNull
        public final SplashScreenView getPlatformView() {
            SplashScreenView splashScreenView = this.platformView;
            if (splashScreenView != null) {
                return splashScreenView;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformView");
            return null;
        }

        public final void setPlatformView(@NotNull SplashScreenView splashScreenView) {
            Intrinsics.checkNotNullParameter((Object)splashScreenView, (String)"<set-?>");
            this.platformView = splashScreenView;
        }

        @Override
        public void createSplashScreenView() {
        }

        @NotNull
        public SplashScreenView getSplashScreenView() {
            return this.getPlatformView();
        }

        @Override
        @NotNull
        public View getIconView() {
            View view;
            if (this.getPlatformView().getIconView() != null) {
                View view2 = this.getPlatformView().getIconView();
                view = view2;
                Intrinsics.checkNotNull((Object)view2);
            } else {
                view = new View((Context)this.getActivity());
            }
            return view;
        }

        @Override
        public long getIconAnimationStartMillis() {
            Instant instant = this.getPlatformView().getIconAnimationStart();
            return instant != null ? instant.toEpochMilli() : 0L;
        }

        @Override
        public long getIconAnimationDurationMillis() {
            Duration duration = this.getPlatformView().getIconAnimationDuration();
            return duration != null ? duration.toMillis() : 0L;
        }

        @Override
        public void remove() {
            this.getPlatformView().remove();
            Resources.Theme theme = this.getActivity().getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"activity.theme");
            View view = this.getActivity().getWindow().getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            ThemeUtils.Api31.applyThemesSystemBarAppearance$default(theme, view, null, 4, null);
        }
    }
}

