/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.NonNullableMutableLiveDataDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.kotlin.KotlinUField;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001e\u0018\u00010\u0005H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "methods", "", "", "getMethods", "()Ljava/util/List;", "typesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lkotlin/collections/HashMap;", "getTypesMap", "()Ljava/util/HashMap;", "checkNullability", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "message", "fixes", "Lcom/android/tools/lint/detector/api/LintFix;", "liveDataType", "node", "Lorg/jetbrains/uast/UCallExpression;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "getTypeArg", "classType", "Lcom/intellij/psi/PsiClassType;", "Companion", "lifecycle-livedata-core-ktx-lint"})
public final class NonNullableMutableLiveDataDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    private final HashMap<String, KtTypeReference> typesMap = new HashMap();
    @NotNull
    private final List<String> methods = CollectionsKt.listOf((Object[])new String[]{"setValue", "postValue"});
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final HashMap<String, KtTypeReference> getTypesMap() {
        return this.typesMap;
    }

    @NotNull
    public final List<String> getMethods() {
        return this.methods;
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UCallExpression.class, UClass.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ NonNullableMutableLiveDataDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitClass(@NotNull UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UDeclaration element : node.getUastDeclarations()) {
                    KtTypeReference ktTypeReference;
                    if (!(element instanceof KotlinUField)) continue;
                    if (this.getFieldTypeReference((KotlinUField)element) == null) continue;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtTypeReference it = ktTypeReference;
                    boolean bl3 = false;
                    this.this$0.getTypesMap().put(((KotlinUField)element).getName(), it);
                }
            }

            private final KtTypeReference getFieldTypeReference(KotlinUField element) {
                KtCallExpression expression;
                Object object;
                KtTypeProjection argument;
                PsiElement psiElement;
                PsiElement[] psiElementArray = element.getSourcePsi();
                if (!((psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null ? psiElementArray[0] : (psiElement = null)) instanceof KtCallExpression)) {
                    psiElement = null;
                }
                KtTypeProjection ktTypeProjection = argument = (object = (expression = (KtCallExpression)psiElement)) != null && (object = object.getTypeArguments()) != null ? (KtTypeProjection)CollectionsKt.singleOrNull((List)object) : null;
                return ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                KtTypeReference liveDataType;
                Object object;
                PsiClassType receiverType;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!Lint.isKotlin((PsiElement)node.getSourcePsi()) || !CollectionsKt.contains((Iterable)this.this$0.getMethods(), (Object)node.getMethodName())) break block13;
                        JavaEvaluator javaEvaluator = this.$context.getEvaluator();
                        PsiMethod psiMethod = node.resolve();
                        Intrinsics.checkNotNull((Object)psiMethod);
                        if (javaEvaluator.isMemberInSubClassOf((PsiMember)psiMethod, "androidx.lifecycle.LiveData", false)) break block14;
                    }
                    return;
                }
                PsiType psiType = node.getReceiverType();
                if (!(psiType instanceof PsiClassType)) {
                    psiType = null;
                }
                if ((receiverType = (PsiClassType)psiType) != null && receiverType.hasParameters()) {
                    KtCallExpression constructorExpression;
                    Object object2;
                    UExpression assignment;
                    UExpression uExpression;
                    PsiVariable variable;
                    UExpression uExpression2 = node.getReceiver();
                    if (!(uExpression2 instanceof KotlinUSimpleReferenceExpression)) {
                        uExpression2 = null;
                    }
                    KotlinUSimpleReferenceExpression kotlinUSimpleReferenceExpression = (KotlinUSimpleReferenceExpression)uExpression2;
                    Object receiver = kotlinUSimpleReferenceExpression != null ? kotlinUSimpleReferenceExpression.resolve() : null;
                    PsiElement psiElement = receiver;
                    if (!(psiElement instanceof PsiVariable)) {
                        psiElement = null;
                    }
                    PsiVariable psiVariable = variable = (PsiVariable)psiElement;
                    if (psiVariable != null) {
                        PsiVariable psiVariable2 = psiVariable;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiVariable it = psiVariable2;
                        boolean bl3 = false;
                        uExpression = UastLintUtils.findLastAssignment((PsiVariable)it, (UElement)((UElement)node));
                    } else {
                        uExpression = null;
                    }
                    UExpression uExpression3 = assignment = uExpression;
                    Object object3 = uExpression3 != null ? uExpression3.getSourcePsi() : null;
                    if (!(object3 instanceof KtCallExpression)) {
                        object3 = null;
                    }
                    object = (object2 = (constructorExpression = (KtCallExpression)object3)) != null && (object2 = object2.getTypeArguments()) != null && (object2 = (KtTypeProjection)CollectionsKt.singleOrNull((List)object2)) != null ? object2.getTypeReference() : null;
                } else {
                    object = liveDataType = this.this$0.getTypeArg(receiverType);
                }
                if (liveDataType == null) {
                    Map map = this.this$0.getTypesMap();
                    String string = this.getVariableName(node);
                    boolean bl = false;
                    KtTypeReference ktTypeReference = (KtTypeReference)map.get(string);
                    if (ktTypeReference == null) {
                        return;
                    }
                    liveDataType = ktTypeReference;
                }
                this.this$0.checkNullability(liveDataType, this.$context, node);
            }

            private final String getVariableName(UCallExpression node) {
                PsiElement variable;
                PsiElement psiElement = node.getSourcePsi();
                Object dot = psiElement != null ? psiElement.getPrevSibling() : null;
                PsiElement psiElement2 = dot;
                PsiElement psiElement3 = variable = psiElement2 != null && (psiElement2 = psiElement2.getPrevSibling()) != null ? psiElement2.getFirstChild() : null;
                return psiElement3 != null ? psiElement3.getText() : null;
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public final KtTypeReference getTypeArg(@Nullable PsiClassType classType) {
        UClass cls;
        if (classType == null) {
            return null;
        }
        PsiElement $receiver$iv = (PsiElement)classType.resolve();
        boolean strict$iv = false;
        UClass uClass = cls = (UClass)UastContextKt.getUastParentOfType((PsiElement)$receiver$iv, UClass.class, (boolean)strict$iv);
        Object object = uClass != null ? uClass.getSuperClassType() : null;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        }
        PsiClassType parentPsiType = (PsiClassType)object;
        if (parentPsiType.hasParameters()) {
            KtTypeElement superType;
            UTypeReferenceExpression parentTypeReference = (UTypeReferenceExpression)cls.getUastSuperTypes().get(0);
            PsiElement psiElement = parentTypeReference.getSourcePsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeElement ktTypeElement = superType = ((KtTypeReference)psiElement).getTypeElement();
            Intrinsics.checkNotNull((Object)ktTypeElement);
            return (KtTypeReference)ktTypeElement.getTypeArgumentsAsTypes().get(0);
        }
        return this.getTypeArg(parentPsiType);
    }

    public final void checkNullability(@NotNull KtTypeReference liveDataType, @NotNull JavaContext context, @NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)liveDataType, (String)"liveDataType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(liveDataType.getTypeElement() instanceof KtNullableType)) {
            UExpression argument;
            boolean bl = false;
            List fixes = new ArrayList();
            if (Intrinsics.areEqual((Object)context.getLocation((PsiElement)liveDataType).getFile(), (Object)context.file)) {
                LintFix lintFix = this.fix().name("Change `LiveData` type to nullable").replace().with("?").range(context.getLocation((PsiElement)liveDataType)).end().build();
                Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"fix().name(\"Change `Live\u2026eDataType)).end().build()");
                fixes.add(lintFix);
            }
            if (UastLiteralUtils.isNullLiteral((UElement)((UElement)(argument = (UExpression)node.getValueArguments().get(0))))) {
                this.checkNullability(context, (UElement)argument, "Cannot set non-nullable LiveData value to `null`", fixes);
            } else if (NonNullableMutableLiveDataDetectorKt.isNullable((UElement)argument)) {
                LintFix lintFix = this.fix().name("Add non-null asserted (!!) call").replace().with("!!").range(context.getLocation((UElement)argument)).end().build();
                Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"fix().name(\"Add non-null\u2026(argument)).end().build()");
                fixes.add(lintFix);
                this.checkNullability(context, (UElement)argument, "Expected non-nullable value", fixes);
            }
        }
    }

    private final void checkNullability(JavaContext context, UElement element, String message, List<? extends LintFix> fixes) {
        if (fixes.isEmpty()) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation(element), (String)message, null, (int)8, null);
        } else {
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            if (lintFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            context.report(ISSUE, context.getLocation(element), message, this.fix().alternatives(Arrays.copyOf(lintFixArray, lintFixArray.length)));
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = true;
        boolean bl2 = false;
        Implementation implementation = new Implementation(NonNullableMutableLiveDataDetector.class, Scope.JAVA_FILE_SCOPE);
        int n = 0;
        Severity severity = Severity.FATAL;
        String string = null;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NullSafeMutableLiveData", (String)"LiveData value assignment nullability mismatch", (String)"This check ensures that LiveData values are not null when explicitly \\\n                declared as non-nullable.\n\n                Kotlin interoperability does not support enforcing explicit null-safety when using \\\n                generic Java type parameters. Since LiveData is a Java class its value can always \\\n                be null even when its type is explicitly declared as non-nullable. This can lead \\\n                to runtime exceptions from reading a null LiveData value that is assumed to be \\\n                non-nullable.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, (Boolean)bl, enumSet, collection, (int)3408, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-livedata-core-ktx-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

