/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.testing.lint;

import androidx.compose.lint.PsiUtilsKt;
import androidx.lifecycle.testing.lint.TestLifecycleOwnerInCoroutineDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Landroidx/lifecycle/testing/lint/TestLifecycleOwnerInCoroutineDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "isLifecycleState", "", "state", "isLifecycleState$lifecycle_runtime_testing_lint", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lifecycle-runtime-testing-lint"})
public final class TestLifecycleOwnerInCoroutineDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)TestLifecycleOwnerInCoroutineDetectorKt.access$getRunTest$p().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!PsiUtilsKt.isInPackageName(method, TestLifecycleOwnerInCoroutineDetectorKt.access$getRunTestPackageName$p())) {
                return;
            }
            Iterable iterable = node.getValueArguments();
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"testBody")) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        if (uExpression == null) {
            return;
        }
        UExpression testBody = uExpression;
        Ref.BooleanRef setsCurrentState = new Ref.BooleanRef();
        testBody.accept((UastVisitor)new AbstractUastVisitor(setsCurrentState, this){
            final /* synthetic */ Ref.BooleanRef $setsCurrentState;
            final /* synthetic */ TestLifecycleOwnerInCoroutineDetector this$0;
            {
                this.$setsCurrentState = $setsCurrentState;
                this.this$0 = $receiver;
            }

            /*
             * Unable to fully structure code
             */
            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                var4_2 = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
                v0 = var4_2 instanceof PsiField != false ? (PsiField)var4_2 : null;
                if (v0 == null) {
                    return false;
                }
                resolvedLeft = v0;
                var5_4 = UastUtils.tryResolve((UElement)((UElement)node.getRightOperand()));
                v1 = var5_4 instanceof PsiField != false ? (PsiField)var5_4 : null;
                if (v1 == null) {
                    return false;
                }
                resolvedRight = v1;
                if (!Intrinsics.areEqual((Object)resolvedLeft.getName(), (Object)TestLifecycleOwnerInCoroutineDetectorKt.access$getCurrentState$p().getShortName())) ** GOTO lbl-1000
                v2 = resolvedRight.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolvedRight.name");
                if (this.this$0.isLifecycleState$lifecycle_runtime_testing_lint(v2)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                this.$setsCurrentState.element = v3;
                return this.$setsCurrentState.element;
            }
        });
        if (setsCurrentState.element) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Incorrect use of currentState property inside of Coroutine, please use the suspending setCurrentState() function.", null, (int)16, null);
        }
    }

    public final boolean isLifecycleState$lifecycle_runtime_testing_lint(@NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object[] objectArray = new String[]{"INITIALIZED", "DESTROYED", "CREATED", "STARTED", "RESUMED"};
        return CollectionsKt.listOf((Object[])objectArray).contains(state);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(TestLifecycleOwnerInCoroutineDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"TestLifecycleOwnerInCoroutine", (String)"Use the suspending function setCurrentState(), rather than directly accessing the currentState property.", (String)"When using TestLifecycleOwner, one of the main use cases is to change \\\n                the currentState property. Under the hood, we do this using runBlocking to keep \\\n                it thread-safe. However, when using TestLifecycleOwner from the context of a \\\n                coroutine (like runTest), this will cause the setter to hang, since coroutines \\\n                should remain asynchronous.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/testing/lint/TestLifecycleOwnerInCoroutineDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-runtime-testing-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

