/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.Metadata;
import androidx.media3.common.Rating;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Objects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;

public final class MediaMetadata
implements Bundleable {
    @UnstableApi
    public static final int MEDIA_TYPE_MIXED = 0;
    @UnstableApi
    public static final int MEDIA_TYPE_MUSIC = 1;
    @UnstableApi
    public static final int MEDIA_TYPE_AUDIO_BOOK_CHAPTER = 2;
    @UnstableApi
    public static final int MEDIA_TYPE_PODCAST_EPISODE = 3;
    @UnstableApi
    public static final int MEDIA_TYPE_RADIO_STATION = 4;
    @UnstableApi
    public static final int MEDIA_TYPE_NEWS = 5;
    @UnstableApi
    public static final int MEDIA_TYPE_VIDEO = 6;
    @UnstableApi
    public static final int MEDIA_TYPE_TRAILER = 7;
    @UnstableApi
    public static final int MEDIA_TYPE_MOVIE = 8;
    @UnstableApi
    public static final int MEDIA_TYPE_TV_SHOW = 9;
    @UnstableApi
    public static final int MEDIA_TYPE_ALBUM = 10;
    @UnstableApi
    public static final int MEDIA_TYPE_ARTIST = 11;
    @UnstableApi
    public static final int MEDIA_TYPE_GENRE = 12;
    @UnstableApi
    public static final int MEDIA_TYPE_PLAYLIST = 13;
    @UnstableApi
    public static final int MEDIA_TYPE_YEAR = 14;
    @UnstableApi
    public static final int MEDIA_TYPE_AUDIO_BOOK = 15;
    @UnstableApi
    public static final int MEDIA_TYPE_PODCAST = 16;
    @UnstableApi
    public static final int MEDIA_TYPE_TV_CHANNEL = 17;
    @UnstableApi
    public static final int MEDIA_TYPE_TV_SERIES = 18;
    @UnstableApi
    public static final int MEDIA_TYPE_TV_SEASON = 19;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_MIXED = 20;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_ALBUMS = 21;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_ARTISTS = 22;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_GENRES = 23;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_PLAYLISTS = 24;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_YEARS = 25;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_AUDIO_BOOKS = 26;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_PODCASTS = 27;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_TV_CHANNELS = 28;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_TV_SERIES = 29;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_TV_SHOWS = 30;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_RADIO_STATIONS = 31;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_NEWS = 32;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_VIDEOS = 33;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_TRAILERS = 34;
    @UnstableApi
    public static final int MEDIA_TYPE_FOLDER_MOVIES = 35;
    public static final int FOLDER_TYPE_NONE = -1;
    public static final int FOLDER_TYPE_MIXED = 0;
    public static final int FOLDER_TYPE_TITLES = 1;
    public static final int FOLDER_TYPE_ALBUMS = 2;
    public static final int FOLDER_TYPE_ARTISTS = 3;
    public static final int FOLDER_TYPE_GENRES = 4;
    public static final int FOLDER_TYPE_PLAYLISTS = 5;
    public static final int FOLDER_TYPE_YEARS = 6;
    public static final int PICTURE_TYPE_OTHER = 0;
    public static final int PICTURE_TYPE_FILE_ICON = 1;
    public static final int PICTURE_TYPE_FILE_ICON_OTHER = 2;
    public static final int PICTURE_TYPE_FRONT_COVER = 3;
    public static final int PICTURE_TYPE_BACK_COVER = 4;
    public static final int PICTURE_TYPE_LEAFLET_PAGE = 5;
    public static final int PICTURE_TYPE_MEDIA = 6;
    public static final int PICTURE_TYPE_LEAD_ARTIST_PERFORMER = 7;
    public static final int PICTURE_TYPE_ARTIST_PERFORMER = 8;
    public static final int PICTURE_TYPE_CONDUCTOR = 9;
    public static final int PICTURE_TYPE_BAND_ORCHESTRA = 10;
    public static final int PICTURE_TYPE_COMPOSER = 11;
    public static final int PICTURE_TYPE_LYRICIST = 12;
    public static final int PICTURE_TYPE_RECORDING_LOCATION = 13;
    public static final int PICTURE_TYPE_DURING_RECORDING = 14;
    public static final int PICTURE_TYPE_DURING_PERFORMANCE = 15;
    public static final int PICTURE_TYPE_MOVIE_VIDEO_SCREEN_CAPTURE = 16;
    public static final int PICTURE_TYPE_A_BRIGHT_COLORED_FISH = 17;
    public static final int PICTURE_TYPE_ILLUSTRATION = 18;
    public static final int PICTURE_TYPE_BAND_ARTIST_LOGO = 19;
    public static final int PICTURE_TYPE_PUBLISHER_STUDIO_LOGO = 20;
    public static final MediaMetadata EMPTY = new Builder().build();
    @Nullable
    public final CharSequence title;
    @Nullable
    public final CharSequence artist;
    @Nullable
    public final CharSequence albumTitle;
    @Nullable
    public final CharSequence albumArtist;
    @Nullable
    public final CharSequence displayTitle;
    @Nullable
    public final CharSequence subtitle;
    @Nullable
    public final CharSequence description;
    @Nullable
    public final Rating userRating;
    @Nullable
    public final Rating overallRating;
    @Nullable
    public final byte[] artworkData;
    @Nullable
    public final Integer artworkDataType;
    @Nullable
    public final Uri artworkUri;
    @Nullable
    public final Integer trackNumber;
    @Nullable
    public final Integer totalTrackCount;
    @Nullable
    public final Integer folderType;
    @UnstableApi
    @Nullable
    public final Boolean isBrowsable;
    @Nullable
    public final Boolean isPlayable;
    @Deprecated
    @UnstableApi
    @Nullable
    public final Integer year;
    @Nullable
    public final Integer recordingYear;
    @Nullable
    public final Integer recordingMonth;
    @Nullable
    public final Integer recordingDay;
    @Nullable
    public final Integer releaseYear;
    @Nullable
    public final Integer releaseMonth;
    @Nullable
    public final Integer releaseDay;
    @Nullable
    public final CharSequence writer;
    @Nullable
    public final CharSequence composer;
    @Nullable
    public final CharSequence conductor;
    @Nullable
    public final Integer discNumber;
    @Nullable
    public final Integer totalDiscCount;
    @Nullable
    public final CharSequence genre;
    @Nullable
    public final CharSequence compilation;
    @Nullable
    public final CharSequence station;
    @UnstableApi
    @Nullable
    public final Integer mediaType;
    @Nullable
    public final Bundle extras;
    private static final String FIELD_TITLE = Util.intToStringMaxRadix(0);
    private static final String FIELD_ARTIST = Util.intToStringMaxRadix(1);
    private static final String FIELD_ALBUM_TITLE = Util.intToStringMaxRadix(2);
    private static final String FIELD_ALBUM_ARTIST = Util.intToStringMaxRadix(3);
    private static final String FIELD_DISPLAY_TITLE = Util.intToStringMaxRadix(4);
    private static final String FIELD_SUBTITLE = Util.intToStringMaxRadix(5);
    private static final String FIELD_DESCRIPTION = Util.intToStringMaxRadix(6);
    private static final String FIELD_USER_RATING = Util.intToStringMaxRadix(8);
    private static final String FIELD_OVERALL_RATING = Util.intToStringMaxRadix(9);
    private static final String FIELD_ARTWORK_DATA = Util.intToStringMaxRadix(10);
    private static final String FIELD_ARTWORK_URI = Util.intToStringMaxRadix(11);
    private static final String FIELD_TRACK_NUMBER = Util.intToStringMaxRadix(12);
    private static final String FIELD_TOTAL_TRACK_COUNT = Util.intToStringMaxRadix(13);
    private static final String FIELD_FOLDER_TYPE = Util.intToStringMaxRadix(14);
    private static final String FIELD_IS_PLAYABLE = Util.intToStringMaxRadix(15);
    private static final String FIELD_RECORDING_YEAR = Util.intToStringMaxRadix(16);
    private static final String FIELD_RECORDING_MONTH = Util.intToStringMaxRadix(17);
    private static final String FIELD_RECORDING_DAY = Util.intToStringMaxRadix(18);
    private static final String FIELD_RELEASE_YEAR = Util.intToStringMaxRadix(19);
    private static final String FIELD_RELEASE_MONTH = Util.intToStringMaxRadix(20);
    private static final String FIELD_RELEASE_DAY = Util.intToStringMaxRadix(21);
    private static final String FIELD_WRITER = Util.intToStringMaxRadix(22);
    private static final String FIELD_COMPOSER = Util.intToStringMaxRadix(23);
    private static final String FIELD_CONDUCTOR = Util.intToStringMaxRadix(24);
    private static final String FIELD_DISC_NUMBER = Util.intToStringMaxRadix(25);
    private static final String FIELD_TOTAL_DISC_COUNT = Util.intToStringMaxRadix(26);
    private static final String FIELD_GENRE = Util.intToStringMaxRadix(27);
    private static final String FIELD_COMPILATION = Util.intToStringMaxRadix(28);
    private static final String FIELD_ARTWORK_DATA_TYPE = Util.intToStringMaxRadix(29);
    private static final String FIELD_STATION = Util.intToStringMaxRadix(30);
    private static final String FIELD_MEDIA_TYPE = Util.intToStringMaxRadix(31);
    private static final String FIELD_IS_BROWSABLE = Util.intToStringMaxRadix(32);
    private static final String FIELD_EXTRAS = Util.intToStringMaxRadix(1000);
    @UnstableApi
    public static final Bundleable.Creator<MediaMetadata> CREATOR = MediaMetadata::fromBundle;

    private MediaMetadata(Builder builder) {
        Boolean isBrowsable = builder.isBrowsable;
        Integer folderType = builder.folderType;
        Integer mediaType = builder.mediaType;
        if (isBrowsable != null) {
            if (!isBrowsable.booleanValue()) {
                folderType = -1;
            } else if (folderType == null || folderType == -1) {
                folderType = mediaType != null ? MediaMetadata.getFolderTypeFromMediaType(mediaType) : 0;
            }
        } else if (folderType != null && (isBrowsable = Boolean.valueOf(folderType != -1)).booleanValue() && mediaType == null) {
            mediaType = MediaMetadata.getMediaTypeFromFolderType(folderType);
        }
        this.title = builder.title;
        this.artist = builder.artist;
        this.albumTitle = builder.albumTitle;
        this.albumArtist = builder.albumArtist;
        this.displayTitle = builder.displayTitle;
        this.subtitle = builder.subtitle;
        this.description = builder.description;
        this.userRating = builder.userRating;
        this.overallRating = builder.overallRating;
        this.artworkData = builder.artworkData;
        this.artworkDataType = builder.artworkDataType;
        this.artworkUri = builder.artworkUri;
        this.trackNumber = builder.trackNumber;
        this.totalTrackCount = builder.totalTrackCount;
        this.folderType = folderType;
        this.isBrowsable = isBrowsable;
        this.isPlayable = builder.isPlayable;
        this.year = builder.recordingYear;
        this.recordingYear = builder.recordingYear;
        this.recordingMonth = builder.recordingMonth;
        this.recordingDay = builder.recordingDay;
        this.releaseYear = builder.releaseYear;
        this.releaseMonth = builder.releaseMonth;
        this.releaseDay = builder.releaseDay;
        this.writer = builder.writer;
        this.composer = builder.composer;
        this.conductor = builder.conductor;
        this.discNumber = builder.discNumber;
        this.totalDiscCount = builder.totalDiscCount;
        this.genre = builder.genre;
        this.compilation = builder.compilation;
        this.station = builder.station;
        this.mediaType = mediaType;
        this.extras = builder.extras;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaMetadata that = (MediaMetadata)obj;
        return Util.areEqual(this.title, that.title) && Util.areEqual(this.artist, that.artist) && Util.areEqual(this.albumTitle, that.albumTitle) && Util.areEqual(this.albumArtist, that.albumArtist) && Util.areEqual(this.displayTitle, that.displayTitle) && Util.areEqual(this.subtitle, that.subtitle) && Util.areEqual(this.description, that.description) && Util.areEqual(this.userRating, that.userRating) && Util.areEqual(this.overallRating, that.overallRating) && Arrays.equals(this.artworkData, that.artworkData) && Util.areEqual(this.artworkDataType, that.artworkDataType) && Util.areEqual(this.artworkUri, that.artworkUri) && Util.areEqual(this.trackNumber, that.trackNumber) && Util.areEqual(this.totalTrackCount, that.totalTrackCount) && Util.areEqual(this.folderType, that.folderType) && Util.areEqual(this.isBrowsable, that.isBrowsable) && Util.areEqual(this.isPlayable, that.isPlayable) && Util.areEqual(this.recordingYear, that.recordingYear) && Util.areEqual(this.recordingMonth, that.recordingMonth) && Util.areEqual(this.recordingDay, that.recordingDay) && Util.areEqual(this.releaseYear, that.releaseYear) && Util.areEqual(this.releaseMonth, that.releaseMonth) && Util.areEqual(this.releaseDay, that.releaseDay) && Util.areEqual(this.writer, that.writer) && Util.areEqual(this.composer, that.composer) && Util.areEqual(this.conductor, that.conductor) && Util.areEqual(this.discNumber, that.discNumber) && Util.areEqual(this.totalDiscCount, that.totalDiscCount) && Util.areEqual(this.genre, that.genre) && Util.areEqual(this.compilation, that.compilation) && Util.areEqual(this.station, that.station) && Util.areEqual(this.mediaType, that.mediaType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.artist, this.albumTitle, this.albumArtist, this.displayTitle, this.subtitle, this.description, this.userRating, this.overallRating, Arrays.hashCode(this.artworkData), this.artworkDataType, this.artworkUri, this.trackNumber, this.totalTrackCount, this.folderType, this.isBrowsable, this.isPlayable, this.recordingYear, this.recordingMonth, this.recordingDay, this.releaseYear, this.releaseMonth, this.releaseDay, this.writer, this.composer, this.conductor, this.discNumber, this.totalDiscCount, this.genre, this.compilation, this.station, this.mediaType});
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.title != null) {
            bundle.putCharSequence(FIELD_TITLE, this.title);
        }
        if (this.artist != null) {
            bundle.putCharSequence(FIELD_ARTIST, this.artist);
        }
        if (this.albumTitle != null) {
            bundle.putCharSequence(FIELD_ALBUM_TITLE, this.albumTitle);
        }
        if (this.albumArtist != null) {
            bundle.putCharSequence(FIELD_ALBUM_ARTIST, this.albumArtist);
        }
        if (this.displayTitle != null) {
            bundle.putCharSequence(FIELD_DISPLAY_TITLE, this.displayTitle);
        }
        if (this.subtitle != null) {
            bundle.putCharSequence(FIELD_SUBTITLE, this.subtitle);
        }
        if (this.description != null) {
            bundle.putCharSequence(FIELD_DESCRIPTION, this.description);
        }
        if (this.artworkData != null) {
            bundle.putByteArray(FIELD_ARTWORK_DATA, this.artworkData);
        }
        if (this.artworkUri != null) {
            bundle.putParcelable(FIELD_ARTWORK_URI, (Parcelable)this.artworkUri);
        }
        if (this.writer != null) {
            bundle.putCharSequence(FIELD_WRITER, this.writer);
        }
        if (this.composer != null) {
            bundle.putCharSequence(FIELD_COMPOSER, this.composer);
        }
        if (this.conductor != null) {
            bundle.putCharSequence(FIELD_CONDUCTOR, this.conductor);
        }
        if (this.genre != null) {
            bundle.putCharSequence(FIELD_GENRE, this.genre);
        }
        if (this.compilation != null) {
            bundle.putCharSequence(FIELD_COMPILATION, this.compilation);
        }
        if (this.station != null) {
            bundle.putCharSequence(FIELD_STATION, this.station);
        }
        if (this.userRating != null) {
            bundle.putBundle(FIELD_USER_RATING, this.userRating.toBundle());
        }
        if (this.overallRating != null) {
            bundle.putBundle(FIELD_OVERALL_RATING, this.overallRating.toBundle());
        }
        if (this.trackNumber != null) {
            bundle.putInt(FIELD_TRACK_NUMBER, this.trackNumber.intValue());
        }
        if (this.totalTrackCount != null) {
            bundle.putInt(FIELD_TOTAL_TRACK_COUNT, this.totalTrackCount.intValue());
        }
        if (this.folderType != null) {
            bundle.putInt(FIELD_FOLDER_TYPE, this.folderType.intValue());
        }
        if (this.isBrowsable != null) {
            bundle.putBoolean(FIELD_IS_BROWSABLE, this.isBrowsable.booleanValue());
        }
        if (this.isPlayable != null) {
            bundle.putBoolean(FIELD_IS_PLAYABLE, this.isPlayable.booleanValue());
        }
        if (this.recordingYear != null) {
            bundle.putInt(FIELD_RECORDING_YEAR, this.recordingYear.intValue());
        }
        if (this.recordingMonth != null) {
            bundle.putInt(FIELD_RECORDING_MONTH, this.recordingMonth.intValue());
        }
        if (this.recordingDay != null) {
            bundle.putInt(FIELD_RECORDING_DAY, this.recordingDay.intValue());
        }
        if (this.releaseYear != null) {
            bundle.putInt(FIELD_RELEASE_YEAR, this.releaseYear.intValue());
        }
        if (this.releaseMonth != null) {
            bundle.putInt(FIELD_RELEASE_MONTH, this.releaseMonth.intValue());
        }
        if (this.releaseDay != null) {
            bundle.putInt(FIELD_RELEASE_DAY, this.releaseDay.intValue());
        }
        if (this.discNumber != null) {
            bundle.putInt(FIELD_DISC_NUMBER, this.discNumber.intValue());
        }
        if (this.totalDiscCount != null) {
            bundle.putInt(FIELD_TOTAL_DISC_COUNT, this.totalDiscCount.intValue());
        }
        if (this.artworkDataType != null) {
            bundle.putInt(FIELD_ARTWORK_DATA_TYPE, this.artworkDataType.intValue());
        }
        if (this.mediaType != null) {
            bundle.putInt(FIELD_MEDIA_TYPE, this.mediaType.intValue());
        }
        if (this.extras != null) {
            bundle.putBundle(FIELD_EXTRAS, this.extras);
        }
        return bundle;
    }

    private static MediaMetadata fromBundle(Bundle bundle) {
        Bundle fieldBundle;
        Builder builder = new Builder();
        builder.setTitle(bundle.getCharSequence(FIELD_TITLE)).setArtist(bundle.getCharSequence(FIELD_ARTIST)).setAlbumTitle(bundle.getCharSequence(FIELD_ALBUM_TITLE)).setAlbumArtist(bundle.getCharSequence(FIELD_ALBUM_ARTIST)).setDisplayTitle(bundle.getCharSequence(FIELD_DISPLAY_TITLE)).setSubtitle(bundle.getCharSequence(FIELD_SUBTITLE)).setDescription(bundle.getCharSequence(FIELD_DESCRIPTION)).setArtworkData(bundle.getByteArray(FIELD_ARTWORK_DATA), bundle.containsKey(FIELD_ARTWORK_DATA_TYPE) ? Integer.valueOf(bundle.getInt(FIELD_ARTWORK_DATA_TYPE)) : null).setArtworkUri((Uri)bundle.getParcelable(FIELD_ARTWORK_URI)).setWriter(bundle.getCharSequence(FIELD_WRITER)).setComposer(bundle.getCharSequence(FIELD_COMPOSER)).setConductor(bundle.getCharSequence(FIELD_CONDUCTOR)).setGenre(bundle.getCharSequence(FIELD_GENRE)).setCompilation(bundle.getCharSequence(FIELD_COMPILATION)).setStation(bundle.getCharSequence(FIELD_STATION)).setExtras(bundle.getBundle(FIELD_EXTRAS));
        if (bundle.containsKey(FIELD_USER_RATING) && (fieldBundle = bundle.getBundle(FIELD_USER_RATING)) != null) {
            builder.setUserRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(FIELD_OVERALL_RATING) && (fieldBundle = bundle.getBundle(FIELD_OVERALL_RATING)) != null) {
            builder.setOverallRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(FIELD_TRACK_NUMBER)) {
            builder.setTrackNumber(bundle.getInt(FIELD_TRACK_NUMBER));
        }
        if (bundle.containsKey(FIELD_TOTAL_TRACK_COUNT)) {
            builder.setTotalTrackCount(bundle.getInt(FIELD_TOTAL_TRACK_COUNT));
        }
        if (bundle.containsKey(FIELD_FOLDER_TYPE)) {
            builder.setFolderType(bundle.getInt(FIELD_FOLDER_TYPE));
        }
        if (bundle.containsKey(FIELD_IS_BROWSABLE)) {
            builder.setIsBrowsable(bundle.getBoolean(FIELD_IS_BROWSABLE));
        }
        if (bundle.containsKey(FIELD_IS_PLAYABLE)) {
            builder.setIsPlayable(bundle.getBoolean(FIELD_IS_PLAYABLE));
        }
        if (bundle.containsKey(FIELD_RECORDING_YEAR)) {
            builder.setRecordingYear(bundle.getInt(FIELD_RECORDING_YEAR));
        }
        if (bundle.containsKey(FIELD_RECORDING_MONTH)) {
            builder.setRecordingMonth(bundle.getInt(FIELD_RECORDING_MONTH));
        }
        if (bundle.containsKey(FIELD_RECORDING_DAY)) {
            builder.setRecordingDay(bundle.getInt(FIELD_RECORDING_DAY));
        }
        if (bundle.containsKey(FIELD_RELEASE_YEAR)) {
            builder.setReleaseYear(bundle.getInt(FIELD_RELEASE_YEAR));
        }
        if (bundle.containsKey(FIELD_RELEASE_MONTH)) {
            builder.setReleaseMonth(bundle.getInt(FIELD_RELEASE_MONTH));
        }
        if (bundle.containsKey(FIELD_RELEASE_DAY)) {
            builder.setReleaseDay(bundle.getInt(FIELD_RELEASE_DAY));
        }
        if (bundle.containsKey(FIELD_DISC_NUMBER)) {
            builder.setDiscNumber(bundle.getInt(FIELD_DISC_NUMBER));
        }
        if (bundle.containsKey(FIELD_TOTAL_DISC_COUNT)) {
            builder.setTotalDiscCount(bundle.getInt(FIELD_TOTAL_DISC_COUNT));
        }
        if (bundle.containsKey(FIELD_MEDIA_TYPE)) {
            builder.setMediaType(bundle.getInt(FIELD_MEDIA_TYPE));
        }
        return builder.build();
    }

    private static int getFolderTypeFromMediaType(int mediaType) {
        switch (mediaType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return 1;
            }
            case 21: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 5;
            }
            case 25: {
                return 6;
            }
        }
        return 0;
    }

    private static int getMediaTypeFromFolderType(int folderType) {
        switch (folderType) {
            case 2: {
                return 21;
            }
            case 3: {
                return 22;
            }
            case 4: {
                return 23;
            }
            case 5: {
                return 24;
            }
            case 1: {
                return 0;
            }
            case 6: {
                return 25;
            }
        }
        return 20;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface PictureType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface FolderType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @UnstableApi
    public static @interface MediaType {
    }

    public static final class Builder {
        @Nullable
        private CharSequence title;
        @Nullable
        private CharSequence artist;
        @Nullable
        private CharSequence albumTitle;
        @Nullable
        private CharSequence albumArtist;
        @Nullable
        private CharSequence displayTitle;
        @Nullable
        private CharSequence subtitle;
        @Nullable
        private CharSequence description;
        @Nullable
        private Rating userRating;
        @Nullable
        private Rating overallRating;
        @Nullable
        private byte[] artworkData;
        @Nullable
        private Integer artworkDataType;
        @Nullable
        private Uri artworkUri;
        @Nullable
        private Integer trackNumber;
        @Nullable
        private Integer totalTrackCount;
        @Nullable
        private Integer folderType;
        @Nullable
        private Boolean isBrowsable;
        @Nullable
        private Boolean isPlayable;
        @Nullable
        private Integer recordingYear;
        @Nullable
        private Integer recordingMonth;
        @Nullable
        private Integer recordingDay;
        @Nullable
        private Integer releaseYear;
        @Nullable
        private Integer releaseMonth;
        @Nullable
        private Integer releaseDay;
        @Nullable
        private CharSequence writer;
        @Nullable
        private CharSequence composer;
        @Nullable
        private CharSequence conductor;
        @Nullable
        private Integer discNumber;
        @Nullable
        private Integer totalDiscCount;
        @Nullable
        private CharSequence genre;
        @Nullable
        private CharSequence compilation;
        @Nullable
        private CharSequence station;
        @Nullable
        private Integer mediaType;
        @Nullable
        private Bundle extras;

        public Builder() {
        }

        private Builder(MediaMetadata mediaMetadata) {
            this.title = mediaMetadata.title;
            this.artist = mediaMetadata.artist;
            this.albumTitle = mediaMetadata.albumTitle;
            this.albumArtist = mediaMetadata.albumArtist;
            this.displayTitle = mediaMetadata.displayTitle;
            this.subtitle = mediaMetadata.subtitle;
            this.description = mediaMetadata.description;
            this.userRating = mediaMetadata.userRating;
            this.overallRating = mediaMetadata.overallRating;
            this.artworkData = mediaMetadata.artworkData;
            this.artworkDataType = mediaMetadata.artworkDataType;
            this.artworkUri = mediaMetadata.artworkUri;
            this.trackNumber = mediaMetadata.trackNumber;
            this.totalTrackCount = mediaMetadata.totalTrackCount;
            this.folderType = mediaMetadata.folderType;
            this.isBrowsable = mediaMetadata.isBrowsable;
            this.isPlayable = mediaMetadata.isPlayable;
            this.recordingYear = mediaMetadata.recordingYear;
            this.recordingMonth = mediaMetadata.recordingMonth;
            this.recordingDay = mediaMetadata.recordingDay;
            this.releaseYear = mediaMetadata.releaseYear;
            this.releaseMonth = mediaMetadata.releaseMonth;
            this.releaseDay = mediaMetadata.releaseDay;
            this.writer = mediaMetadata.writer;
            this.composer = mediaMetadata.composer;
            this.conductor = mediaMetadata.conductor;
            this.discNumber = mediaMetadata.discNumber;
            this.totalDiscCount = mediaMetadata.totalDiscCount;
            this.genre = mediaMetadata.genre;
            this.compilation = mediaMetadata.compilation;
            this.station = mediaMetadata.station;
            this.mediaType = mediaMetadata.mediaType;
            this.extras = mediaMetadata.extras;
        }

        @CanIgnoreReturnValue
        public Builder setTitle(@Nullable CharSequence title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setArtist(@Nullable CharSequence artist) {
            this.artist = artist;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAlbumTitle(@Nullable CharSequence albumTitle) {
            this.albumTitle = albumTitle;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAlbumArtist(@Nullable CharSequence albumArtist) {
            this.albumArtist = albumArtist;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDisplayTitle(@Nullable CharSequence displayTitle) {
            this.displayTitle = displayTitle;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDescription(@Nullable CharSequence description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUserRating(@Nullable Rating userRating) {
            this.userRating = userRating;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOverallRating(@Nullable Rating overallRating) {
            this.overallRating = overallRating;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setArtworkData(@Nullable byte[] artworkData) {
            return this.setArtworkData(artworkData, null);
        }

        @CanIgnoreReturnValue
        public Builder setArtworkData(@Nullable byte[] artworkData, @Nullable Integer artworkDataType) {
            this.artworkData = artworkData == null ? null : (byte[])artworkData.clone();
            this.artworkDataType = artworkDataType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maybeSetArtworkData(byte[] artworkData, int artworkDataType) {
            if (this.artworkData == null || Util.areEqual(artworkDataType, 3) || !Util.areEqual(this.artworkDataType, 3)) {
                this.artworkData = (byte[])artworkData.clone();
                this.artworkDataType = artworkDataType;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setArtworkUri(@Nullable Uri artworkUri) {
            this.artworkUri = artworkUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTrackNumber(@Nullable Integer trackNumber) {
            this.trackNumber = trackNumber;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTotalTrackCount(@Nullable Integer totalTrackCount) {
            this.totalTrackCount = totalTrackCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFolderType(@Nullable Integer folderType) {
            this.folderType = folderType;
            return this;
        }

        @UnstableApi
        @CanIgnoreReturnValue
        public Builder setIsBrowsable(@Nullable Boolean isBrowsable) {
            this.isBrowsable = isBrowsable;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsPlayable(@Nullable Boolean isPlayable) {
            this.isPlayable = isPlayable;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setYear(@Nullable Integer year) {
            return this.setRecordingYear(year);
        }

        @CanIgnoreReturnValue
        public Builder setRecordingYear(@Nullable Integer recordingYear) {
            this.recordingYear = recordingYear;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRecordingMonth(@Nullable @IntRange(from=1L, to=12L) Integer recordingMonth) {
            this.recordingMonth = recordingMonth;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRecordingDay(@Nullable @IntRange(from=1L, to=31L) Integer recordingDay) {
            this.recordingDay = recordingDay;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReleaseYear(@Nullable Integer releaseYear) {
            this.releaseYear = releaseYear;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReleaseMonth(@Nullable @IntRange(from=1L, to=12L) Integer releaseMonth) {
            this.releaseMonth = releaseMonth;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReleaseDay(@Nullable @IntRange(from=1L, to=31L) Integer releaseDay) {
            this.releaseDay = releaseDay;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriter(@Nullable CharSequence writer) {
            this.writer = writer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setComposer(@Nullable CharSequence composer) {
            this.composer = composer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConductor(@Nullable CharSequence conductor) {
            this.conductor = conductor;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDiscNumber(@Nullable Integer discNumber) {
            this.discNumber = discNumber;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTotalDiscCount(@Nullable Integer totalDiscCount) {
            this.totalDiscCount = totalDiscCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGenre(@Nullable CharSequence genre) {
            this.genre = genre;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCompilation(@Nullable CharSequence compilation) {
            this.compilation = compilation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setStation(@Nullable CharSequence station) {
            this.station = station;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setMediaType(@Nullable Integer mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExtras(@Nullable Bundle extras) {
            this.extras = extras;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder populateFromMetadata(Metadata metadata) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                entry.populateMediaMetadata(this);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder populateFromMetadata(List<Metadata> metadataList) {
            for (int i = 0; i < metadataList.size(); ++i) {
                Metadata metadata = metadataList.get(i);
                for (int j = 0; j < metadata.length(); ++j) {
                    Metadata.Entry entry = metadata.get(j);
                    entry.populateMediaMetadata(this);
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder populate(@Nullable MediaMetadata mediaMetadata) {
            if (mediaMetadata == null) {
                return this;
            }
            if (mediaMetadata.title != null) {
                this.setTitle(mediaMetadata.title);
            }
            if (mediaMetadata.artist != null) {
                this.setArtist(mediaMetadata.artist);
            }
            if (mediaMetadata.albumTitle != null) {
                this.setAlbumTitle(mediaMetadata.albumTitle);
            }
            if (mediaMetadata.albumArtist != null) {
                this.setAlbumArtist(mediaMetadata.albumArtist);
            }
            if (mediaMetadata.displayTitle != null) {
                this.setDisplayTitle(mediaMetadata.displayTitle);
            }
            if (mediaMetadata.subtitle != null) {
                this.setSubtitle(mediaMetadata.subtitle);
            }
            if (mediaMetadata.description != null) {
                this.setDescription(mediaMetadata.description);
            }
            if (mediaMetadata.userRating != null) {
                this.setUserRating(mediaMetadata.userRating);
            }
            if (mediaMetadata.overallRating != null) {
                this.setOverallRating(mediaMetadata.overallRating);
            }
            if (mediaMetadata.artworkData != null) {
                this.setArtworkData(mediaMetadata.artworkData, mediaMetadata.artworkDataType);
            }
            if (mediaMetadata.artworkUri != null) {
                this.setArtworkUri(mediaMetadata.artworkUri);
            }
            if (mediaMetadata.trackNumber != null) {
                this.setTrackNumber(mediaMetadata.trackNumber);
            }
            if (mediaMetadata.totalTrackCount != null) {
                this.setTotalTrackCount(mediaMetadata.totalTrackCount);
            }
            if (mediaMetadata.folderType != null) {
                this.setFolderType(mediaMetadata.folderType);
            }
            if (mediaMetadata.isBrowsable != null) {
                this.setIsBrowsable(mediaMetadata.isBrowsable);
            }
            if (mediaMetadata.isPlayable != null) {
                this.setIsPlayable(mediaMetadata.isPlayable);
            }
            if (mediaMetadata.year != null) {
                this.setRecordingYear(mediaMetadata.year);
            }
            if (mediaMetadata.recordingYear != null) {
                this.setRecordingYear(mediaMetadata.recordingYear);
            }
            if (mediaMetadata.recordingMonth != null) {
                this.setRecordingMonth(mediaMetadata.recordingMonth);
            }
            if (mediaMetadata.recordingDay != null) {
                this.setRecordingDay(mediaMetadata.recordingDay);
            }
            if (mediaMetadata.releaseYear != null) {
                this.setReleaseYear(mediaMetadata.releaseYear);
            }
            if (mediaMetadata.releaseMonth != null) {
                this.setReleaseMonth(mediaMetadata.releaseMonth);
            }
            if (mediaMetadata.releaseDay != null) {
                this.setReleaseDay(mediaMetadata.releaseDay);
            }
            if (mediaMetadata.writer != null) {
                this.setWriter(mediaMetadata.writer);
            }
            if (mediaMetadata.composer != null) {
                this.setComposer(mediaMetadata.composer);
            }
            if (mediaMetadata.conductor != null) {
                this.setConductor(mediaMetadata.conductor);
            }
            if (mediaMetadata.discNumber != null) {
                this.setDiscNumber(mediaMetadata.discNumber);
            }
            if (mediaMetadata.totalDiscCount != null) {
                this.setTotalDiscCount(mediaMetadata.totalDiscCount);
            }
            if (mediaMetadata.genre != null) {
                this.setGenre(mediaMetadata.genre);
            }
            if (mediaMetadata.compilation != null) {
                this.setCompilation(mediaMetadata.compilation);
            }
            if (mediaMetadata.station != null) {
                this.setStation(mediaMetadata.station);
            }
            if (mediaMetadata.mediaType != null) {
                this.setMediaType(mediaMetadata.mediaType);
            }
            if (mediaMetadata.extras != null) {
                this.setExtras(mediaMetadata.extras);
            }
            return this;
        }

        public MediaMetadata build() {
            return new MediaMetadata(this);
        }
    }
}

