/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import androidx.media3.common.ColorInfo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public class FrameInfo {
    public final ColorInfo colorInfo;
    public final int width;
    public final int height;
    public final float pixelWidthHeightRatio;
    public final long offsetToAddUs;

    private FrameInfo(ColorInfo colorInfo, int width, int height, float pixelWidthHeightRatio, long offsetToAddUs) {
        Assertions.checkArgument(width > 0, "width must be positive, but is: " + width);
        Assertions.checkArgument(height > 0, "height must be positive, but is: " + height);
        this.colorInfo = colorInfo;
        this.width = width;
        this.height = height;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.offsetToAddUs = offsetToAddUs;
    }

    public static final class Builder {
        private ColorInfo colorInfo;
        private int width;
        private int height;
        private float pixelWidthHeightRatio;
        private long offsetToAddUs;

        public Builder(ColorInfo colorInfo, int width, int height) {
            this.colorInfo = colorInfo;
            this.width = width;
            this.height = height;
            this.pixelWidthHeightRatio = 1.0f;
        }

        public Builder(FrameInfo frameInfo) {
            this.colorInfo = frameInfo.colorInfo;
            this.width = frameInfo.width;
            this.height = frameInfo.height;
            this.pixelWidthHeightRatio = frameInfo.pixelWidthHeightRatio;
            this.offsetToAddUs = frameInfo.offsetToAddUs;
        }

        @CanIgnoreReturnValue
        public Builder setColorInfo(ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPixelWidthHeightRatio(float pixelWidthHeightRatio) {
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOffsetToAddUs(long offsetToAddUs) {
            this.offsetToAddUs = offsetToAddUs;
            return this;
        }

        public FrameInfo build() {
            return new FrameInfo(this.colorInfo, this.width, this.height, this.pixelWidthHeightRatio, this.offsetToAddUs);
        }
    }
}

