/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.text;

import android.os.Bundle;
import androidx.media3.common.Bundleable;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class CueGroup
implements Bundleable {
    @UnstableApi
    public static final CueGroup EMPTY_TIME_ZERO = new CueGroup((List<Cue>)ImmutableList.of(), 0L);
    public final ImmutableList<Cue> cues;
    @UnstableApi
    public final long presentationTimeUs;
    private static final String FIELD_CUES = Util.intToStringMaxRadix(0);
    private static final String FIELD_PRESENTATION_TIME_US = Util.intToStringMaxRadix(1);
    @Deprecated
    @UnstableApi
    public static final Bundleable.Creator<CueGroup> CREATOR = CueGroup::fromBundle;

    @UnstableApi
    public CueGroup(List<Cue> cues, long presentationTimeUs) {
        this.cues = ImmutableList.copyOf(cues);
        this.presentationTimeUs = presentationTimeUs;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(FIELD_CUES, BundleCollectionUtil.toBundleArrayList(CueGroup.filterOutBitmapCues(this.cues), Cue::toBinderBasedBundle));
        bundle.putLong(FIELD_PRESENTATION_TIME_US, this.presentationTimeUs);
        return bundle;
    }

    @UnstableApi
    public static CueGroup fromBundle(Bundle bundle) {
        ArrayList cueBundles = bundle.getParcelableArrayList(FIELD_CUES);
        ImmutableList cues = cueBundles == null ? ImmutableList.of() : BundleCollectionUtil.fromBundleList(Cue::fromBundle, cueBundles);
        long presentationTimeUs = bundle.getLong(FIELD_PRESENTATION_TIME_US);
        return new CueGroup((List<Cue>)cues, presentationTimeUs);
    }

    private static ImmutableList<Cue> filterOutBitmapCues(List<Cue> cues) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < cues.size(); ++i) {
            if (cues.get((int)i).bitmap != null) continue;
            builder.add((Object)cues.get(i));
        }
        return builder.build();
    }
}

