/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Bundleable;
import androidx.media3.common.DeviceInfo;
import androidx.media3.common.FlagSet;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.VideoSize;
import androidx.media3.common.text.Cue;
import androidx.media3.common.text.CueGroup;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Objects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

public interface Player {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_USER_REQUEST = 1;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_FOCUS_LOSS = 2;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_BECOMING_NOISY = 3;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_REMOTE = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_END_OF_MEDIA_ITEM = 5;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_SUPPRESSED_TOO_LONG = 6;
    public static final int PLAYBACK_SUPPRESSION_REASON_NONE = 0;
    public static final int PLAYBACK_SUPPRESSION_REASON_TRANSIENT_AUDIO_FOCUS_LOSS = 1;
    @Deprecated
    public static final int PLAYBACK_SUPPRESSION_REASON_UNSUITABLE_AUDIO_ROUTE = 2;
    public static final int PLAYBACK_SUPPRESSION_REASON_UNSUITABLE_AUDIO_OUTPUT = 3;
    public static final int REPEAT_MODE_OFF = 0;
    public static final int REPEAT_MODE_ONE = 1;
    public static final int REPEAT_MODE_ALL = 2;
    public static final int DISCONTINUITY_REASON_AUTO_TRANSITION = 0;
    public static final int DISCONTINUITY_REASON_SEEK = 1;
    public static final int DISCONTINUITY_REASON_SEEK_ADJUSTMENT = 2;
    public static final int DISCONTINUITY_REASON_SKIP = 3;
    public static final int DISCONTINUITY_REASON_REMOVE = 4;
    public static final int DISCONTINUITY_REASON_INTERNAL = 5;
    public static final int DISCONTINUITY_REASON_SILENCE_SKIP = 6;
    public static final int TIMELINE_CHANGE_REASON_PLAYLIST_CHANGED = 0;
    public static final int TIMELINE_CHANGE_REASON_SOURCE_UPDATE = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_REPEAT = 0;
    public static final int MEDIA_ITEM_TRANSITION_REASON_AUTO = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_SEEK = 2;
    public static final int MEDIA_ITEM_TRANSITION_REASON_PLAYLIST_CHANGED = 3;
    public static final int EVENT_TIMELINE_CHANGED = 0;
    public static final int EVENT_MEDIA_ITEM_TRANSITION = 1;
    public static final int EVENT_TRACKS_CHANGED = 2;
    public static final int EVENT_IS_LOADING_CHANGED = 3;
    public static final int EVENT_PLAYBACK_STATE_CHANGED = 4;
    public static final int EVENT_PLAY_WHEN_READY_CHANGED = 5;
    public static final int EVENT_PLAYBACK_SUPPRESSION_REASON_CHANGED = 6;
    public static final int EVENT_IS_PLAYING_CHANGED = 7;
    public static final int EVENT_REPEAT_MODE_CHANGED = 8;
    public static final int EVENT_SHUFFLE_MODE_ENABLED_CHANGED = 9;
    public static final int EVENT_PLAYER_ERROR = 10;
    public static final int EVENT_POSITION_DISCONTINUITY = 11;
    public static final int EVENT_PLAYBACK_PARAMETERS_CHANGED = 12;
    public static final int EVENT_AVAILABLE_COMMANDS_CHANGED = 13;
    public static final int EVENT_MEDIA_METADATA_CHANGED = 14;
    public static final int EVENT_PLAYLIST_METADATA_CHANGED = 15;
    public static final int EVENT_SEEK_BACK_INCREMENT_CHANGED = 16;
    public static final int EVENT_SEEK_FORWARD_INCREMENT_CHANGED = 17;
    public static final int EVENT_MAX_SEEK_TO_PREVIOUS_POSITION_CHANGED = 18;
    public static final int EVENT_TRACK_SELECTION_PARAMETERS_CHANGED = 19;
    public static final int EVENT_AUDIO_ATTRIBUTES_CHANGED = 20;
    public static final int EVENT_AUDIO_SESSION_ID = 21;
    public static final int EVENT_VOLUME_CHANGED = 22;
    public static final int EVENT_SKIP_SILENCE_ENABLED_CHANGED = 23;
    public static final int EVENT_SURFACE_SIZE_CHANGED = 24;
    public static final int EVENT_VIDEO_SIZE_CHANGED = 25;
    public static final int EVENT_RENDERED_FIRST_FRAME = 26;
    public static final int EVENT_CUES = 27;
    public static final int EVENT_METADATA = 28;
    public static final int EVENT_DEVICE_INFO_CHANGED = 29;
    public static final int EVENT_DEVICE_VOLUME_CHANGED = 30;
    public static final int COMMAND_PLAY_PAUSE = 1;
    public static final int COMMAND_PREPARE = 2;
    public static final int COMMAND_STOP = 3;
    public static final int COMMAND_SEEK_TO_DEFAULT_POSITION = 4;
    public static final int COMMAND_SEEK_IN_CURRENT_MEDIA_ITEM = 5;
    @Deprecated
    @UnstableApi
    public static final int COMMAND_SEEK_IN_CURRENT_WINDOW = 5;
    public static final int COMMAND_SEEK_TO_PREVIOUS_MEDIA_ITEM = 6;
    @Deprecated
    @UnstableApi
    public static final int COMMAND_SEEK_TO_PREVIOUS_WINDOW = 6;
    public static final int COMMAND_SEEK_TO_PREVIOUS = 7;
    public static final int COMMAND_SEEK_TO_NEXT_MEDIA_ITEM = 8;
    @Deprecated
    @UnstableApi
    public static final int COMMAND_SEEK_TO_NEXT_WINDOW = 8;
    public static final int COMMAND_SEEK_TO_NEXT = 9;
    public static final int COMMAND_SEEK_TO_MEDIA_ITEM = 10;
    @Deprecated
    @UnstableApi
    public static final int COMMAND_SEEK_TO_WINDOW = 10;
    public static final int COMMAND_SEEK_BACK = 11;
    public static final int COMMAND_SEEK_FORWARD = 12;
    public static final int COMMAND_SET_SPEED_AND_PITCH = 13;
    public static final int COMMAND_SET_SHUFFLE_MODE = 14;
    public static final int COMMAND_SET_REPEAT_MODE = 15;
    public static final int COMMAND_GET_CURRENT_MEDIA_ITEM = 16;
    public static final int COMMAND_GET_TIMELINE = 17;
    @Deprecated
    public static final int COMMAND_GET_MEDIA_ITEMS_METADATA = 18;
    public static final int COMMAND_GET_METADATA = 18;
    @Deprecated
    public static final int COMMAND_SET_MEDIA_ITEMS_METADATA = 19;
    public static final int COMMAND_SET_PLAYLIST_METADATA = 19;
    public static final int COMMAND_SET_MEDIA_ITEM = 31;
    public static final int COMMAND_CHANGE_MEDIA_ITEMS = 20;
    public static final int COMMAND_GET_AUDIO_ATTRIBUTES = 21;
    public static final int COMMAND_GET_VOLUME = 22;
    public static final int COMMAND_GET_DEVICE_VOLUME = 23;
    public static final int COMMAND_SET_VOLUME = 24;
    @Deprecated
    public static final int COMMAND_SET_DEVICE_VOLUME = 25;
    public static final int COMMAND_SET_DEVICE_VOLUME_WITH_FLAGS = 33;
    @Deprecated
    public static final int COMMAND_ADJUST_DEVICE_VOLUME = 26;
    public static final int COMMAND_ADJUST_DEVICE_VOLUME_WITH_FLAGS = 34;
    public static final int COMMAND_SET_AUDIO_ATTRIBUTES = 35;
    public static final int COMMAND_SET_VIDEO_SURFACE = 27;
    public static final int COMMAND_GET_TEXT = 28;
    public static final int COMMAND_SET_TRACK_SELECTION_PARAMETERS = 29;
    public static final int COMMAND_GET_TRACKS = 30;
    public static final int COMMAND_RELEASE = 32;
    public static final int COMMAND_INVALID = -1;

    public Looper getApplicationLooper();

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public void setMediaItems(List<MediaItem> var1);

    public void setMediaItems(List<MediaItem> var1, boolean var2);

    public void setMediaItems(List<MediaItem> var1, int var2, long var3);

    public void setMediaItem(MediaItem var1);

    public void setMediaItem(MediaItem var1, long var2);

    public void setMediaItem(MediaItem var1, boolean var2);

    public void addMediaItem(MediaItem var1);

    public void addMediaItem(int var1, MediaItem var2);

    public void addMediaItems(List<MediaItem> var1);

    public void addMediaItems(int var1, List<MediaItem> var2);

    public void moveMediaItem(int var1, int var2);

    public void moveMediaItems(int var1, int var2, int var3);

    public void replaceMediaItem(int var1, MediaItem var2);

    public void replaceMediaItems(int var1, int var2, List<MediaItem> var3);

    public void removeMediaItem(int var1);

    public void removeMediaItems(int var1, int var2);

    public void clearMediaItems();

    public boolean isCommandAvailable(int var1);

    public boolean canAdvertiseSession();

    public Commands getAvailableCommands();

    public void prepare();

    public int getPlaybackState();

    public int getPlaybackSuppressionReason();

    public boolean isPlaying();

    @Nullable
    public PlaybackException getPlayerError();

    public void play();

    public void pause();

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public void setRepeatMode(int var1);

    public int getRepeatMode();

    public void setShuffleModeEnabled(boolean var1);

    public boolean getShuffleModeEnabled();

    public boolean isLoading();

    public void seekToDefaultPosition();

    public void seekToDefaultPosition(int var1);

    public void seekTo(long var1);

    public void seekTo(int var1, long var2);

    public long getSeekBackIncrement();

    public void seekBack();

    public long getSeekForwardIncrement();

    public void seekForward();

    @Deprecated
    @UnstableApi
    public boolean hasPrevious();

    @Deprecated
    @UnstableApi
    public boolean hasPreviousWindow();

    public boolean hasPreviousMediaItem();

    @Deprecated
    @UnstableApi
    public void previous();

    @Deprecated
    @UnstableApi
    public void seekToPreviousWindow();

    public void seekToPreviousMediaItem();

    public long getMaxSeekToPreviousPosition();

    public void seekToPrevious();

    @Deprecated
    @UnstableApi
    public boolean hasNext();

    @Deprecated
    @UnstableApi
    public boolean hasNextWindow();

    public boolean hasNextMediaItem();

    @Deprecated
    @UnstableApi
    public void next();

    @Deprecated
    @UnstableApi
    public void seekToNextWindow();

    public void seekToNextMediaItem();

    public void seekToNext();

    public void setPlaybackParameters(PlaybackParameters var1);

    public void setPlaybackSpeed(@FloatRange(from=0.0, fromInclusive=false) float var1);

    public PlaybackParameters getPlaybackParameters();

    public void stop();

    public void release();

    public Tracks getCurrentTracks();

    public TrackSelectionParameters getTrackSelectionParameters();

    public void setTrackSelectionParameters(TrackSelectionParameters var1);

    public MediaMetadata getMediaMetadata();

    public MediaMetadata getPlaylistMetadata();

    public void setPlaylistMetadata(MediaMetadata var1);

    @UnstableApi
    @Nullable
    public Object getCurrentManifest();

    public Timeline getCurrentTimeline();

    public int getCurrentPeriodIndex();

    @Deprecated
    @UnstableApi
    public int getCurrentWindowIndex();

    public int getCurrentMediaItemIndex();

    @Deprecated
    @UnstableApi
    public int getNextWindowIndex();

    public int getNextMediaItemIndex();

    @Deprecated
    @UnstableApi
    public int getPreviousWindowIndex();

    public int getPreviousMediaItemIndex();

    @Nullable
    public MediaItem getCurrentMediaItem();

    public int getMediaItemCount();

    public MediaItem getMediaItemAt(int var1);

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    @IntRange(from=0L, to=100L)
    public int getBufferedPercentage();

    public long getTotalBufferedDuration();

    @Deprecated
    @UnstableApi
    public boolean isCurrentWindowDynamic();

    public boolean isCurrentMediaItemDynamic();

    @Deprecated
    @UnstableApi
    public boolean isCurrentWindowLive();

    public boolean isCurrentMediaItemLive();

    public long getCurrentLiveOffset();

    @Deprecated
    @UnstableApi
    public boolean isCurrentWindowSeekable();

    public boolean isCurrentMediaItemSeekable();

    public boolean isPlayingAd();

    public int getCurrentAdGroupIndex();

    public int getCurrentAdIndexInAdGroup();

    public long getContentDuration();

    public long getContentPosition();

    public long getContentBufferedPosition();

    public AudioAttributes getAudioAttributes();

    public void setVolume(@FloatRange(from=0.0, to=1.0) float var1);

    @FloatRange(from=0.0, to=1.0)
    public float getVolume();

    public void clearVideoSurface();

    public void clearVideoSurface(@Nullable Surface var1);

    public void setVideoSurface(@Nullable Surface var1);

    public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

    public void setVideoSurfaceView(@Nullable SurfaceView var1);

    public void clearVideoSurfaceView(@Nullable SurfaceView var1);

    public void setVideoTextureView(@Nullable TextureView var1);

    public void clearVideoTextureView(@Nullable TextureView var1);

    public VideoSize getVideoSize();

    @UnstableApi
    public Size getSurfaceSize();

    public CueGroup getCurrentCues();

    public DeviceInfo getDeviceInfo();

    @IntRange(from=0L)
    public int getDeviceVolume();

    public boolean isDeviceMuted();

    @Deprecated
    public void setDeviceVolume(@IntRange(from=0L) int var1);

    public void setDeviceVolume(@IntRange(from=0L) int var1, int var2);

    @Deprecated
    public void increaseDeviceVolume();

    public void increaseDeviceVolume(int var1);

    @Deprecated
    public void decreaseDeviceVolume();

    public void decreaseDeviceVolume(int var1);

    @Deprecated
    public void setDeviceMuted(boolean var1);

    public void setDeviceMuted(boolean var1, int var2);

    public void setAudioAttributes(AudioAttributes var1, boolean var2);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface Command {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface Event {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface MediaItemTransitionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface TimelineChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface DiscontinuityReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface RepeatMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface PlaybackSuppressionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface PlayWhenReadyChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface State {
    }

    public static interface Listener {
        default public void onEvents(Player player, Events events) {
        }

        default public void onTimelineChanged(Timeline timeline, int reason) {
        }

        default public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        }

        default public void onTracksChanged(Tracks tracks) {
        }

        default public void onMediaMetadataChanged(MediaMetadata mediaMetadata) {
        }

        default public void onPlaylistMetadataChanged(MediaMetadata mediaMetadata) {
        }

        default public void onIsLoadingChanged(boolean isLoading) {
        }

        @Deprecated
        @UnstableApi
        default public void onLoadingChanged(boolean isLoading) {
        }

        default public void onAvailableCommandsChanged(Commands availableCommands) {
        }

        default public void onTrackSelectionParametersChanged(TrackSelectionParameters parameters) {
        }

        @Deprecated
        @UnstableApi
        default public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        }

        default public void onPlaybackStateChanged(int playbackState) {
        }

        default public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        }

        default public void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
        }

        default public void onIsPlayingChanged(boolean isPlaying) {
        }

        default public void onRepeatModeChanged(int repeatMode) {
        }

        default public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        default public void onPlayerError(PlaybackException error) {
        }

        default public void onPlayerErrorChanged(@Nullable PlaybackException error) {
        }

        @Deprecated
        @UnstableApi
        default public void onPositionDiscontinuity(int reason) {
        }

        default public void onPositionDiscontinuity(PositionInfo oldPosition, PositionInfo newPosition, int reason) {
        }

        default public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        default public void onSeekBackIncrementChanged(long seekBackIncrementMs) {
        }

        default public void onSeekForwardIncrementChanged(long seekForwardIncrementMs) {
        }

        default public void onMaxSeekToPreviousPositionChanged(long maxSeekToPreviousPositionMs) {
        }

        @UnstableApi
        default public void onAudioSessionIdChanged(int audioSessionId) {
        }

        default public void onAudioAttributesChanged(AudioAttributes audioAttributes) {
        }

        default public void onVolumeChanged(float volume) {
        }

        default public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
        }

        default public void onDeviceInfoChanged(DeviceInfo deviceInfo) {
        }

        default public void onDeviceVolumeChanged(int volume, boolean muted) {
        }

        default public void onVideoSizeChanged(VideoSize videoSize) {
        }

        default public void onSurfaceSizeChanged(int width, int height) {
        }

        default public void onRenderedFirstFrame() {
        }

        @Deprecated
        @UnstableApi
        default public void onCues(List<Cue> cues) {
        }

        default public void onCues(CueGroup cueGroup) {
        }

        @UnstableApi
        default public void onMetadata(Metadata metadata) {
        }
    }

    public static final class Commands
    implements Bundleable {
        public static final Commands EMPTY = new Builder().build();
        private final FlagSet flags;
        private static final String FIELD_COMMANDS = Util.intToStringMaxRadix(0);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<Commands> CREATOR = Commands::fromBundle;

        private Commands(FlagSet flags) {
            this.flags = flags;
        }

        @UnstableApi
        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean contains(int command) {
            return this.flags.contains(command);
        }

        public boolean containsAny(int ... commands) {
            return this.flags.containsAny(commands);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Commands)) {
                return false;
            }
            Commands commands = (Commands)obj;
            return this.flags.equals(commands.flags);
        }

        public int hashCode() {
            return this.flags.hashCode();
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            ArrayList<Integer> commandsBundle = new ArrayList<Integer>();
            for (int i = 0; i < this.flags.size(); ++i) {
                commandsBundle.add(this.flags.get(i));
            }
            bundle.putIntegerArrayList(FIELD_COMMANDS, commandsBundle);
            return bundle;
        }

        @UnstableApi
        public static Commands fromBundle(Bundle bundle) {
            ArrayList commands = bundle.getIntegerArrayList(FIELD_COMMANDS);
            if (commands == null) {
                return EMPTY;
            }
            Builder builder = new Builder();
            for (int i = 0; i < commands.size(); ++i) {
                builder.add((Integer)commands.get(i));
            }
            return builder.build();
        }

        @UnstableApi
        public static final class Builder {
            private static final int[] SUPPORTED_COMMANDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 31, 20, 21, 22, 23, 24, 25, 33, 26, 34, 35, 27, 28, 29, 30, 32};
            private final FlagSet.Builder flagsBuilder = new FlagSet.Builder();

            public Builder() {
            }

            private Builder(Commands commands) {
                this.flagsBuilder.addAll(commands.flags);
            }

            @CanIgnoreReturnValue
            public Builder add(int command) {
                this.flagsBuilder.add(command);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addIf(int command, boolean condition) {
                this.flagsBuilder.addIf(command, condition);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addAll(int ... commands) {
                this.flagsBuilder.addAll(commands);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addAll(Commands commands) {
                this.flagsBuilder.addAll(commands.flags);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addAllCommands() {
                this.flagsBuilder.addAll(SUPPORTED_COMMANDS);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder remove(int command) {
                this.flagsBuilder.remove(command);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder removeIf(int command, boolean condition) {
                this.flagsBuilder.removeIf(command, condition);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder removeAll(int ... commands) {
                this.flagsBuilder.removeAll(commands);
                return this;
            }

            public Commands build() {
                return new Commands(this.flagsBuilder.build());
            }
        }
    }

    public static final class PositionInfo
    implements Bundleable {
        @Nullable
        public final Object windowUid;
        @Deprecated
        @UnstableApi
        public final int windowIndex;
        public final int mediaItemIndex;
        @UnstableApi
        @Nullable
        public final MediaItem mediaItem;
        @Nullable
        public final Object periodUid;
        public final int periodIndex;
        public final long positionMs;
        public final long contentPositionMs;
        public final int adGroupIndex;
        public final int adIndexInAdGroup;
        @VisibleForTesting
        static final String FIELD_MEDIA_ITEM_INDEX = Util.intToStringMaxRadix(0);
        private static final String FIELD_MEDIA_ITEM = Util.intToStringMaxRadix(1);
        @VisibleForTesting
        static final String FIELD_PERIOD_INDEX = Util.intToStringMaxRadix(2);
        @VisibleForTesting
        static final String FIELD_POSITION_MS = Util.intToStringMaxRadix(3);
        @VisibleForTesting
        static final String FIELD_CONTENT_POSITION_MS = Util.intToStringMaxRadix(4);
        private static final String FIELD_AD_GROUP_INDEX = Util.intToStringMaxRadix(5);
        private static final String FIELD_AD_INDEX_IN_AD_GROUP = Util.intToStringMaxRadix(6);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<PositionInfo> CREATOR = PositionInfo::fromBundle;

        @Deprecated
        @UnstableApi
        public PositionInfo(@Nullable Object windowUid, int mediaItemIndex, @Nullable Object periodUid, int periodIndex, long positionMs, long contentPositionMs, int adGroupIndex, int adIndexInAdGroup) {
            this(windowUid, mediaItemIndex, MediaItem.EMPTY, periodUid, periodIndex, positionMs, contentPositionMs, adGroupIndex, adIndexInAdGroup);
        }

        @UnstableApi
        public PositionInfo(@Nullable Object windowUid, int mediaItemIndex, @Nullable MediaItem mediaItem, @Nullable Object periodUid, int periodIndex, long positionMs, long contentPositionMs, int adGroupIndex, int adIndexInAdGroup) {
            this.windowUid = windowUid;
            this.windowIndex = mediaItemIndex;
            this.mediaItemIndex = mediaItemIndex;
            this.mediaItem = mediaItem;
            this.periodUid = periodUid;
            this.periodIndex = periodIndex;
            this.positionMs = positionMs;
            this.contentPositionMs = contentPositionMs;
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionInfo that = (PositionInfo)o;
            return this.equalsForBundling(that) && Objects.equal((Object)this.windowUid, (Object)that.windowUid) && Objects.equal((Object)this.periodUid, (Object)that.periodUid);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.windowUid, this.mediaItemIndex, this.mediaItem, this.periodUid, this.periodIndex, this.positionMs, this.contentPositionMs, this.adGroupIndex, this.adIndexInAdGroup});
        }

        @UnstableApi
        public boolean equalsForBundling(PositionInfo other) {
            return this.mediaItemIndex == other.mediaItemIndex && this.periodIndex == other.periodIndex && this.positionMs == other.positionMs && this.contentPositionMs == other.contentPositionMs && this.adGroupIndex == other.adGroupIndex && this.adIndexInAdGroup == other.adIndexInAdGroup && Objects.equal((Object)this.mediaItem, (Object)other.mediaItem);
        }

        @UnstableApi
        public PositionInfo filterByAvailableCommands(boolean canAccessCurrentMediaItem, boolean canAccessTimeline) {
            if (canAccessCurrentMediaItem && canAccessTimeline) {
                return this;
            }
            return new PositionInfo(this.windowUid, canAccessTimeline ? this.mediaItemIndex : 0, canAccessCurrentMediaItem ? this.mediaItem : null, this.periodUid, canAccessTimeline ? this.periodIndex : 0, canAccessCurrentMediaItem ? this.positionMs : 0L, canAccessCurrentMediaItem ? this.contentPositionMs : 0L, canAccessCurrentMediaItem ? this.adGroupIndex : -1, canAccessCurrentMediaItem ? this.adIndexInAdGroup : -1);
        }

        @UnstableApi
        public Bundle toBundle(int controllerInterfaceVersion) {
            Bundle bundle = new Bundle();
            if (controllerInterfaceVersion < 3 || this.mediaItemIndex != 0) {
                bundle.putInt(FIELD_MEDIA_ITEM_INDEX, this.mediaItemIndex);
            }
            if (this.mediaItem != null) {
                bundle.putBundle(FIELD_MEDIA_ITEM, this.mediaItem.toBundle());
            }
            if (controllerInterfaceVersion < 3 || this.periodIndex != 0) {
                bundle.putInt(FIELD_PERIOD_INDEX, this.periodIndex);
            }
            if (controllerInterfaceVersion < 3 || this.positionMs != 0L) {
                bundle.putLong(FIELD_POSITION_MS, this.positionMs);
            }
            if (controllerInterfaceVersion < 3 || this.contentPositionMs != 0L) {
                bundle.putLong(FIELD_CONTENT_POSITION_MS, this.contentPositionMs);
            }
            if (this.adGroupIndex != -1) {
                bundle.putInt(FIELD_AD_GROUP_INDEX, this.adGroupIndex);
            }
            if (this.adIndexInAdGroup != -1) {
                bundle.putInt(FIELD_AD_INDEX_IN_AD_GROUP, this.adIndexInAdGroup);
            }
            return bundle;
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            return this.toBundle(Integer.MAX_VALUE);
        }

        @UnstableApi
        public static PositionInfo fromBundle(Bundle bundle) {
            int mediaItemIndex = bundle.getInt(FIELD_MEDIA_ITEM_INDEX, 0);
            Bundle mediaItemBundle = bundle.getBundle(FIELD_MEDIA_ITEM);
            MediaItem mediaItem = mediaItemBundle == null ? null : MediaItem.fromBundle(mediaItemBundle);
            int periodIndex = bundle.getInt(FIELD_PERIOD_INDEX, 0);
            long positionMs = bundle.getLong(FIELD_POSITION_MS, 0L);
            long contentPositionMs = bundle.getLong(FIELD_CONTENT_POSITION_MS, 0L);
            int adGroupIndex = bundle.getInt(FIELD_AD_GROUP_INDEX, -1);
            int adIndexInAdGroup = bundle.getInt(FIELD_AD_INDEX_IN_AD_GROUP, -1);
            return new PositionInfo(null, mediaItemIndex, mediaItem, null, periodIndex, positionMs, contentPositionMs, adGroupIndex, adIndexInAdGroup);
        }
    }

    public static final class Events {
        private final FlagSet flags;

        @UnstableApi
        public Events(FlagSet flags) {
            this.flags = flags;
        }

        public boolean contains(int event) {
            return this.flags.contains(event);
        }

        public boolean containsAny(int ... events) {
            return this.flags.containsAny(events);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }

        public int hashCode() {
            return this.flags.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Events)) {
                return false;
            }
            Events other = (Events)obj;
            return this.flags.equals(other.flags);
        }
    }
}

