/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.Effect;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.OnInputFrameProcessedListener;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.concurrent.Executor;

@UnstableApi
public interface VideoFrameProcessor {
    public static final int INPUT_TYPE_SURFACE = 1;
    public static final int INPUT_TYPE_BITMAP = 2;
    public static final int INPUT_TYPE_TEXTURE_ID = 3;
    public static final long RENDER_OUTPUT_FRAME_IMMEDIATELY = -1L;
    public static final long DROP_OUTPUT_FRAME = -2L;

    public boolean queueInputBitmap(Bitmap var1, TimestampIterator var2);

    public boolean queueInputTexture(int var1, long var2);

    public void setOnInputFrameProcessedListener(OnInputFrameProcessedListener var1);

    public Surface getInputSurface();

    public void registerInputStream(int var1, List<Effect> var2, FrameInfo var3);

    public boolean registerInputFrame();

    public int getPendingInputFrameCount();

    public void setOutputSurfaceInfo(@Nullable SurfaceInfo var1);

    public void renderOutputFrame(long var1);

    public void signalEndOfInput();

    public void flush();

    public void release();

    public static interface Listener {
        public void onInputStreamRegistered(int var1, List<Effect> var2, FrameInfo var3);

        public void onOutputSizeChanged(int var1, int var2);

        public void onOutputFrameAvailableForRendering(long var1);

        public void onError(VideoFrameProcessingException var1);

        public void onEnded();
    }

    public static interface Factory {
        public VideoFrameProcessor create(Context var1, DebugViewProvider var2, ColorInfo var3, boolean var4, Executor var5, Listener var6) throws VideoFrameProcessingException;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface InputType {
    }
}

