/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class Size {
    public static final Size UNKNOWN = new Size(-1, -1);
    public static final Size ZERO = new Size(0, 0);
    private final int width;
    private final int height;

    public Size(int width, int height) {
        Assertions.checkArgument(!(width != -1 && width < 0 || height != -1 && height < 0));
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size other = (Size)obj;
            return this.width == other.width && this.height == other.height;
        }
        return false;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    public int hashCode() {
        return this.height ^ (this.width << 16 | this.width >>> 16);
    }
}

