/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.List;

@UnstableApi
public final class BundleListRetriever
extends Binder {
    private static final int SUGGESTED_MAX_IPC_SIZE = Util.SDK_INT >= 30 ? IBinder.getSuggestedMaxIpcSizeBytes() : 65536;
    private static final int REPLY_END_OF_LIST = 0;
    private static final int REPLY_CONTINUE = 1;
    private static final int REPLY_BREAK = 2;
    private final ImmutableList<Bundle> list;

    public BundleListRetriever(List<Bundle> list) {
        this.list = ImmutableList.copyOf(list);
    }

    protected boolean onTransact(int code, Parcel data, @Nullable Parcel reply, int flags) throws RemoteException {
        int index;
        if (code != 1) {
            return super.onTransact(code, data, reply, flags);
        }
        if (reply == null) {
            return false;
        }
        int count = this.list.size();
        for (index = data.readInt(); index < count && reply.dataSize() < SUGGESTED_MAX_IPC_SIZE; ++index) {
            reply.writeInt(1);
            reply.writeBundle((Bundle)this.list.get(index));
        }
        reply.writeInt(index < count ? 2 : 0);
        return true;
    }

    public static ImmutableList<Bundle> getList(IBinder binder) {
        if (binder instanceof BundleListRetriever) {
            return ((BundleListRetriever)binder).list;
        }
        return BundleListRetriever.getListFromRemoteBinder(binder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static ImmutableList<Bundle> getListFromRemoteBinder(IBinder binder) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        int replyCode = 1;
        while (replyCode != 0) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInt(index);
                try {
                    binder.transact(1, data, reply, 0);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
                while ((replyCode = reply.readInt()) == 1) {
                    builder.add((Object)Assertions.checkNotNull(reply.readBundle()));
                    ++index;
                }
            }
            finally {
                reply.recycle();
                data.recycle();
            }
        }
        return builder.build();
    }
}

