/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.CheckResult;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;

public final class PlaybackParameters {
    public static final PlaybackParameters DEFAULT = new PlaybackParameters(1.0f);
    public final float speed;
    public final float pitch;
    private final int scaledUsPerMs;
    private static final String FIELD_SPEED = Util.intToStringMaxRadix(0);
    private static final String FIELD_PITCH = Util.intToStringMaxRadix(1);

    public PlaybackParameters(@FloatRange(from=0.0, fromInclusive=false) float speed) {
        this(speed, 1.0f);
    }

    public PlaybackParameters(@FloatRange(from=0.0, fromInclusive=false) float speed, @FloatRange(from=0.0, fromInclusive=false) float pitch) {
        Assertions.checkArgument(speed > 0.0f);
        Assertions.checkArgument(pitch > 0.0f);
        this.speed = speed;
        this.pitch = pitch;
        this.scaledUsPerMs = Math.round(speed * 1000.0f);
    }

    @UnstableApi
    public long getMediaTimeUsForPlayoutTimeMs(long timeMs) {
        return timeMs * (long)this.scaledUsPerMs;
    }

    @CheckResult
    public PlaybackParameters withSpeed(@FloatRange(from=0.0, fromInclusive=false) float speed) {
        return new PlaybackParameters(speed, this.pitch);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlaybackParameters other = (PlaybackParameters)obj;
        return this.speed == other.speed && this.pitch == other.pitch;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToRawIntBits(this.speed);
        result = 31 * result + Float.floatToRawIntBits(this.pitch);
        return result;
    }

    public String toString() {
        return Util.formatInvariant("PlaybackParameters(speed=%.2f, pitch=%.2f)", Float.valueOf(this.speed), Float.valueOf(this.pitch));
    }

    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putFloat(FIELD_SPEED, this.speed);
        bundle.putFloat(FIELD_PITCH, this.pitch);
        return bundle;
    }

    @UnstableApi
    public static PlaybackParameters fromBundle(Bundle bundle) {
        float speed = bundle.getFloat(FIELD_SPEED, 1.0f);
        float pitch = bundle.getFloat(FIELD_PITCH, 1.0f);
        return new PlaybackParameters(speed, pitch);
    }
}

