/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.media3.common.HeartRating;
import androidx.media3.common.PercentageRating;
import androidx.media3.common.StarRating;
import androidx.media3.common.ThumbRating;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;

public abstract class Rating {
    static final float RATING_UNSET = -1.0f;
    static final int RATING_TYPE_UNSET = -1;
    static final int RATING_TYPE_HEART = 0;
    static final int RATING_TYPE_PERCENTAGE = 1;
    static final int RATING_TYPE_STAR = 2;
    static final int RATING_TYPE_THUMB = 3;
    static final String FIELD_RATING_TYPE = Util.intToStringMaxRadix(0);

    Rating() {
    }

    public abstract boolean isRated();

    @UnstableApi
    public abstract Bundle toBundle();

    @UnstableApi
    public static Rating fromBundle(Bundle bundle) {
        int ratingType = bundle.getInt(FIELD_RATING_TYPE, -1);
        switch (ratingType) {
            case 0: {
                return HeartRating.fromBundle(bundle);
            }
            case 1: {
                return PercentageRating.fromBundle(bundle);
            }
            case 2: {
                return StarRating.fromBundle(bundle);
            }
            case 3: {
                return ThumbRating.fromBundle(bundle);
            }
        }
        throw new IllegalArgumentException("Unknown RatingType: " + ratingType);
    }
}

