/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.primitives.Ints;
import java.util.Arrays;

@UnstableApi
public final class MdtaMetadataEntry
implements Metadata.Entry {
    public static final String KEY_ANDROID_CAPTURE_FPS = "com.android.capture.fps";
    public static final int DEFAULT_LOCALE_INDICATOR = 0;
    public static final int TYPE_INDICATOR_STRING = 1;
    public static final int TYPE_INDICATOR_FLOAT32 = 23;
    public static final int TYPE_INDICATOR_INT32 = 67;
    public final String key;
    public final byte[] value;
    public final int localeIndicator;
    public final int typeIndicator;
    public static final Parcelable.Creator<MdtaMetadataEntry> CREATOR = new Parcelable.Creator<MdtaMetadataEntry>(){

        public MdtaMetadataEntry createFromParcel(Parcel in) {
            return new MdtaMetadataEntry(in);
        }

        public MdtaMetadataEntry[] newArray(int size) {
            return new MdtaMetadataEntry[size];
        }
    };

    public MdtaMetadataEntry(String key, byte[] value, int typeIndicator) {
        this(key, value, 0, typeIndicator);
    }

    public MdtaMetadataEntry(String key, byte[] value, int localeIndicator, int typeIndicator) {
        this.key = key;
        this.value = value;
        this.localeIndicator = localeIndicator;
        this.typeIndicator = typeIndicator;
    }

    private MdtaMetadataEntry(Parcel in) {
        this.key = (String)Util.castNonNull((Object)in.readString());
        this.value = (byte[])Util.castNonNull((Object)in.createByteArray());
        this.localeIndicator = in.readInt();
        this.typeIndicator = in.readInt();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MdtaMetadataEntry other = (MdtaMetadataEntry)obj;
        return this.key.equals(other.key) && Arrays.equals(this.value, other.value) && this.localeIndicator == other.localeIndicator && this.typeIndicator == other.typeIndicator;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + this.localeIndicator;
        result = 31 * result + this.typeIndicator;
        return result;
    }

    public String toString() {
        String formattedValue;
        switch (this.typeIndicator) {
            case 1: {
                formattedValue = Util.fromUtf8Bytes((byte[])this.value);
                break;
            }
            case 23: {
                formattedValue = String.valueOf(Float.intBitsToFloat(Ints.fromByteArray((byte[])this.value)));
                break;
            }
            case 67: {
                formattedValue = String.valueOf(Ints.fromByteArray((byte[])this.value));
                break;
            }
            default: {
                formattedValue = Util.toHexString((byte[])this.value);
            }
        }
        return "mdta: key=" + this.key + ", value=" + formattedValue;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.key);
        dest.writeByteArray(this.value);
        dest.writeInt(this.localeIndicator);
        dest.writeInt(this.typeIndicator);
    }

    public int describeContents() {
        return 0;
    }
}

