/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import com.google.common.base.Ascii;
import com.google.common.base.Predicate;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends DataSource {
    @UnstableApi
    public static final Predicate<String> REJECT_PAYWALL_TYPES = contentType -> {
        if (contentType == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)(contentType = Ascii.toLowerCase((String)contentType))) && (!contentType.contains("text") || contentType.contains("text/vtt")) && !contentType.contains("html") && !contentType.contains("xml");
    };

    @Override
    @UnstableApi
    public long open(DataSpec var1) throws HttpDataSourceException;

    @Override
    @UnstableApi
    public void close() throws HttpDataSourceException;

    @UnstableApi
    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    @UnstableApi
    public void setRequestProperty(String var1, String var2);

    @UnstableApi
    public void clearRequestProperty(String var1);

    @UnstableApi
    public void clearAllRequestProperties();

    @UnstableApi
    public int getResponseCode();

    @Override
    @UnstableApi
    public Map<String, List<String>> getResponseHeaders();

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final int responseCode;
        @Nullable
        public final String responseMessage;
        @UnstableApi
        public final Map<String, List<String>> headerFields;
        public final byte[] responseBody;

        @Deprecated
        @UnstableApi
        public InvalidResponseCodeException(int responseCode, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            this(responseCode, null, null, headerFields, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }

        @Deprecated
        @UnstableApi
        public InvalidResponseCodeException(int responseCode, @Nullable String responseMessage, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            this(responseCode, responseMessage, null, headerFields, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }

        @UnstableApi
        public InvalidResponseCodeException(int responseCode, @Nullable String responseMessage, @Nullable IOException cause, Map<String, List<String>> headerFields, DataSpec dataSpec, byte[] responseBody) {
            super("Response code: " + responseCode, cause, dataSpec, 2004, 1);
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.headerFields = headerFields;
            this.responseBody = responseBody;
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        @UnstableApi
        public InvalidContentTypeException(String contentType, DataSpec dataSpec) {
            super("Invalid content type: " + contentType, dataSpec, 2003, 1);
            this.contentType = contentType;
        }
    }

    public static final class CleartextNotPermittedException
    extends HttpDataSourceException {
        @UnstableApi
        public CleartextNotPermittedException(IOException cause, DataSpec dataSpec) {
            super("Cleartext HTTP traffic not permitted. See https://exoplayer.dev/issues/cleartext-not-permitted", cause, dataSpec, 2007, 1);
        }
    }

    public static class HttpDataSourceException
    extends DataSourceException {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_READ = 2;
        public static final int TYPE_CLOSE = 3;
        @UnstableApi
        public final DataSpec dataSpec;
        public final int type;

        @UnstableApi
        public static HttpDataSourceException createForIOException(IOException cause, DataSpec dataSpec, int type) {
            String message = cause.getMessage();
            int errorCode = cause instanceof SocketTimeoutException ? 2002 : (cause instanceof InterruptedIOException ? 1004 : (message != null && Ascii.toLowerCase((String)message).matches("cleartext.*not permitted.*") ? 2007 : 2001));
            return errorCode == 2007 ? new CleartextNotPermittedException(cause, dataSpec) : new HttpDataSourceException(cause, dataSpec, errorCode, type);
        }

        @Deprecated
        @UnstableApi
        public HttpDataSourceException(DataSpec dataSpec, int type) {
            this(dataSpec, 2000, type);
        }

        @UnstableApi
        public HttpDataSourceException(DataSpec dataSpec, int errorCode, int type) {
            super(HttpDataSourceException.assignErrorCode(errorCode, type));
            this.dataSpec = dataSpec;
            this.type = type;
        }

        @Deprecated
        @UnstableApi
        public HttpDataSourceException(String message, DataSpec dataSpec, int type) {
            this(message, dataSpec, 2000, type);
        }

        @UnstableApi
        public HttpDataSourceException(String message, DataSpec dataSpec, int errorCode, int type) {
            super(message, HttpDataSourceException.assignErrorCode(errorCode, type));
            this.dataSpec = dataSpec;
            this.type = type;
        }

        @Deprecated
        @UnstableApi
        public HttpDataSourceException(IOException cause, DataSpec dataSpec, int type) {
            this(cause, dataSpec, 2000, type);
        }

        @UnstableApi
        public HttpDataSourceException(IOException cause, DataSpec dataSpec, int errorCode, int type) {
            super(cause, HttpDataSourceException.assignErrorCode(errorCode, type));
            this.dataSpec = dataSpec;
            this.type = type;
        }

        @Deprecated
        @UnstableApi
        public HttpDataSourceException(String message, IOException cause, DataSpec dataSpec, int type) {
            this(message, cause, dataSpec, 2000, type);
        }

        @UnstableApi
        public HttpDataSourceException(String message, @Nullable IOException cause, DataSpec dataSpec, int errorCode, int type) {
            super(message, cause, HttpDataSourceException.assignErrorCode(errorCode, type));
            this.dataSpec = dataSpec;
            this.type = type;
        }

        private static int assignErrorCode(int errorCode, int type) {
            return errorCode == 2000 && type == 1 ? 2001 : errorCode;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface Type {
        }
    }

    @UnstableApi
    public static abstract class BaseFactory
    implements Factory {
        private final RequestProperties defaultRequestProperties = new RequestProperties();

        @Override
        public final HttpDataSource createDataSource() {
            return this.createDataSourceInternal(this.defaultRequestProperties);
        }

        @Override
        @CanIgnoreReturnValue
        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        protected abstract HttpDataSource createDataSourceInternal(RequestProperties var1);
    }

    @UnstableApi
    public static final class RequestProperties {
        private final Map<String, String> requestProperties = new HashMap<String, String>();
        @Nullable
        private Map<String, String> requestPropertiesSnapshot;

        public synchronized void set(String name, String value) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.put(name, value);
        }

        public synchronized void set(Map<String, String> properties) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.putAll(properties);
        }

        public synchronized void clearAndSet(Map<String, String> properties) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.clear();
            this.requestProperties.putAll(properties);
        }

        public synchronized void remove(String name) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.remove(name);
        }

        public synchronized void clear() {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.clear();
        }

        public synchronized Map<String, String> getSnapshot() {
            if (this.requestPropertiesSnapshot == null) {
                this.requestPropertiesSnapshot = Collections.unmodifiableMap(new HashMap<String, String>(this.requestProperties));
            }
            return this.requestPropertiesSnapshot;
        }
    }

    public static interface Factory
    extends DataSource.Factory {
        @Override
        @UnstableApi
        public HttpDataSource createDataSource();

        @UnstableApi
        public Factory setDefaultRequestProperties(Map<String, String> var1);
    }
}

