/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import java.util.ArrayList;

@UnstableApi
public abstract class BaseDataSource
implements DataSource {
    private final boolean isNetwork;
    private final ArrayList<TransferListener> listeners;
    private int listenerCount;
    @Nullable
    private DataSpec dataSpec;

    protected BaseDataSource(boolean isNetwork) {
        this.isNetwork = isNetwork;
        this.listeners = new ArrayList(1);
    }

    @Override
    @UnstableApi
    public final void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        if (!this.listeners.contains(transferListener)) {
            this.listeners.add(transferListener);
            ++this.listenerCount;
        }
    }

    protected final void transferInitializing(DataSpec dataSpec) {
        for (int i = 0; i < this.listenerCount; ++i) {
            this.listeners.get(i).onTransferInitializing(this, dataSpec, this.isNetwork);
        }
    }

    protected final void transferStarted(DataSpec dataSpec) {
        this.dataSpec = dataSpec;
        for (int i = 0; i < this.listenerCount; ++i) {
            this.listeners.get(i).onTransferStart(this, dataSpec, this.isNetwork);
        }
    }

    protected final void bytesTransferred(int bytesTransferred) {
        DataSpec dataSpec = (DataSpec)Util.castNonNull((Object)this.dataSpec);
        for (int i = 0; i < this.listenerCount; ++i) {
            this.listeners.get(i).onBytesTransferred(this, dataSpec, this.isNetwork, bytesTransferred);
        }
    }

    protected final void transferEnded() {
        DataSpec dataSpec = (DataSpec)Util.castNonNull((Object)this.dataSpec);
        for (int i = 0; i < this.listenerCount; ++i) {
            this.listeners.get(i).onTransferEnd(this, dataSpec, this.isNetwork);
        }
        this.dataSpec = null;
    }
}

