/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BitmapLoader;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceUtil;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@UnstableApi
public final class DataSourceBitmapLoader
implements BitmapLoader {
    public static final Supplier<ListeningExecutorService> DEFAULT_EXECUTOR_SERVICE = Suppliers.memoize(() -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor()));
    private final ListeningExecutorService listeningExecutorService;
    private final DataSource.Factory dataSourceFactory;
    @Nullable
    private final BitmapFactory.Options options;

    public DataSourceBitmapLoader(Context context) {
        this((ListeningExecutorService)Assertions.checkStateNotNull((Object)((ListeningExecutorService)DEFAULT_EXECUTOR_SERVICE.get())), new DefaultDataSource.Factory(context));
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory) {
        this(listeningExecutorService, dataSourceFactory, null);
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory, @Nullable BitmapFactory.Options options) {
        this.listeningExecutorService = listeningExecutorService;
        this.dataSourceFactory = dataSourceFactory;
        this.options = options;
    }

    public boolean supportsMimeType(String mimeType) {
        return Util.isBitmapFactorySupportedMimeType((String)mimeType);
    }

    public ListenableFuture<Bitmap> decodeBitmap(byte[] data) {
        return this.listeningExecutorService.submit(() -> DataSourceBitmapLoader.decode(data, this.options));
    }

    public ListenableFuture<Bitmap> loadBitmap(Uri uri) {
        return this.listeningExecutorService.submit(() -> DataSourceBitmapLoader.load(this.dataSourceFactory.createDataSource(), uri, this.options));
    }

    private static Bitmap decode(byte[] data, @Nullable BitmapFactory.Options options) throws IOException {
        ExifInterface exifInterface;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        Assertions.checkArgument((bitmap != null ? 1 : 0) != 0, (Object)"Could not decode image data");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            exifInterface = new ExifInterface((InputStream)inputStream);
        }
        int rotationDegrees = exifInterface.getRotationDegrees();
        if (rotationDegrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotationDegrees);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap load(DataSource dataSource, Uri uri, @Nullable BitmapFactory.Options options) throws IOException {
        try {
            DataSpec dataSpec = new DataSpec(uri);
            dataSource.open(dataSpec);
            byte[] readData = DataSourceUtil.readToEnd(dataSource);
            Bitmap bitmap = DataSourceBitmapLoader.decode(readData, options);
            return bitmap;
        }
        finally {
            dataSource.close();
        }
    }
}

