/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.Format;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import java.util.Collections;
import java.util.List;

@UnstableApi
public final class DvbSubtitleReader
implements ElementaryStreamReader {
    private final List<TsPayloadReader.DvbSubtitleInfo> subtitleInfos;
    private final TrackOutput[] outputs;
    private boolean writingSample;
    private int bytesToCheck;
    private int sampleBytesWritten;
    private long sampleTimeUs;

    public DvbSubtitleReader(List<TsPayloadReader.DvbSubtitleInfo> subtitleInfos) {
        this.subtitleInfos = subtitleInfos;
        this.outputs = new TrackOutput[subtitleInfos.size()];
        this.sampleTimeUs = -9223372036854775807L;
    }

    @Override
    public void seek() {
        this.writingSample = false;
        this.sampleTimeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        for (int i = 0; i < this.outputs.length; ++i) {
            TsPayloadReader.DvbSubtitleInfo subtitleInfo = this.subtitleInfos.get(i);
            idGenerator.generateNewId();
            TrackOutput output = extractorOutput.track(idGenerator.getTrackId(), 3);
            output.format(new Format.Builder().setId(idGenerator.getFormatId()).setSampleMimeType("application/dvbsubs").setInitializationData(Collections.singletonList(subtitleInfo.initializationData)).setLanguage(subtitleInfo.language).build());
            this.outputs[i] = output;
        }
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        if ((flags & 4) == 0) {
            return;
        }
        this.writingSample = true;
        if (pesTimeUs != -9223372036854775807L) {
            this.sampleTimeUs = pesTimeUs;
        }
        this.sampleBytesWritten = 0;
        this.bytesToCheck = 2;
    }

    @Override
    public void packetFinished() {
        if (this.writingSample) {
            if (this.sampleTimeUs != -9223372036854775807L) {
                for (TrackOutput output : this.outputs) {
                    output.sampleMetadata(this.sampleTimeUs, 1, this.sampleBytesWritten, 0, null);
                }
            }
            this.writingSample = false;
        }
    }

    @Override
    public void consume(ParsableByteArray data) {
        if (this.writingSample) {
            if (this.bytesToCheck == 2 && !this.checkNextByte(data, 32)) {
                return;
            }
            if (this.bytesToCheck == 1 && !this.checkNextByte(data, 0)) {
                return;
            }
            int dataPosition = data.getPosition();
            int bytesAvailable = data.bytesLeft();
            for (TrackOutput output : this.outputs) {
                data.setPosition(dataPosition);
                output.sampleData(data, bytesAvailable);
            }
            this.sampleBytesWritten += bytesAvailable;
        }
    }

    private boolean checkNextByte(ParsableByteArray data, int expectedValue) {
        if (data.bytesLeft() == 0) {
            return false;
        }
        if (data.readUnsignedByte() != expectedValue) {
            this.writingSample = false;
        }
        --this.bytesToCheck;
        return this.writingSample;
    }
}

